/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.analysis;

import de.obqo.decycle.analysis.GraphBuilder;
import de.obqo.decycle.analysis.GraphBuildingAnnotationVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

class GraphBuildingMethodVisitor
extends MethodVisitor {
    private final GraphBuilder graphBuilder;

    GraphBuildingMethodVisitor(int api, GraphBuilder graphBuilder) {
        super(api);
        this.graphBuilder = graphBuilder;
    }

    private GraphBuildingAnnotationVisitor annotationVisitor() {
        return new GraphBuildingAnnotationVisitor(this.api, this.graphBuilder);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.annotationVisitor();
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return this.annotationVisitor();
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return this.annotationVisitor();
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return this.annotationVisitor();
    }

    public void visitTypeInsn(int opcode, String type) {
        this.graphBuilder.connect(GraphBuilder.classNodeFromSingleType(type));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.graphBuilder.connect(GraphBuilder.classNodeFromSingleType(owner));
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.graphBuilder.connect(GraphBuilder.classNodeFromSingleType(owner));
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        for (Object argument : bootstrapMethodArguments) {
            this.graphBuilder.connectValue(argument);
        }
    }

    public void visitLdcInsn(Object value) {
        this.graphBuilder.connectValue(value);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return this.annotationVisitor();
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.graphBuilder.connect(GraphBuilder.classNodeFromTypeName(type));
        }
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return this.annotationVisitor();
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor, signature);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        this.graphBuilder.connectNodesFromDescriptors(descriptor);
        return this.annotationVisitor();
    }
}

