/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.check;

import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.check.Layer;
import de.obqo.decycle.graph.MutableSlicing;
import de.obqo.decycle.graph.Slicing;
import de.obqo.decycle.graph.SlicingSource;
import de.obqo.decycle.model.Edge;
import de.obqo.decycle.model.Node;
import de.obqo.decycle.model.SliceType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SlicedConstraint
implements Constraint {
    private static final Logger log = LoggerFactory.getLogger(SlicedConstraint.class);
    private final SliceType sliceType;
    protected final List<Layer> layers;
    private final String arrow;

    protected abstract boolean isViolatedBy(Edge var1);

    protected final int indexOf(Node node) {
        for (int i = 0; i < this.layers.size(); ++i) {
            if (!this.layers.get(i).contains(node.getName())) continue;
            return i;
        }
        return -1;
    }

    protected final boolean containsBothNodes(int i, int j) {
        return i >= 0 && j >= 0;
    }

    protected final boolean nodesAreInWrongOrder(int i, int j) {
        return i > j;
    }

    protected final boolean nodesAreInTheSameOneOfLayer(int i, int j) {
        return i == j && this.layers.get(i).denyDependenciesWithinLayer();
    }

    @Override
    public List<Constraint.Violation> violations(SlicingSource slicingSource) {
        Slicing slicing = slicingSource.slicing(this.sliceType);
        this.validateConstraint(slicing);
        Set<Edge> violatingDeps = slicing.edges().stream().filter(Predicate.not(Edge::isIgnored)).filter(this::isViolatedBy).collect(Collectors.toSet());
        return violatingDeps.isEmpty() ? List.of() : List.of(new Constraint.Violation(this.getShortString(), MutableSlicing.create(this.sliceType, violatingDeps)));
    }

    private void validateConstraint(Slicing slicing) {
        Set sliceNames = slicing.nodes().stream().map(Node::getName).collect(Collectors.toSet());
        String unknownSlices = this.layers.stream().map(Layer::getSlices).flatMap(Collection::stream).filter(Predicate.not(sliceNames::contains)).sorted().collect(Collectors.joining(", "));
        if (!unknownSlices.isEmpty()) {
            String sliceText = unknownSlices.contains(",") ? "slices" : "slice";
            log.warn("Decycle: Unknown {} {} in constraint '{}' for slicing {}", new Object[]{sliceText, unknownSlices, this.getShortString(), this.sliceType.displayString()});
        }
    }

    @Override
    public String getShortString() {
        return this.layers.stream().map(Layer::getShortString).collect(Collectors.joining(this.arrow));
    }

    public String toString() {
        return this.getShortString();
    }

    public SlicedConstraint(SliceType sliceType, List<Layer> layers, String arrow) {
        this.sliceType = sliceType;
        this.layers = layers;
        this.arrow = arrow;
    }
}

