/*
 * Decompiled with CFR 0.152.
 */
package de.obqo.decycle.maven;

import de.obqo.decycle.check.Constraint;
import de.obqo.decycle.check.DirectLayeringConstraint;
import de.obqo.decycle.check.LayeringConstraint;
import de.obqo.decycle.configuration.Configuration;
import de.obqo.decycle.configuration.Pattern;
import de.obqo.decycle.maven.AllowConstraint;
import de.obqo.decycle.maven.Dependency;
import de.obqo.decycle.maven.Layer;
import de.obqo.decycle.maven.Slicing;
import de.obqo.decycle.report.ResourcesExtractor;
import de.obqo.decycle.slicer.IgnoredDependency;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

abstract class AbstractDecycleMojo
extends AbstractMojo {
    protected static final String MAIN = "main";
    protected static final String TEST = "test";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private String including;
    @Parameter
    private String excluding;
    @Parameter(property="decycle.ignoreFailures", defaultValue="false")
    private boolean ignoreFailures;
    @Parameter
    private Dependency[] ignoring;
    @Parameter
    private Slicing[] slicings;
    @Parameter(property="decycle.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="decycle.skipMain", defaultValue="false")
    private boolean skipMain;
    @Parameter(property="decycle.skipTest", defaultValue="false")
    private boolean skipTest;
    @Parameter(property="decycle.skipReports", defaultValue="false")
    private boolean skipReports;

    AbstractDecycleMojo() {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<Constraint.Violation> violations = this.executeCheck();
            if (!this.ignoreFailures && !violations.isEmpty()) {
                throw new MojoFailureException("Decycle check failed");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected abstract List<Constraint.Violation> executeCheck() throws IOException;

    protected List<Constraint.Violation> checkMain() throws IOException {
        if (this.skip || this.skipMain) {
            this.getLog().info((CharSequence)"Skipped decycle check for main classes");
            return List.of();
        }
        return this.check(this.getMainClasses(), MAIN);
    }

    protected List<Constraint.Violation> checkTest() throws IOException {
        if (this.skip || this.skipTest) {
            this.getLog().info((CharSequence)"Skipped decycle check for test classes");
            return List.of();
        }
        return this.check(this.getTestClasses(), TEST);
    }

    protected List<Constraint.Violation> check(String classpath, String sourceSet) throws IOException {
        Log log = this.getLog();
        if (!new File(classpath).exists()) {
            log.warn((CharSequence)("Decycle: " + classpath + " is missing - skipped decycle check for " + sourceSet + " classes"));
            return List.of();
        }
        if (this.skipReports) {
            Configuration config = this.buildConfiguration(classpath, sourceSet, null, null);
            return this.check(config, null);
        }
        File reportDir = this.getDecycleReportDir();
        String resourcesDirName = ResourcesExtractor.createResourcesIfRequired((File)reportDir);
        File report = new File(reportDir, sourceSet + ".html");
        try (FileWriter reportWriter = new FileWriter(report);){
            Configuration config = this.buildConfiguration(classpath, sourceSet, resourcesDirName, reportWriter);
            List<Constraint.Violation> list = this.check(config, report);
            return list;
        }
    }

    Configuration buildConfiguration(String classpath, String sourceSet, String resourcesDirName, FileWriter reportWriter) {
        return Configuration.builder().classpath(classpath).including(this.tokenizeToList(this.including)).excluding(this.tokenizeToList(this.excluding)).ignoring(this.getIgnoredDependencies()).slicings(this.getSlicings()).constraints(this.getConstraints()).report((Appendable)reportWriter).reportResourcesPrefix(resourcesDirName).reportTitle(this.project.getName() + " | " + sourceSet).build();
    }

    private List<Constraint.Violation> check(Configuration config, File report) {
        Log log = this.getLog();
        log.debug((CharSequence)("Decycle configuration: " + config));
        Consumer<String> logHandler = this.ignoreFailures ? arg_0 -> ((Log)log).warn(arg_0) : arg_0 -> ((Log)log).error(arg_0);
        List violations = config.check();
        if (!violations.isEmpty()) {
            logHandler.accept("Violations detected: " + Constraint.Violation.displayString((List)violations));
            if (report != null) {
                logHandler.accept("See the report at: " + report);
            }
        }
        return violations;
    }

    protected String getMainClasses() {
        return this.project.getBuild().getOutputDirectory();
    }

    protected String getTestClasses() {
        return this.project.getBuild().getTestOutputDirectory();
    }

    private File getDecycleReportDir() {
        return new File(this.project.getModel().getReporting().getOutputDirectory(), "decycle");
    }

    private Stream<String> tokenize(String value) {
        return Optional.ofNullable(value).map(v -> v.split(",")).stream().flatMap(Arrays::stream).map(String::trim).filter(Predicate.not(String::isEmpty));
    }

    private List<String> tokenizeToList(String value) {
        return this.tokenize(value).collect(Collectors.toList());
    }

    private String[] tokenizeToArray(String value) {
        return (String[])this.tokenize(value).toArray(String[]::new);
    }

    private List<IgnoredDependency> getIgnoredDependencies() {
        return this.stream(this.ignoring).map(dependency -> IgnoredDependency.create((String)dependency.getFrom(), (String)dependency.getTo())).collect(Collectors.toList());
    }

    private Map<String, List<Pattern>> getSlicings() {
        return this.stream(this.slicings).collect(Collectors.toMap(Slicing::getName, slicing -> this.tokenize(slicing.getPatterns()).map(Pattern::parse).collect(Collectors.toList())));
    }

    private Set<Constraint> getConstraints() {
        return this.stream(this.slicings).flatMap(this::mapConstraints).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<Constraint> mapConstraints(Slicing slicing) {
        return this.stream(slicing.getConstraints()).map(constraint -> this.mapConstraint(slicing, (AllowConstraint)constraint));
    }

    private Constraint mapConstraint(Slicing slicing, AllowConstraint constraint) {
        List layers = constraint.get() != null ? this.tokenize(constraint.get()).map(xva$0 -> de.obqo.decycle.check.Layer.anyOf((String[])new String[]{xva$0})).collect(Collectors.toList()) : constraint.getLayers().stream().map(this::mapLayers).collect(Collectors.toList());
        return constraint.isDirect() ? new DirectLayeringConstraint(slicing.getName(), layers) : new LayeringConstraint(slicing.getName(), layers);
    }

    private de.obqo.decycle.check.Layer mapLayers(Layer layer) {
        String[] slices = this.tokenizeToArray(layer.getSlices());
        return layer.isStrict() ? de.obqo.decycle.check.Layer.oneOf((String[])slices) : de.obqo.decycle.check.Layer.anyOf((String[])slices);
    }

    private <T> Stream<T> stream(T[] array) {
        return Optional.ofNullable(array).stream().flatMap(Arrays::stream);
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    void setIncluding(String including) {
        this.including = including;
    }

    void setExcluding(String excluding) {
        this.excluding = excluding;
    }

    void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    void setIgnoring(Dependency[] ignoring) {
        this.ignoring = ignoring;
    }

    void setSlicings(Slicing[] slicings) {
        this.slicings = slicings;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    void setSkipMain(boolean skipMain) {
        this.skipMain = skipMain;
    }

    void setSkipTest(boolean skipTest) {
        this.skipTest = skipTest;
    }

    void setSkipReports(boolean skipReports) {
        this.skipReports = skipReports;
    }
}

