/*
 * Decompiled with CFR 0.152.
 */
package de.ocarthon.libArcus;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import de.ocarthon.libArcus.Error;
import de.ocarthon.libArcus.MessageTypeStore;
import de.ocarthon.libArcus.SocketListener;
import de.ocarthon.libArcus.SocketState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ArcusSocket {
    private static final int ARCUS_SIGNATURE = 11181;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 0;
    private final Queue<Message> sendQueue = new LinkedList<Message>();
    private final Queue<Message> receiveQueue = new LinkedList<Message>();
    private MessageTypeStore messageTypeStore = new MessageTypeStore();
    private List<SocketListener> listeners = new ArrayList<SocketListener>();
    private Thread thread;
    private String address;
    private int port;
    private int socketTimeout = 1000;
    private volatile Socket socket;
    private volatile ServerSocket serverSocket;
    private volatile SocketState state = SocketState.Initial;
    private volatile SocketState nextState;

    public boolean registerMessageType(Message message) {
        if (message == null) {
            return false;
        }
        if (this.state != SocketState.Initial) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
            return false;
        }
        return this.messageTypeStore.registerType(message);
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        if (this.state != SocketState.Initial) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
        }
        this.socketTimeout = socketTimeout;
    }

    public void addListener(SocketListener listener) {
        if (this.state != SocketState.Initial) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(SocketListener listener) {
        if (this.state != SocketState.Initial) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
            return;
        }
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        if (this.state != SocketState.Initial) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
            return;
        }
        this.listeners.clear();
    }

    public void connect(String address, int port) {
        if (this.state != SocketState.Initial || this.thread != null) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
            return;
        }
        if (address == null) {
            this.error(Error.ErrorCode.InvalidArgumentError, "Address is null");
            return;
        }
        if (port < 0 || port > 65535) {
            this.error(Error.ErrorCode.InvalidArgumentError, "Port is out of range");
            return;
        }
        this.address = address;
        this.port = port;
        this.nextState = SocketState.Connecting;
        this.thread = new Thread(new InternalRunnable());
        this.thread.start();
    }

    public void listen(int port) {
        if (this.state != SocketState.Initial || this.thread != null) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in initial state");
            return;
        }
        if (port < 0 || port > 65535) {
            this.error(Error.ErrorCode.InvalidArgumentError, "Port is out of range");
            return;
        }
        this.port = port;
        this.nextState = SocketState.Opening;
        this.thread = new Thread(new InternalRunnable());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message) {
        if (message == null) {
            this.error(Error.ErrorCode.InvalidMessageError, "Message cannot be null");
            return;
        }
        Queue<Message> queue = this.sendQueue;
        synchronized (queue) {
            this.sendQueue.offer(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message takeNextMessage() {
        Queue<Message> queue = this.receiveQueue;
        synchronized (queue) {
            if (this.receiveQueue.size() > 0) {
                return this.receiveQueue.poll();
            }
            return null;
        }
    }

    public void reset() {
        if (this.state != SocketState.Closed && this.state != SocketState.Error) {
            this.error(Error.ErrorCode.InvalidStateError, "Socket is not in closed or error state");
            return;
        }
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException e) {
                this.error(Error.ErrorCode.ThreadInterruptError, "Thread has been interrupted");
            }
        }
        this.state = SocketState.Initial;
        this.state = SocketState.Initial;
    }

    public void close() {
        if (this.state == SocketState.Initial) {
            this.error(Error.ErrorCode.InvalidStateError, "Cannot close a socket in initial state");
        }
        if (this.state == SocketState.Closed || this.state == SocketState.Error) {
            return;
        }
        if (this.state == SocketState.Connected) {
            this.nextState = SocketState.Closing;
            while (this.state != SocketState.Closed) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.error(Error.ErrorCode.ThreadInterruptError, "Thread has been interrupted");
                }
            }
        } else {
            this.closeSocket();
            this.nextState = SocketState.Closed;
        }
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.fatalError(Error.ErrorCode.SocketCloseError, "Error while closing socket");
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                this.fatalError(Error.ErrorCode.SocketCloseError, "Error while closing socket");
            }
        }
    }

    public SocketState getState() {
        return this.state;
    }

    public int getPort() {
        return this.serverSocket != null ? this.serverSocket.getLocalPort() : this.port;
    }

    private void error(Error.ErrorCode errorCode, String errorMessage) {
        Error error = new Error(errorCode, errorMessage);
        for (SocketListener listener : this.listeners) {
            listener.error(this, error);
        }
    }

    private void fatalError(Error.ErrorCode errorCode, String errorMessage) {
        Error error = new Error(errorCode, errorMessage, true);
        if (this.state != SocketState.Error && this.nextState != SocketState.Error) {
            this.nextState = SocketState.Error;
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (SocketListener listener : this.listeners) {
            listener.error(this, error);
        }
    }

    static /* synthetic */ SocketState access$100(ArcusSocket x0) {
        return x0.state;
    }

    static /* synthetic */ Socket access$202(ArcusSocket x0, Socket x1) {
        x0.socket = x1;
        return x0.socket;
    }

    static /* synthetic */ String access$300(ArcusSocket x0) {
        return x0.address;
    }

    static /* synthetic */ int access$400(ArcusSocket x0) {
        return x0.port;
    }

    static /* synthetic */ Socket access$200(ArcusSocket x0) {
        return x0.socket;
    }

    static /* synthetic */ int access$600(ArcusSocket x0) {
        return x0.socketTimeout;
    }

    static /* synthetic */ ServerSocket access$802(ArcusSocket x0, ServerSocket x1) {
        x0.serverSocket = x1;
        return x0.serverSocket;
    }

    static /* synthetic */ ServerSocket access$800(ArcusSocket x0) {
        return x0.serverSocket;
    }

    static /* synthetic */ Queue access$900(ArcusSocket x0) {
        return x0.sendQueue;
    }

    static /* synthetic */ SocketState access$700(ArcusSocket x0) {
        return x0.nextState;
    }

    static /* synthetic */ SocketState access$102(ArcusSocket x0, SocketState x1) {
        x0.state = x1;
        return x0.state;
    }

    private class InternalRunnable
    implements Runnable {
        private static final int keepAliveRate = 250;
        private final byte[] SOCKET_CLOSE = new byte[]{-16, -16, -16, -16};
        private final byte[] ARCUS_HEADER = new byte[]{43, -83, 1, 0};
        private final byte[] KEEP_ALIVE = new byte[]{0, 0, 0, 0};
        private long lastKeepAlive = 0L;
        private OutputStream out;
        private InputStream in;
        private boolean receivedClose = false;
        private int messageState = 0;
        private int currentOffset = 0;
        private byte[] header = new byte[4];
        private byte[] length = new byte[4];
        private byte[] type = new byte[4];
        private byte[] message;

        private InternalRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block33: while (ArcusSocket.access$100(ArcusSocket.this) != SocketState.Closed && ArcusSocket.access$100(ArcusSocket.this) != SocketState.Error) {
                switch (1.$SwitchMap$de$ocarthon$libArcus$SocketState[ArcusSocket.access$100(ArcusSocket.this).ordinal()]) {
                    case 1: {
                        try {
                            ArcusSocket.access$202(ArcusSocket.this, new Socket(ArcusSocket.access$300(ArcusSocket.this), ArcusSocket.access$400(ArcusSocket.this)));
                            this.out = ArcusSocket.access$200(ArcusSocket.this).getOutputStream();
                            this.in = ArcusSocket.access$200(ArcusSocket.this).getInputStream();
                        }
                        catch (UnknownHostException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.ConnectFailedError, "Could not connect to the given address");
                            continue block33;
                        }
                        catch (IOException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.CreationError, "Could not create a socket");
                            continue block33;
                        }
                        try {
                            ArcusSocket.access$200(ArcusSocket.this).setSoTimeout(ArcusSocket.access$600(ArcusSocket.this));
                        }
                        catch (SocketException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.ConnectFailedError, "Failed to set socket receive timeout");
                            continue block33;
                        }
                        ArcusSocket.access$702(ArcusSocket.this, SocketState.Connected);
                        break;
                    }
                    case 2: {
                        try {
                            ArcusSocket.access$802(ArcusSocket.this, new ServerSocket(ArcusSocket.access$400(ArcusSocket.this)));
                        }
                        catch (BindException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.BindFailedError, "Could not bind to the given port");
                        }
                        catch (IOException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.CreationError, "Could not create a socket. Maybe the port is already in use");
                            continue block33;
                        }
                        try {
                            ArcusSocket.access$800(ArcusSocket.this).setSoTimeout(ArcusSocket.access$600(ArcusSocket.this));
                        }
                        catch (SocketException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.ConnectFailedError, "Failed to set socket receive timeout");
                            continue block33;
                        }
                        ArcusSocket.access$702(ArcusSocket.this, SocketState.Listening);
                        break;
                    }
                    case 3: {
                        try {
                            ArcusSocket.access$202(ArcusSocket.this, ArcusSocket.access$800(ArcusSocket.this).accept());
                            this.out = ArcusSocket.access$200(ArcusSocket.this).getOutputStream();
                            this.in = ArcusSocket.access$200(ArcusSocket.this).getInputStream();
                        }
                        catch (SocketTimeoutException e) {
                            continue block33;
                        }
                        catch (IOException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.AcceptFailedError, "Could not accept the incoming connection");
                            continue block33;
                        }
                        try {
                            ArcusSocket.access$200(ArcusSocket.this).setSoTimeout(ArcusSocket.access$600(ArcusSocket.this));
                        }
                        catch (SocketException e) {
                            ArcusSocket.access$500(ArcusSocket.this, Error.ErrorCode.AcceptFailedError, "Failed to set socket receive timeout");
                            continue block33;
                        }
                        ArcusSocket.access$702(ArcusSocket.this, SocketState.Connected);
                        break;
                    }
                    case 4: {
                        var2_11 = ArcusSocket.access$900(ArcusSocket.this);
                        synchronized (var2_11) {
                            messages = new Message[ArcusSocket.access$900(ArcusSocket.this).size()];
                            messages = ArcusSocket.access$900(ArcusSocket.this).toArray(messages);
                            ArcusSocket.access$900(ArcusSocket.this).clear();
                        }
                        for (Message message : messages) {
                            this.sendMessage(message);
                        }
                        this.receiveNextMessage();
                        if (ArcusSocket.access$700(ArcusSocket.this) == SocketState.Error) break;
                        this.checkConnectionState();
                        break;
                    }
                    case 5: {
                        if (this.receivedClose) ** GOTO lbl111
                        var2_11 = ArcusSocket.access$900(ArcusSocket.this);
                        synchronized (var2_11) {
                            messages = new Message[ArcusSocket.access$900(ArcusSocket.this).size()];
                            messages = ArcusSocket.access$900(ArcusSocket.this).toArray(messages);
                            ArcusSocket.access$900(ArcusSocket.this).clear();
                        }
                        for (Message message : messages) {
                            this.sendMessage(message);
                        }
                        try {
                            this.out.write(this.SOCKET_CLOSE);
                            this.out.flush();
                            ArcusSocket.access$200(ArcusSocket.this).shutdownOutput();
                            data = new byte[4];
                            i = 0;
                            while (!Arrays.equals(data, this.SOCKET_CLOSE) && ArcusSocket.access$700(ArcusSocket.this) == SocketState.Closing) {
                                if (i == data.length) {
                                    i = 0;
                                }
                                i += this.in.read(data, i, data.length - i);
                            }
                            ** GOTO lbl119
                        }
                        catch (IOException e) {
                            break;
                        }
lbl111:
                        // 1 sources

                        e = ArcusSocket.access$900(ArcusSocket.this);
                        synchronized (e) {
                            ArcusSocket.access$900(ArcusSocket.this).clear();
                        }
                        this.writeBytes(this.SOCKET_CLOSE);
lbl119:
                        // 2 sources

                        ArcusSocket.access$1000(ArcusSocket.this);
                        ArcusSocket.access$702(ArcusSocket.this, SocketState.Closed);
                        break;
                    }
                }
                if (ArcusSocket.access$700(ArcusSocket.this) == ArcusSocket.access$100(ArcusSocket.this)) continue;
                ArcusSocket.access$102(ArcusSocket.this, ArcusSocket.access$700(ArcusSocket.this));
                for (SocketListener listener : ArcusSocket.access$1100(ArcusSocket.this)) {
                    listener.stateChanged(ArcusSocket.this, ArcusSocket.access$100(ArcusSocket.this));
                }
            }
        }

        private void sendMessage(Message message) {
            try {
                this.out.write(this.ARCUS_HEADER);
            }
            catch (IOException e) {
                ArcusSocket.this.error(Error.ErrorCode.SendFailedError, "Could not send message header");
                return;
            }
            try {
                this.writeInt(message.getSerializedSize());
            }
            catch (IOException e) {
                ArcusSocket.this.error(Error.ErrorCode.SendFailedError, "Could not send message size");
                return;
            }
            try {
                this.writeInt(ArcusSocket.this.messageTypeStore.getMessageTypeId(message));
            }
            catch (IOException e) {
                ArcusSocket.this.error(Error.ErrorCode.SendFailedError, "Could not send message type");
                return;
            }
            try {
                this.out.write(message.toByteArray());
            }
            catch (IOException e) {
                ArcusSocket.this.error(Error.ErrorCode.SendFailedError, "Could not send message data");
            }
        }

        private void receiveNextMessage() {
            if (this.messageState == 0) {
                this.currentOffset = this.read(this.header, this.currentOffset);
                if (this.currentOffset != this.header.length) {
                    return;
                }
                if (Arrays.equals(this.header, this.KEEP_ALIVE)) {
                    this.currentOffset = 0;
                    return;
                }
                if (Arrays.equals(this.header, this.SOCKET_CLOSE)) {
                    ArcusSocket.this.nextState = SocketState.Closing;
                    this.receivedClose = true;
                    return;
                }
                if (!Arrays.equals(this.header, this.ARCUS_HEADER)) {
                    ArcusSocket.this.error(Error.ErrorCode.ReceiveFailedError, "Header mismatch");
                    this.currentOffset = 0;
                    return;
                }
                this.currentOffset = 0;
                this.messageState = 1;
            }
            if (this.messageState == 1) {
                this.currentOffset = this.read(this.length, this.currentOffset);
                if (this.currentOffset != this.length.length) {
                    return;
                }
                int size = this.bytesToInt(this.length);
                if (size < 0) {
                    ArcusSocket.this.error(Error.ErrorCode.ReceiveFailedError, "Size invalid");
                    this.currentOffset = 0;
                    this.messageState = 0;
                    return;
                }
                this.message = new byte[size];
                this.currentOffset = 0;
                this.messageState = 2;
            }
            if (this.messageState == 2) {
                this.currentOffset = this.read(this.type, this.currentOffset);
                if (this.currentOffset != this.type.length) {
                    return;
                }
                this.currentOffset = 0;
                this.messageState = 3;
            }
            if (this.messageState == 3) {
                this.currentOffset = this.read(this.message, this.currentOffset);
                if (this.currentOffset != this.message.length) {
                    return;
                }
                this.currentOffset = 0;
                this.messageState = 0;
                this.handleMessage(this.type, this.message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(byte[] type, byte[] data) {
            int typeHash = this.bytesToInt(type);
            if (!ArcusSocket.this.messageTypeStore.hasType(typeHash)) {
                ArcusSocket.this.error(Error.ErrorCode.UnknownMessageTypeError, "Unknown message type");
            }
            try {
                Message obj = ArcusSocket.this.messageTypeStore.parse(typeHash, data);
                Queue queue = ArcusSocket.this.receiveQueue;
                synchronized (queue) {
                    ArcusSocket.this.receiveQueue.offer(obj);
                }
                for (SocketListener listener : ArcusSocket.this.listeners) {
                    listener.messageReceived(ArcusSocket.this);
                }
            }
            catch (InvalidProtocolBufferException e) {
                ArcusSocket.this.error(Error.ErrorCode.ParseFailedError, "Type mismatch");
            }
            catch (Exception e) {
                ArcusSocket.this.error(Error.ErrorCode.ParseFailedError, "Failed to parse message");
            }
        }

        private void checkConnectionState() {
            long now = System.currentTimeMillis();
            long diff = now - this.lastKeepAlive;
            if (diff > 250L) {
                try {
                    this.out.write(this.KEEP_ALIVE);
                    this.out.flush();
                }
                catch (IOException e) {
                    ArcusSocket.this.error(Error.ErrorCode.ConnectionResetError, "Connection reset by peer");
                    ArcusSocket.this.closeSocket();
                    ArcusSocket.this.nextState = SocketState.Closed;
                }
                this.lastKeepAlive = now;
            }
        }

        private int bytesToInt(byte[] in) {
            return (in[0] & 0xFF) << 24 | (in[1] & 0xFF) << 16 | (in[2] & 0xFF) << 8 | in[3] & 0xFF;
        }

        private void writeInt(int in) throws IOException {
            this.out.write(new byte[]{(byte)(in >> 24 & 0xFF), (byte)(in >> 16 & 0xFF), (byte)(in >> 8 & 0xFF), (byte)(in & 0xFF)});
        }

        private void writeBytes(byte[] data) {
            try {
                this.out.write(data);
            }
            catch (IOException e) {
                ArcusSocket.this.error(Error.ErrorCode.ConnectionResetError, "Connection reset by peer");
                ArcusSocket.this.closeSocket();
                ArcusSocket.this.nextState = SocketState.Closed;
            }
        }

        private int read(byte[] data, int off) {
            try {
                return off + this.in.read(data, off, data.length - off);
            }
            catch (IOException e) {
                ArcusSocket.this.fatalError(Error.ErrorCode.UnknownError, "Error while reading from socket (" + e.getMessage() + ")");
                return -1;
            }
        }
    }
}

