/*
 * Copyright 2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.odrotbohm.spring.web.model;

import java.util.function.Function;
import java.util.function.Predicate;

/**
 * @author Oliver Drotbohm
 */
public interface TypeSafeRejector<T extends TypeSafeRejector<T, S>, S> {

	/**
	 * Rejects the field referred to by the given {@link Function} (ideally a method reference).
	 *
	 * @param property must not be {@literal null}.
	 * @param errorCode must not be {@literal null} or empty.
	 * @return will never be {@literal null}.
	 */
	S rejectField(Function<? super T, ?> property, String errorCode);

	/**
	 * Rejects the field referred to by the given {@link Function} (ideally a method reference).
	 *
	 * @param condition the condition under which to reject the given field.
	 * @param property must not be {@literal null}.
	 * @param errorCode must not be {@literal null} or empty.
	 * @return will never be {@literal null}.
	 */
	S rejectField(boolean condition, Function<? super T, ?> property, String errorCode);

	S rejectField(Predicate<T> condition, Function<? super T, ?> property, String errorCode);
}
