/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.web.autoconfigure;

import am.ik.yavi.core.Validator;
import de.odrotbohm.spring.web.validation.YaviValidator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Validator.class})
@ConditionalOnBean(value={Validator.class})
class YaviValidatorAutoConfiguration {
    YaviValidatorAutoConfiguration() {
    }

    @Bean
    static BeanFactoryPostProcessor yaviValidatorRegisteringPostProcessor() {
        return new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                if (!DefaultListableBeanFactory.class.isInstance(beanFactory)) {
                    return;
                }
                DefaultListableBeanFactory factory = (DefaultListableBeanFactory)beanFactory;
                for (String name : factory.getBeanNamesForType(Validator.class, false, false)) {
                    ResolvableType sourceType = beanFactory.getBeanDefinition(name).getResolvableType();
                    RootBeanDefinition definition = new RootBeanDefinition(YaviValidator.class, () -> new YaviValidator((Validator)factory.getBean(name, Validator.class)));
                    definition.setTargetType(ResolvableType.forClassWithGenerics(YaviValidator.class, (ResolvableType[])new ResolvableType[]{sourceType.getGeneric(new int[]{0})}));
                    definition.setSource((Object)this);
                    factory.registerBeanDefinition("__".concat(name), (BeanDefinition)definition);
                }
            }
        };
    }
}

