/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.web.model;

import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class I18nedMessage
implements MessageSourceResolvable {
    @Nullable
    private final String[] codes;
    @Nullable
    private final Object[] arguments;
    @Nullable
    private final String defaultMessage;

    public static I18nedMessage of(String code, String ... additionalCodes) {
        Assert.hasText((String)code, (String)"Code must not be null or empty!");
        String[] codes = (String[])Stream.concat(Stream.of(code), Arrays.stream(additionalCodes)).toArray(String[]::new);
        return new I18nedMessage(codes, new Object[0], null);
    }

    public I18nedMessage withArguments(Object ... arguments) {
        return new I18nedMessage(this.codes, arguments, this.defaultMessage);
    }

    @Generated
    private I18nedMessage(@Nullable String[] codes, @Nullable Object[] arguments, @Nullable String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    @Generated
    public I18nedMessage withCodes(@Nullable String[] codes) {
        return this.codes == codes ? this : new I18nedMessage(codes, this.arguments, this.defaultMessage);
    }

    @Nullable
    @Generated
    public String[] getCodes() {
        return this.codes;
    }

    @Nullable
    @Generated
    public Object[] getArguments() {
        return this.arguments;
    }

    @Generated
    public I18nedMessage withDefaultMessage(@Nullable String defaultMessage) {
        return this.defaultMessage == defaultMessage ? this : new I18nedMessage(this.codes, this.arguments, defaultMessage);
    }

    @Nullable
    @Generated
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}

