/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.web.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

public interface MappedPayloads {
    public static MappedErrors of(Errors errors) {
        return new MappedErrors(errors, MappedPayloads::toBadRequest);
    }

    public static <T> MappedPayload<T> of(@Nullable T payload, Errors errors) {
        Assert.notNull(payload, (String)"Payload must not be null!");
        return MappedPayload.of(payload, errors);
    }

    public static <T> MappedPayload<T> of(Optional<T> source, Errors errors) {
        Assert.notNull(source, (String)"Source must not be null!");
        return MappedPayload.of(source.orElse(null), errors);
    }

    public static ResponseEntity<?> toBadRequest(Errors errors) {
        return MappedPayloads.of(errors).toBadRequest();
    }

    public static class MappedErrors {
        @NonNull
        private final Errors errors;
        protected final Function<Errors, ResponseEntity<?>> onErrors;

        public <T> MappedPayload<T> with(T payload) {
            return MappedPayload.of(payload, this.errors);
        }

        public MappedErrors peekErrors(Consumer<Errors> errors) {
            Assert.notNull(errors, (String)"Errors handler must not be null!");
            errors.accept(this.errors);
            return this;
        }

        public MappedErrors rejectField(String field, String errorCode) {
            Assert.hasText((String)field, (String)"Field name must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            this.errors.rejectValue(field, errorCode);
            return this;
        }

        public MappedErrors rejectField(boolean condition, String field, String errorCode) {
            Assert.hasText((String)field, (String)"Field name must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            return condition ? this.rejectField(field, errorCode) : this;
        }

        public MappedErrors rejectField(String field, String errorCode, String defaultMessage) {
            Assert.hasText((String)field, (String)"Field name must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            Assert.hasText((String)defaultMessage, (String)"Default message must not be null or empty!");
            this.errors.rejectValue(field, errorCode, defaultMessage);
            return this;
        }

        public MappedErrors rejectField(boolean condition, String field, String errorCode, Function<Errors, ResponseEntity<?>> errorHandler) {
            Assert.hasText((String)field, (String)"Field name must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            Assert.notNull(errorHandler, (String)"Error handler must not be null!");
            if (condition) {
                this.rejectField(field, errorCode);
                return this.onErrors(errorHandler);
            }
            return this;
        }

        public ResponseEntity<?> toBadRequest() {
            return ResponseEntity.badRequest().body((Object)this.errors);
        }

        public ResponseEntity<?> onValidGet(Supplier<ResponseEntity<?>> response) {
            Assert.notNull(response, (String)"Response supplier must not be null!");
            return this.errorsOrNone().orElseGet(response);
        }

        public MappedErrors onErrors(Function<Errors, ResponseEntity<?>> callback) {
            Assert.notNull(callback, (String)"Callback must not be null!");
            return new MappedErrors(this.errors, callback);
        }

        public MappedErrors onErrors(Supplier<ResponseEntity<?>> callback) {
            Assert.notNull(callback, (String)"Callback must not be null!");
            return this.onErrors((Errors __) -> (ResponseEntity)callback.get());
        }

        protected Optional<ResponseEntity<?>> errorsOrNone() {
            return this.errors.hasErrors() ? Optional.of(this.onErrors.apply(this.errors)) : Optional.empty();
        }

        @Generated
        protected MappedErrors(@NonNull Errors errors, Function<Errors, ResponseEntity<?>> onErrors) {
            if (errors == null) {
                throw new IllegalArgumentException("errors is marked non-null but is null");
            }
            this.errors = errors;
            this.onErrors = onErrors;
        }
    }

    public static class MappedPayload<T>
    extends MappedErrors {
        private final Errors errors;
        @Nullable
        private final T payload;
        private final Supplier<ResponseEntity<?>> onAbsence;

        private static <T> MappedPayload<T> of(@Nullable T payload, Errors errors) {
            Assert.notNull((Object)errors, (String)"Errors must not be null!");
            return MappedPayload.of(payload, errors, it -> ResponseEntity.badRequest().body(it), () -> ResponseEntity.notFound().build());
        }

        private static <T> MappedPayload<T> of(@Nullable T payload, Errors errors, Function<Errors, ResponseEntity<?>> onErrors, Supplier<ResponseEntity<?>> onAbsence) {
            Assert.notNull(onAbsence, (String)"Abscence callback must not be null!");
            Assert.notNull(onErrors, (String)"Errors callback must not be null!");
            return new MappedPayload<T>(payload, errors, onErrors, onAbsence);
        }

        private MappedPayload(@Nullable T payload, Errors errors, Function<Errors, ResponseEntity<?>> onErrors, Supplier<ResponseEntity<?>> onAbsence) {
            super(errors, onErrors);
            Assert.notNull(onAbsence, (String)"Absence callback must not be null!");
            this.errors = errors;
            this.payload = payload;
            this.onAbsence = onAbsence;
        }

        public MappedPayload<T> notFoundIf(boolean guard) {
            return guard ? this.withoutPayload() : this;
        }

        public MappedPayload<T> notFoundIf(Predicate<? super T> predicate) {
            Assert.notNull(predicate, (String)"Predicate must not be null!");
            return this.payload == null || predicate.test(this.payload) ? this.withoutPayload() : this;
        }

        public MappedPayload<T> peekIfValid(Consumer<? super T> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null!");
            if (!this.errors.hasErrors() && this.payload != null) {
                consumer.accept(this.payload);
            }
            return this;
        }

        public MappedPayload<T> peekIfValid(BiConsumer<? super T, Errors> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null!");
            if (!this.errors.hasErrors() && this.payload != null) {
                consumer.accept(this.payload, this.errors);
            }
            return this;
        }

        public MappedPayload<T> peek(Consumer<? super T> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null!");
            if (this.payload != null) {
                consumer.accept(this.payload);
            }
            return this;
        }

        public MappedPayload<T> peek(BiConsumer<? super T, Errors> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null!");
            if (this.payload != null) {
                consumer.accept(this.payload, this.errors);
            }
            return this;
        }

        public MappedPayload<T> validate(BiConsumer<? super T, Errors> validator) {
            Assert.notNull(validator, (String)"Validator must not be null!");
            if (this.payload != null) {
                validator.accept(this.payload, this.errors);
            }
            return this;
        }

        public <S> MappedPayload<S> map(Function<? super T, S> mapper) {
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            return this.payload == null ? this : this.withPayload(mapper.apply(this.payload));
        }

        public <S> MappedPayload<S> flatMap(Function<? super T, Optional<S>> mapper) {
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            return this.payload == null ? this : mapper.apply(this.payload).map(this::withPayload).orElseGet(this::withoutPayload);
        }

        public <S> MappedPayload<S> mapIfValid(Function<? super T, S> mapper) {
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            return this.errors.hasErrors() || this.payload == null ? this : this.withPayload(mapper.apply(this.payload));
        }

        public <S> MappedPayload<S> flatMapIfValid(Function<? super T, Optional<S>> mapper) {
            Assert.notNull(mapper, (String)"Mapper must not be null!");
            return this.errors.hasErrors() || this.payload == null ? this : mapper.apply(this.payload).map(this::withPayload).orElseGet(this::withoutPayload);
        }

        public <S> MappedPayload<S> map(BiFunction<? super T, Errors, S> mapper) {
            return this.withPayload(mapper.apply(this.payload, this.errors));
        }

        public <S> MappedPayload<S> mapIfValid(BiFunction<? super T, Errors, S> mapper) {
            return this.errors.hasErrors() || this.payload == null ? this : this.withPayload(mapper.apply(this.payload, this.errors));
        }

        @Override
        public MappedPayload<T> onErrors(Function<Errors, ResponseEntity<?>> callback) {
            Assert.notNull(callback, (String)"Callback must not be null!");
            return MappedPayload.of(this.payload, this.errors, callback, this.onAbsence);
        }

        @Override
        public MappedPayload<T> onErrors(Supplier<ResponseEntity<?>> callback) {
            Assert.notNull(callback, (String)"Callback must not be null!");
            return this.onErrors((T __) -> (ResponseEntity)callback.get());
        }

        public MappedPayload<T> onAbsence(Supplier<ResponseEntity<?>> callback) {
            Assert.notNull(callback, (String)"Callback must not be null!");
            return MappedPayload.of(this.payload, this.errors, this.onErrors, callback);
        }

        public MappedPayload<T> onAbsenceReject(String field, String errorCode) {
            Assert.hasText((String)field, (String)"Field to reject must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            this.errors.rejectValue(field, errorCode);
            return MappedPayload.of(this.payload, this.errors, this.onErrors, () -> (ResponseEntity)this.onErrors.apply(this.errors));
        }

        public <S, R extends ResponseEntity<? extends S>> R concludeIfValid(Function<? super T, R> finalizer) {
            Assert.notNull(finalizer, (String)"Finalizer must not be null!");
            return (R)this.errorsOrNone().orElseGet(() -> (ResponseEntity)finalizer.apply((T)this.payload));
        }

        public HttpEntity<?> concludeIfValid(BiFunction<? super T, Errors, ? extends ResponseEntity<?>> finalizer) {
            Assert.notNull(finalizer, (String)"Finalizer must not be null!");
            return (HttpEntity)this.errorsOrNone().orElseGet(() -> (ResponseEntity)finalizer.apply((T)this.payload, this.errors));
        }

        public HttpEntity<?> concludeSelfIfValid(BiFunction<? super T, MappedErrors, ? extends ResponseEntity<?>> finalizer) {
            Assert.notNull(finalizer, (String)"Finalizer must not be null!");
            return (HttpEntity)this.errorsOrNone().orElseGet(() -> (ResponseEntity)finalizer.apply((T)this.payload, this));
        }

        public HttpEntity<?> concludeWithoutContent() {
            return this.concludeIfValid((? super T __) -> ResponseEntity.noContent().build());
        }

        @Override
        public MappedPayload<T> rejectField(boolean condition, String field, String errorCode) {
            super.rejectField(condition, field, errorCode);
            return this;
        }

        public MappedPayload<T> rejectField(Predicate<T> condition, String field, String errorCode) {
            Assert.notNull(condition, (String)"Condition predicate must not be null!");
            Assert.hasText((String)field, (String)"Field name must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            return this.errors.hasErrors() || this.payload == null || !condition.test(this.payload) ? this : this.rejectField(field, errorCode);
        }

        @Override
        public MappedPayload<T> rejectField(String field, String errorCode) {
            super.rejectField(field, errorCode);
            return this;
        }

        @Override
        public MappedPayload<T> rejectField(String field, String errorCode, String defaultMessage) {
            super.rejectField(field, errorCode, defaultMessage);
            return this;
        }

        @Override
        public MappedPayload<T> rejectField(boolean condition, String field, String errorCode, Function<Errors, ResponseEntity<?>> errorHandler) {
            Assert.hasText((String)field, (String)"Field name must not be null or empty!");
            Assert.hasText((String)errorCode, (String)"Error code must not be null or empty!");
            Assert.notNull(errorHandler, (String)"Error handler must not be null!");
            if (condition) {
                this.rejectField(field, errorCode);
                return this.onErrors((Function)errorHandler);
            }
            return this;
        }

        private <S> MappedPayload<S> withoutPayload() {
            return MappedPayload.of(null, this.errors, this.onErrors, this.onAbsence);
        }

        private <S> MappedPayload<S> withPayload(S payload) {
            return MappedPayload.of(payload, this.errors, this.onErrors, this.onAbsence);
        }

        @Override
        protected Optional<ResponseEntity<?>> errorsOrNone() {
            Optional byPayload = this.payload == null ? Optional.of(this.onAbsence.get()) : Optional.empty();
            return byPayload.isPresent() ? byPayload : super.errorsOrNone();
        }
    }
}

