/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.web.mvc;

import de.odrotbohm.spring.web.model.MappedPayloads;
import de.odrotbohm.spring.web.mvc.MappedPayloadProperties;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ErrorsMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class MappedPayloadHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Supplier<RequestMappingHandlerAdapter> adapter;
    private final MappedPayloadProperties configuration;
    private RequestResponseBodyMethodProcessor requestBodyResolver;
    private ErrorsMethodArgumentResolver errorsResolver;

    public boolean supportsParameter(MethodParameter parameter) {
        return MappedPayloads.MappedPayload.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        AlwaysValidatingMethodParameter nested = this.configuration.isAlwaysValidate() ? new AlwaysValidatingMethodParameter(parameter.nested()) : parameter.nested();
        Object argument = this.getRequestBodyProcessor().resolveArgument((MethodParameter)nested, mavContainer, webRequest, binderFactory);
        Errors errors = (Errors)this.getErrorsResolver().resolveArgument((MethodParameter)nested, mavContainer, webRequest, binderFactory);
        return MappedPayloads.of(argument, errors);
    }

    private RequestResponseBodyMethodProcessor getRequestBodyProcessor() {
        if (this.requestBodyResolver == null) {
            this.requestBodyResolver = this.getArgumentResolver(RequestResponseBodyMethodProcessor.class);
        }
        return this.requestBodyResolver;
    }

    private ErrorsMethodArgumentResolver getErrorsResolver() {
        if (this.errorsResolver == null) {
            this.errorsResolver = this.getArgumentResolver(ErrorsMethodArgumentResolver.class);
        }
        return this.errorsResolver;
    }

    private <T> T getArgumentResolver(Class<T> type) {
        return (T)this.adapter.get().getArgumentResolvers().stream().filter(type::isInstance).findFirst().map(type::cast).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find resolver of type ", type.getName())));
    }

    @Generated
    public MappedPayloadHandlerMethodArgumentResolver(Supplier<RequestMappingHandlerAdapter> adapter, MappedPayloadProperties configuration) {
        this.adapter = adapter;
        this.configuration = configuration;
    }

    private static class AlwaysValidatingMethodParameter
    extends MethodParameter {
        private static final Annotation VALIDATED_ANNOTATION = AnnotationUtils.synthesizeAnnotation(Validated.class);

        public AlwaysValidatingMethodParameter(MethodParameter delegate) {
            super(delegate);
        }

        public Annotation[] getParameterAnnotations() {
            Object[] annotations = super.getParameterAnnotations();
            return Arrays.stream(annotations).map(Annotation::annotationType).anyMatch(it -> it.getSimpleName().startsWith("Valid")) ? annotations : (Annotation[])ObjectUtils.addObjectToArray((Object[])annotations, (Object)VALIDATED_ANNOTATION);
        }
    }
}

