/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.web.mvc;

import java.io.IOException;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

public class MessageSourceResolvableHttpMessageConverter
extends AbstractHttpMessageConverter<MessageSourceResolvable> {
    private final MessageSourceAccessor messages;

    MessageSourceResolvableHttpMessageConverter(MessageSourceAccessor messages) {
        super(MediaType.TEXT_PLAIN);
        Assert.notNull((Object)messages, (String)"Messages must not be null!");
        this.messages = messages;
    }

    protected boolean supports(Class<?> clazz) {
        return MessageSourceResolvable.class.isAssignableFrom(clazz);
    }

    protected void writeInternal(MessageSourceResolvable t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getBody().write(this.messages.getMessage(t).getBytes());
    }

    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    protected MessageSourceResolvable readInternal(Class<? extends MessageSourceResolvable> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }
}

