/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.gson;

import com.google.gson.stream.JsonReader;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.IOException;

class GsonStreamSource
implements JsonStreamSource {
    private final JsonReader reader;
    private JsonStreamToken peek;

    GsonStreamSource(JsonReader reader) {
        this.reader = reader;
    }

    private void consume(JsonStreamToken token) throws IOException {
        if (this.peek() != token) {
            throw new IllegalStateException("Expected token: " + token + ", but was: " + this.peek());
        }
        this.peek = null;
    }

    private JsonStreamToken read() throws IOException {
        switch (this.reader.peek()) {
            case NAME: {
                return JsonStreamToken.NAME;
            }
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case STRING: {
                return JsonStreamToken.VALUE;
            }
            case BEGIN_OBJECT: {
                return JsonStreamToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonStreamToken.END_OBJECT;
            }
            case BEGIN_ARRAY: {
                return JsonStreamToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonStreamToken.END_ARRAY;
            }
            case END_DOCUMENT: {
                return JsonStreamToken.NONE;
            }
        }
        throw new IllegalStateException("Unexpected GSON token: " + this.reader.peek());
    }

    public void endArray() throws IOException {
        this.consume(JsonStreamToken.END_ARRAY);
        this.reader.endArray();
    }

    public void endObject() throws IOException {
        this.consume(JsonStreamToken.END_OBJECT);
        this.reader.endObject();
    }

    public String name() throws IOException {
        this.consume(JsonStreamToken.NAME);
        return this.reader.nextName();
    }

    public JsonStreamToken peek() throws IOException {
        return this.peek == null ? (this.peek = this.read()) : this.peek;
    }

    public void startArray() throws IOException {
        this.consume(JsonStreamToken.START_ARRAY);
        this.reader.beginArray();
    }

    public void startObject() throws IOException {
        this.consume(JsonStreamToken.START_OBJECT);
        this.reader.beginObject();
    }

    public JsonStreamSource.Value value() throws IOException {
        this.consume(JsonStreamToken.VALUE);
        switch (this.reader.peek()) {
            case BOOLEAN: {
                return this.reader.nextBoolean() ? TRUE : FALSE;
            }
            case NULL: {
                this.reader.nextNull();
                return NULL;
            }
            case NUMBER: {
                String s = this.reader.nextString();
                try {
                    return new JsonStreamSource.Value(s, (Number)Long.valueOf(s));
                }
                catch (NumberFormatException e) {
                    return new JsonStreamSource.Value(s, (Number)Double.valueOf(s));
                }
            }
            case STRING: {
                return new JsonStreamSource.Value(this.reader.nextString());
            }
        }
        throw new IOException("Not a value token: " + this.peek());
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getCharacterOffset() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }
}

