/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.gson;

import com.google.gson.stream.JsonWriter;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import java.io.IOException;

class GsonStreamTarget
implements JsonStreamTarget {
    private final JsonWriter writer;

    GsonStreamTarget(JsonWriter writer) {
        this.writer = writer;
    }

    public void endArray() throws IOException {
        this.writer.endArray();
    }

    public void endObject() throws IOException {
        this.writer.endObject();
    }

    public void name(String name) throws IOException {
        this.writer.name(name);
    }

    public void startArray() throws IOException {
        this.writer.beginArray();
    }

    public void startObject() throws IOException {
        this.writer.beginObject();
    }

    public void value(Object value) throws IOException {
        if (value == null) {
            this.writer.nullValue();
        } else if (value instanceof String) {
            this.writer.value((String)value);
        } else if (value instanceof Number) {
            this.writer.value((Number)value);
        } else if (value instanceof Boolean) {
            this.writer.value(((Boolean)value).booleanValue());
        } else {
            throw new IOException("Cannot write value: " + value);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

