/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import de.odysseus.staxon.json.stream.JsonStreamFactory;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import de.odysseus.staxon.json.stream.jackson.JacksonStreamSource;
import de.odysseus.staxon.json.stream.jackson.JacksonStreamTarget;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class JacksonStreamFactory
extends JsonStreamFactory {
    private final JsonFactory jsonFactory;

    public JacksonStreamFactory() {
        this(new JsonFactory());
    }

    public JacksonStreamFactory(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    protected JsonParser configure(JsonParser parser) {
        return parser.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
    }

    protected JsonGenerator configure(JsonGenerator generator, boolean pretty) {
        generator.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        if (pretty) {
            generator.useDefaultPrettyPrinter();
        }
        return generator;
    }

    public JsonStreamSource createJsonStreamSource(InputStream input) throws IOException {
        return new JacksonStreamSource(this.configure(this.jsonFactory.createParser(input)));
    }

    public JsonStreamSource createJsonStreamSource(Reader reader) throws IOException {
        return new JacksonStreamSource(this.configure(this.jsonFactory.createParser(reader)));
    }

    public JsonStreamTarget createJsonStreamTarget(OutputStream output, boolean pretty) throws IOException {
        return new JacksonStreamTarget(this.configure(this.jsonFactory.createGenerator(output, JsonEncoding.UTF8), pretty));
    }

    public JsonStreamTarget createJsonStreamTarget(Writer writer, boolean pretty) throws IOException {
        return new JacksonStreamTarget(this.configure(this.jsonFactory.createGenerator(writer), pretty));
    }
}

