/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import de.odysseus.staxon.json.stream.JsonStreamSource;
import de.odysseus.staxon.json.stream.JsonStreamToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;

class JacksonStreamSource
implements JsonStreamSource {
    private final JsonParser parser;
    private JsonStreamToken peek = null;
    private JsonLocation location = JsonLocation.NA;

    JacksonStreamSource(JsonParser parser) {
        this.parser = parser;
    }

    private JsonStreamToken read() throws IOException {
        JsonToken token = this.parser.nextToken();
        this.location = this.parser.getCurrentLocation();
        if (token == null) {
            return JsonStreamToken.NONE;
        }
        switch (token) {
            case FIELD_NAME: {
                return JsonStreamToken.NAME;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: 
            case VALUE_NULL: 
            case VALUE_STRING: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return JsonStreamToken.VALUE;
            }
            case START_OBJECT: {
                return JsonStreamToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonStreamToken.END_OBJECT;
            }
            case START_ARRAY: {
                return JsonStreamToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonStreamToken.END_ARRAY;
            }
            case NOT_AVAILABLE: {
                return JsonStreamToken.NONE;
            }
        }
        throw new IllegalStateException("Unexpected GSON token: " + this.parser.getCurrentToken());
    }

    private JacksonStreamSource expect(JsonStreamToken token) throws IOException {
        if (this.peek() != token) {
            throw new IllegalStateException("Expected token: " + token + ", but was: " + this.peek());
        }
        return this;
    }

    private void consume() {
        this.peek = null;
    }

    private String consume(String result) {
        this.peek = null;
        return result;
    }

    public void endArray() throws IOException {
        this.expect(JsonStreamToken.END_ARRAY).consume();
    }

    public void endObject() throws IOException {
        this.expect(JsonStreamToken.END_OBJECT).consume();
    }

    public String name() throws IOException {
        return this.expect(JsonStreamToken.NAME).consume(this.parser.getCurrentName());
    }

    public JsonStreamToken peek() throws IOException {
        return this.peek == null ? (this.peek = this.read()) : this.peek;
    }

    public void startArray() throws IOException {
        this.expect(JsonStreamToken.START_ARRAY).consume();
    }

    public void startObject() throws IOException {
        this.expect(JsonStreamToken.START_OBJECT).consume();
    }

    public JsonStreamSource.Value value() throws IOException {
        this.expect(JsonStreamToken.VALUE).consume();
        switch (this.parser.getCurrentToken()) {
            case VALUE_STRING: {
                return new JsonStreamSource.Value(this.parser.getText());
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return this.parser.getBooleanValue() ? TRUE : FALSE;
            }
            case VALUE_NUMBER_FLOAT: {
                return new JsonStreamSource.Value(this.parser.getText(), (Number)this.parser.getDecimalValue());
            }
            case VALUE_NUMBER_INT: {
                return new JsonStreamSource.Value(this.parser.getText(), (Number)this.parser.getLongValue());
            }
            case VALUE_NULL: {
                return NULL;
            }
        }
        throw new IOException("Not a value token: " + this.parser.getCurrentToken());
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public int getLineNumber() {
        return this.location.getLineNr();
    }

    public int getColumnNumber() {
        return this.location.getColumnNr();
    }

    public int getCharacterOffset() {
        return (int)this.location.getCharOffset();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        if (this.location.getSourceRef() instanceof File) {
            return ((File)this.location.getSourceRef()).toURI().toASCIIString();
        }
        if (this.location.getSourceRef() instanceof URL) {
            return ((URL)this.location.getSourceRef()).toExternalForm();
        }
        return null;
    }
}

