/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.stream.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import de.odysseus.staxon.json.stream.JsonStreamTarget;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

class JacksonStreamTarget
implements JsonStreamTarget {
    private final JsonGenerator generator;

    JacksonStreamTarget(JsonGenerator generator) {
        this.generator = generator;
    }

    public void endArray() throws IOException {
        this.generator.writeEndArray();
    }

    public void endObject() throws IOException {
        this.generator.writeEndObject();
    }

    public void name(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    public void startArray() throws IOException {
        this.generator.writeStartArray();
    }

    public void startObject() throws IOException {
        this.generator.writeStartObject();
    }

    public void value(Object value) throws IOException {
        if (value == null) {
            this.generator.writeNull();
        } else if (value instanceof String) {
            this.generator.writeString((String)value);
        } else if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                this.generator.writeNumber((BigDecimal)value);
            } else if (value instanceof BigInteger) {
                this.generator.writeNumber((BigInteger)value);
            } else if (value instanceof Long) {
                this.generator.writeNumber(((Long)value).longValue());
            } else if (value instanceof Integer) {
                this.generator.writeNumber(((Integer)value).intValue());
            } else if (value instanceof Double) {
                this.generator.writeNumber(((Double)value).doubleValue());
            } else if (value instanceof Float) {
                this.generator.writeNumber(((Float)value).floatValue());
            } else {
                this.generator.writeNumber(value.toString());
            }
        } else if (value instanceof Boolean) {
            this.generator.writeBoolean(((Boolean)value).booleanValue());
        } else {
            throw new IOException("Cannot write value: " + value);
        }
    }

    public void flush() throws IOException {
        this.generator.flush();
    }

    public void close() throws IOException {
        this.generator.close();
    }
}

