/*
 * Decompiled with CFR 0.152.
 */
package eva2;

import eva2.OptimizerRunnable;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.enums.DEType;
import eva2.optimization.enums.MutateESCrossoverType;
import eva2.optimization.enums.PSOTopology;
import eva2.optimization.enums.PostProcessMethod;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.archiving.InformationRetrievalInserting;
import eva2.optimization.operator.archiving.InterfaceArchiving;
import eva2.optimization.operator.archiving.InterfaceInformationRetrieval;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.operator.crossover.NoCrossover;
import eva2.optimization.operator.distancemetric.IndividualDataMetric;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESCovarianceMatrixAdaption;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.mutation.MutateESGlobal;
import eva2.optimization.operator.mutation.MutateESRankMuCMA;
import eva2.optimization.operator.mutation.NoMutation;
import eva2.optimization.operator.postprocess.InterfacePostProcessParams;
import eva2.optimization.operator.postprocess.PostProcessParams;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectBestIndividuals;
import eva2.optimization.operator.terminators.CombinedTerminator;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.PBILPopulation;
import eva2.optimization.population.Population;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.strategies.ClusterBasedNichingEA;
import eva2.optimization.strategies.ClusteringHillClimbing;
import eva2.optimization.strategies.DifferentialEvolution;
import eva2.optimization.strategies.EsDpiNiching;
import eva2.optimization.strategies.EsDpiNichingCma;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.optimization.strategies.EvolutionStrategyIPOP;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.GradientDescentAlgorithm;
import eva2.optimization.strategies.HillClimbing;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.MonteCarloSearch;
import eva2.optimization.strategies.MultiObjectiveEA;
import eva2.optimization.strategies.NelderMeadSimplex;
import eva2.optimization.strategies.ParticleSwarmOptimization;
import eva2.optimization.strategies.PopulationBasedIncrementalLearning;
import eva2.optimization.strategies.SimulatedAnnealing;
import eva2.optimization.strategies.Tribes;
import eva2.problems.AbstractOptimizationProblem;
import eva2.tools.math.RNG;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class OptimizerFactory {
    private static InterfaceTerminator userTerm = null;
    public static final int STD_ES = 1;
    public static final int CMA_ES = 2;
    public static final int STD_GA = 3;
    public static final int PSO = 4;
    public static final int DE = 5;
    public static final int TRIBES = 6;
    public static final int RANDOM = 7;
    public static final int HILLCL = 8;
    public static final int CBN_ES = 9;
    public static final int CL_HILLCL = 10;
    public static final int CMA_ES_IPOP = 11;
    public static final int CBN_GA = 12;
    public static final int PBIL = 13;
    public static final int MOGA = 14;
    public static final int defaultFitCalls = 10000;
    public static final int randSeed = 0;
    private static OptimizerRunnable lastRunnable = null;
    private static final int cbnDefaultHaltingWindowLength = new ClusterBasedNichingEA().getHaltingWindow();
    private static final double cbnDefaultHaltingWindowEpsilon = new ClusterBasedNichingEA().getEpsilonBound();
    private static final double cbnDefaultClusterSigma = 0.1;
    private static final int cbnDefaultMinGroupSize = 5;
    private static final int cbnDefaultMaxGroupSize = -1;

    public static DifferentialEvolution createDifferentialEvolution(AbstractOptimizationProblem problem, int popsize, double f, double lambda, double CR, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        OptimizerFactory.setTemplateOperators(problem, new NoMutation(), 0.0, new NoCrossover(), 0.0);
        DifferentialEvolution de = new DifferentialEvolution();
        de.setProblem(problem);
        de.getPopulation().setTargetSize(popsize);
        de.setDEType(DEType.RandToBest);
        de.setDifferentialWeight(f);
        de.setCrossoverRate(CR);
        de.setLambda(lambda);
        de.addPopulationChangedEventListener(listener);
        de.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(de.getPopulation(), "");
        }
        return de;
    }

    public static EvolutionStrategies createEvolutionStrategy(int mu, int lambda, boolean plus, InterfaceMutation mutationoperator, double pm, InterfaceCrossover crossoveroperator, double pc, InterfaceSelection selection, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        return OptimizerFactory.createES(new EvolutionStrategies(mu, lambda, plus), mutationoperator, pm, crossoveroperator, pc, selection, problem, listener);
    }

    public static EvolutionStrategyIPOP createEvolutionStrategyIPOP(int mu, int lambda, boolean plus, InterfaceMutation mutationoperator, double pm, InterfaceCrossover crossoveroperator, double pc, double incPopSizeFact, double stagThresh, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        EvolutionStrategyIPOP esIPOP = (EvolutionStrategyIPOP)OptimizerFactory.createES(new EvolutionStrategyIPOP(mu, lambda, plus), mutationoperator, pm, crossoveroperator, pc, new SelectBestIndividuals(), problem, listener);
        esIPOP.setIncPopSizeFact(incPopSizeFact);
        esIPOP.setStagThreshold(stagThresh);
        return esIPOP;
    }

    private static EvolutionStrategies createES(EvolutionStrategies theES, InterfaceMutation mutationoperator, double pm, InterfaceCrossover crossoveroperator, double pc, InterfaceSelection selection, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        AbstractEAIndividual tmpIndi = problem.getIndividualTemplate();
        AbstractEAIndividual.setOperators(tmpIndi, mutationoperator, pm, crossoveroperator, pc);
        theES.addPopulationChangedEventListener(listener);
        theES.setEnvironmentSelection(selection);
        theES.setProblem(problem);
        theES.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(theES.getPopulation(), "");
        }
        return theES;
    }

    public static GeneticAlgorithm createGeneticAlgorithm(InterfaceMutation mut, double pm, InterfaceCrossover cross, double pc, InterfaceSelection select, int popsize, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        OptimizerFactory.setTemplateOperators(problem, mut, pm, cross, pc);
        GeneticAlgorithm ga = new GeneticAlgorithm();
        ga.setProblem(problem);
        ga.getPopulation().setTargetSize(popsize);
        ga.setParentSelection(select);
        ga.setPartnerSelection(select);
        ga.addPopulationChangedEventListener(listener);
        ga.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(ga.getPopulation(), "");
        }
        return ga;
    }

    public static MultiObjectiveEA createMultiObjectiveEA(InterfaceOptimizer subOpt, int archiveSize, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        return OptimizerFactory.createMultiObjectiveEA(subOpt, new ArchivingNSGAII(), archiveSize, new InformationRetrievalInserting(), problem, listener);
    }

    public static OptimizationParameters standardMOGA(AbstractOptimizationProblem problem) {
        OptimizationParameters gaParams = OptimizerFactory.standardGA(problem);
        int archiveSize = 100;
        int popSize = 100;
        MultiObjectiveEA moga = OptimizerFactory.createMultiObjectiveEA(gaParams.getOptimizer(), archiveSize, problem, null);
        return OptimizerFactory.makeParams((InterfaceOptimizer)moga, popSize, problem, 0L, OptimizerFactory.makeDefaultTerminator());
    }

    public static MultiObjectiveEA createMultiObjectiveEA(InterfaceOptimizer subOpt, InterfaceArchiving archiving, int archiveSize, InterfaceInformationRetrieval infoRetrieval, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        subOpt.setProblem(problem);
        return new MultiObjectiveEA(subOpt, archiving, archiveSize, infoRetrieval, problem);
    }

    public static GradientDescentAlgorithm createGradientDescent(AbstractOptimizationProblem problem) {
        System.err.println("Currently not implemented!");
        problem.initializeProblem();
        AbstractEAIndividual tmpIndi = problem.getIndividualTemplate();
        tmpIndi.setCrossoverOperator(new NoCrossover());
        tmpIndi.setCrossoverProbability(0.0);
        GradientDescentAlgorithm gd = new GradientDescentAlgorithm();
        return gd;
    }

    public static HillClimbing createHillClimber(int popSize, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        return OptimizerFactory.createHillClimber(popSize, new MutateESFixedStepSize(0.2), problem, listener);
    }

    public static HillClimbing createHillClimber(int popSize, InterfaceMutation mutator, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        OptimizerFactory.setTemplateOperators(problem, mutator, 1.0, new NoCrossover(), 0.0);
        HillClimbing hc = new HillClimbing();
        hc.getPopulation().setTargetSize(popSize);
        hc.addPopulationChangedEventListener(listener);
        hc.setProblem(problem);
        hc.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(hc.getPopulation(), "");
        }
        return hc;
    }

    public static MonteCarloSearch createMonteCarlo(AbstractOptimizationProblem problem, int popsize, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        OptimizerFactory.setTemplateOperators(problem, new NoMutation(), 0.0, new NoCrossover(), 0.0);
        MonteCarloSearch mc = new MonteCarloSearch();
        mc.getPopulation().setTargetSize(popsize);
        mc.addPopulationChangedEventListener(listener);
        mc.setProblem(problem);
        mc.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(mc.getPopulation(), "");
        }
        return mc;
    }

    public static ParticleSwarmOptimization createParticleSwarmOptimization(AbstractOptimizationProblem problem, int popsize, double phi1, double phi2, double speedLim, PSOTopology selectedTopology, int topologyRange, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        OptimizerFactory.setTemplateOperators(problem, new NoMutation(), 0.0, new NoCrossover(), 0.0);
        ParticleSwarmOptimization pso = new ParticleSwarmOptimization();
        pso.setProblem(problem);
        pso.getPopulation().setTargetSize(popsize);
        pso.setPhi1(phi1);
        pso.setPhi2(phi2);
        pso.setSpeedLimit(speedLim);
        pso.setTopology(selectedTopology);
        pso.setTopologyRange(topologyRange);
        pso.addPopulationChangedEventListener(listener);
        pso.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(pso.getPopulation(), "");
        }
        return pso;
    }

    public static SimulatedAnnealing createSimulatedAnnealing(AbstractOptimizationProblem problem, int popsize, double alpha, double temperature, InterfaceMutation mut, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        OptimizerFactory.setTemplateOperators(problem, mut, 1.0, new NoCrossover(), 0.0);
        SimulatedAnnealing sa = new SimulatedAnnealing();
        sa.setAlpha(alpha);
        sa.setInitialTemperature(temperature);
        sa.setProblem(problem);
        sa.getPopulation().setTargetSize(popsize);
        sa.addPopulationChangedEventListener(listener);
        sa.initialize();
        if (listener != null) {
            listener.registerPopulationStateChanged(sa.getPopulation(), "");
        }
        return sa;
    }

    public static PopulationBasedIncrementalLearning createPBIL(double learningRate, double mutateSigma, double mutationRate, int positiveSamples, InterfaceSelection selection, int popsize, AbstractOptimizationProblem problem, InterfacePopulationChangedEventListener listener) {
        problem.initializeProblem();
        PopulationBasedIncrementalLearning pbil = new PopulationBasedIncrementalLearning();
        pbil.setLearningRate(learningRate);
        pbil.setMutateSigma(mutateSigma);
        pbil.setMutationRate(mutationRate);
        pbil.setPopulation(new PBILPopulation(popsize));
        pbil.setSelectionMethod(selection);
        pbil.setPositiveSamples(positiveSamples);
        pbil.addPopulationChangedEventListener(listener);
        pbil.setProblem(problem);
        if (listener != null) {
            listener.registerPopulationStateChanged(pbil.getPopulation(), "");
        }
        return pbil;
    }

    public static InterfaceTerminator makeDefaultTerminator() {
        return new EvaluationTerminator(10000);
    }

    public static int getDefaultFitCalls() {
        return 10000;
    }

    public static OptimizationParameters getParams(int optType, AbstractOptimizationProblem problem) {
        switch (optType) {
            case 1: {
                return OptimizerFactory.standardES(problem);
            }
            case 2: {
                return OptimizerFactory.cmaES(problem);
            }
            case 3: {
                return OptimizerFactory.standardGA(problem);
            }
            case 4: {
                return OptimizerFactory.standardPSO(problem);
            }
            case 5: {
                return OptimizerFactory.standardDE(problem);
            }
            case 6: {
                return OptimizerFactory.tribes(problem);
            }
            case 7: {
                return OptimizerFactory.monteCarlo(problem);
            }
            case 8: {
                return OptimizerFactory.hillClimbing(problem);
            }
            case 9: {
                return OptimizerFactory.standardCbnES(problem);
            }
            case 10: {
                return OptimizerFactory.stdClusteringHillClimbing(problem);
            }
            case 11: {
                return OptimizerFactory.cmaESIPOP(problem);
            }
            case 12: {
                return OptimizerFactory.standardCbnGA(problem);
            }
            case 13: {
                return OptimizerFactory.standardPBIL(problem);
            }
            case 14: {
                return OptimizerFactory.standardMOGA(problem);
            }
        }
        System.err.println("Error: optimizer type " + optType + " is unknown!");
        return null;
    }

    public static String showOptimizers() {
        return "1: Standard ES \n2: CMA-ES \n3: GA \n4: PSO \n5: DE \n6: Tribes \n7: Random (Monte Carlo) \n8: Hill-Climbing \n9: Cluster-based niching ES \n10: Clustering Hill-Climbing \n11: IPOP-CMA-ES \n12: Cluster-based niching GA \n13: PBIL \n14: MOGA, a Multi-Objective Genetic Algorithm";
    }

    public static OptimizerRunnable getOptRunnable(int optType, AbstractOptimizationProblem problem, int fitCalls, String outputFilePrefix) {
        return OptimizerFactory.getOptRunnable(optType, problem, new EvaluationTerminator(fitCalls), outputFilePrefix);
    }

    public static OptimizerRunnable getOptRunnable(int optType, AbstractOptimizationProblem problem, InterfaceTerminator terminator, String outputFilePrefix) {
        OptimizerRunnable opt = null;
        OptimizationParameters params = OptimizerFactory.getParams(optType, problem);
        if (params != null) {
            opt = new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix);
            if (terminator != null) {
                opt.getOptimizationParameters().setTerminator(terminator);
            } else {
                opt.getOptimizationParameters().setTerminator(OptimizerFactory.getTerminator());
            }
        }
        return opt;
    }

    public static OptimizerRunnable getOptRunnable(OptimizationParameters params, String outputFilePrefix) {
        return new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix);
    }

    public static OptimizerRunnable getOptRunnable(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        return OptimizerFactory.getOptRunnable(optType, problem, OptimizerFactory.getTerminator(), outputFilePrefix);
    }

    public static InterfaceTerminator getTerminator() {
        if (userTerm != null) {
            return userTerm;
        }
        return OptimizerFactory.makeDefaultTerminator();
    }

    public static int lastEvalsPerformed() {
        return lastRunnable != null ? lastRunnable.getProgress() : -1;
    }

    public static OptimizationParameters makeESParams(EvolutionStrategies es, AbstractOptimizationProblem problem) {
        return OptimizerFactory.makeParams((InterfaceOptimizer)es, es.getLambda(), problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters makeParams(InterfaceOptimizer opt, int popSize, AbstractOptimizationProblem problem) {
        return OptimizerFactory.makeParams(opt, popSize, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters makeParams(InterfaceOptimizer opt, AbstractOptimizationProblem problem, InterfaceTerminator term) {
        return OptimizerFactory.makeParams(opt, opt.getPopulation().getTargetSize(), problem, 0L, term);
    }

    public static OptimizationParameters makeParams(InterfaceOptimizer opt, int popSize, AbstractOptimizationProblem problem, long seed, InterfaceTerminator term) {
        Population pop = new Population(popSize);
        RNG.setRandomSeed(seed);
        problem.initializePopulation(pop);
        return OptimizerFactory.makeParams(opt, pop, problem, seed, term);
    }

    public static OptimizationParameters makeParams(InterfaceOptimizer opt, Population pop, AbstractOptimizationProblem problem, long seed, InterfaceTerminator term) {
        OptimizationParameters params = new OptimizationParameters();
        params.setProblem(problem);
        opt.setProblem(problem);
        opt.setPopulation(pop);
        params.setOptimizer(opt);
        params.setTerminator(term);
        params.setRandomSeed(seed);
        return params;
    }

    public static OptimizerRunnable optimize(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        return OptimizerFactory.optimize(OptimizerFactory.getOptRunnable(optType, problem, outputFilePrefix));
    }

    public static OptimizerRunnable optimize(OptimizerRunnable runnable) {
        if (runnable == null) {
            return null;
        }
        new Thread(runnable).run();
        lastRunnable = runnable;
        return runnable;
    }

    public static OptimizerRunnable optimizeInThread(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        return OptimizerFactory.optimizeInThread(OptimizerFactory.getOptRunnable(optType, problem, outputFilePrefix));
    }

    public static OptimizerRunnable optimizeInThread(OptimizationParameters params, String outputFilePrefix) {
        return OptimizerFactory.optimizeInThread(new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix));
    }

    public static OptimizerRunnable optimizeInThread(OptimizerRunnable runnable) {
        if (runnable != null) {
            new Thread(runnable).start();
            lastRunnable = runnable;
        }
        return runnable;
    }

    public static BitSet optimizeToBinary(OptimizationParameters params, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix));
        return runnable.getBinarySolution();
    }

    public static BitSet optimizeToBinary(int optType, AbstractOptimizationProblem problem) {
        return OptimizerFactory.optimizeToBinary(optType, problem, null);
    }

    public static BitSet optimizeToBinary(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(optType, problem, outputFilePrefix);
        return runnable != null ? runnable.getBinarySolution() : null;
    }

    public static BitSet optimizeToBinary(OptimizerRunnable runnable) {
        OptimizerFactory.optimize(runnable);
        return runnable != null ? runnable.getBinarySolution() : null;
    }

    public static double[] optimizeToDouble(OptimizationParameters params, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix));
        return runnable.getDoubleSolution();
    }

    public static double[] optimizeToDouble(OptimizationParameters params) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, false));
        return runnable.getDoubleSolution();
    }

    public static double[] optimizeToDouble(OptimizationParameters params, InterfaceStatistics stats) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, stats, false));
        return runnable.getDoubleSolution();
    }

    public static double[] optimizeToDouble(int optType, AbstractOptimizationProblem problem) {
        return OptimizerFactory.optimizeToDouble(optType, problem, null);
    }

    public static double[] optimizeToDouble(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(optType, problem, outputFilePrefix);
        return runnable != null ? runnable.getDoubleSolution() : null;
    }

    public static double[] optimizeToDouble(OptimizerRunnable runnable) {
        OptimizerFactory.optimize(runnable);
        return runnable != null ? runnable.getDoubleSolution() : null;
    }

    public static IndividualInterface optimizeToInd(OptimizationParameters params) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, false));
        return runnable.getResult();
    }

    public static IndividualInterface optimizeToInd(OptimizationParameters params, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix));
        return runnable.getResult();
    }

    public static IndividualInterface optimizeToInd(int optType, AbstractOptimizationProblem problem) {
        return OptimizerFactory.optimizeToInd(optType, problem, null);
    }

    public static IndividualInterface optimizeToInd(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(optType, problem, outputFilePrefix);
        return runnable != null ? runnable.getResult() : null;
    }

    public static IndividualInterface optimizeToInd(OptimizerRunnable runnable) {
        OptimizerFactory.optimize(runnable);
        return runnable != null ? runnable.getResult() : null;
    }

    public static Population optimizeToPop(OptimizationParameters params, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(new OptimizerRunnable((InterfaceOptimizationParameters)params, outputFilePrefix));
        return runnable.getResultPopulation();
    }

    public static Population optimizeToPop(int optType, AbstractOptimizationProblem problem, String outputFilePrefix) {
        OptimizerRunnable runnable = OptimizerFactory.optimize(optType, problem, outputFilePrefix);
        return runnable != null ? runnable.getResultPopulation() : null;
    }

    public static Population optimizeToPop(OptimizerRunnable runnable) {
        OptimizerFactory.optimize(runnable);
        return runnable != null ? runnable.getResultPopulation() : null;
    }

    public static Population postProcess(PostProcessMethod method, int steps, double sigma, int nBest) {
        return lastRunnable == null ? null : OptimizerFactory.postProcess(lastRunnable, new PostProcessParams(method, steps, sigma, nBest));
    }

    public static Population postProcess(InterfacePostProcessParams ppp) {
        return lastRunnable == null ? null : OptimizerFactory.postProcess(lastRunnable, ppp);
    }

    public static Population postProcess(OptimizerRunnable runnable, int steps, double sigma, int nBest) {
        PostProcessParams ppp = new PostProcessParams(steps, sigma, nBest);
        return OptimizerFactory.postProcess(runnable, ppp);
    }

    public static Population postProcess(OptimizerRunnable runnable, InterfacePostProcessParams ppp) {
        runnable.setDoRestart(true);
        runnable.setDoPostProcessOnly(true);
        runnable.setPostProcessingParams(ppp);
        runnable.run();
        return runnable.getResultPopulation();
    }

    public static List<BitSet> postProcessBinVec(int steps, double sigma, int nBest) {
        return lastRunnable != null ? OptimizerFactory.postProcessBinVec(lastRunnable, new PostProcessParams(steps, sigma, nBest)) : null;
    }

    public static List<BitSet> postProcessBinVec(InterfacePostProcessParams ppp) {
        return lastRunnable != null ? OptimizerFactory.postProcessBinVec(lastRunnable, ppp) : null;
    }

    public static List<BitSet> postProcessBinVec(OptimizerRunnable runnable, int steps, double sigma, int nBest) {
        return OptimizerFactory.postProcessBinVec(runnable, new PostProcessParams(steps, sigma, nBest));
    }

    public static List<BitSet> postProcessBinVec(OptimizerRunnable runnable, InterfacePostProcessParams ppp) {
        Population resPop = OptimizerFactory.postProcess(runnable, ppp);
        ArrayList<BitSet> ret = new ArrayList<BitSet>(resPop.size());
        for (Object o : resPop) {
            if (!(o instanceof InterfaceDataTypeBinary)) continue;
            InterfaceDataTypeBinary indy = (InterfaceDataTypeBinary)o;
            ret.add(indy.getBinaryData());
        }
        return ret;
    }

    public static List<double[]> postProcessDblVec(int steps, double sigma, int nBest) {
        return lastRunnable == null ? null : OptimizerFactory.postProcessDblVec(lastRunnable, new PostProcessParams(steps, sigma, nBest));
    }

    public static List<double[]> postProcessDblVec(InterfacePostProcessParams ppp) {
        return lastRunnable != null ? OptimizerFactory.postProcessDblVec(lastRunnable, ppp) : null;
    }

    public static List<double[]> postProcessDblVec(OptimizerRunnable runnable, int steps, double sigma, int nBest) {
        return OptimizerFactory.postProcessDblVec(runnable, new PostProcessParams(steps, sigma, nBest));
    }

    public static List<double[]> postProcessDblVec(OptimizerRunnable runnable, InterfacePostProcessParams ppp) {
        Population resPop = OptimizerFactory.postProcess(runnable, ppp);
        ArrayList<double[]> ret = new ArrayList<double[]>(resPop.size());
        for (Object o : resPop) {
            if (!(o instanceof InterfaceDataTypeDouble)) continue;
            InterfaceDataTypeDouble indy = (InterfaceDataTypeDouble)o;
            ret.add(indy.getDoubleData());
        }
        return ret;
    }

    public static List<AbstractEAIndividual> postProcessIndVec(int steps, double sigma, int nBest) {
        return lastRunnable != null ? OptimizerFactory.postProcessIndVec(lastRunnable, new PostProcessParams(steps, sigma, nBest)) : null;
    }

    public static List<AbstractEAIndividual> postProcessIndVec(InterfacePostProcessParams ppp) {
        return lastRunnable != null ? OptimizerFactory.postProcessIndVec(lastRunnable, ppp) : null;
    }

    public static List<AbstractEAIndividual> postProcessIndVec(OptimizerRunnable runnable, int steps, double sigma, int nBest) {
        return OptimizerFactory.postProcessIndVec(runnable, new PostProcessParams(steps, sigma, nBest));
    }

    public static List<AbstractEAIndividual> postProcessIndVec(OptimizerRunnable runnable, InterfacePostProcessParams ppp) {
        Population resPop = OptimizerFactory.postProcess(runnable, ppp);
        ArrayList<AbstractEAIndividual> ret = new ArrayList<AbstractEAIndividual>(resPop.size());
        for (Object o : resPop) {
            if (!(o instanceof AbstractEAIndividual)) continue;
            AbstractEAIndividual indy = (AbstractEAIndividual)o;
            ret.add(indy);
        }
        return ret;
    }

    public static void setTerminator(InterfaceTerminator term) {
        userTerm = term;
    }

    public static void addTerminator(InterfaceTerminator newTerm, boolean bAnd) {
        if (userTerm == null) {
            userTerm = newTerm;
        } else {
            OptimizerFactory.setTerminator(new CombinedTerminator(userTerm, newTerm, bAnd));
        }
    }

    public static void setEvaluationTerminator(int maxEvals) {
        OptimizerFactory.setTerminator(new EvaluationTerminator(maxEvals));
    }

    public static String terminatedBecause() {
        return lastRunnable != null ? lastRunnable.terminatedBecause() : null;
    }

    public static OptimizationParameters hillClimbing(AbstractOptimizationProblem problem) {
        return OptimizerFactory.hillClimbing(problem, 50);
    }

    public static OptimizationParameters hillClimbing(AbstractOptimizationProblem problem, int popSize) {
        return OptimizerFactory.makeParams((InterfaceOptimizer)new HillClimbing(), popSize, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters monteCarlo(AbstractOptimizationProblem problem) {
        return OptimizerFactory.makeParams((InterfaceOptimizer)new MonteCarloSearch(), 50, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters createCbn(AbstractOptimizationProblem problem, InterfaceOptimizer opt, double clusterSigma, int minClustSize, int maxSpecSize, int haltingWindowLength, double haltingWindowEpsilon, int popSize) {
        return OptimizerFactory.createCbn(problem, opt, new ClusteringDensityBased(clusterSigma, minClustSize), maxSpecSize, new ClusteringDensityBased(clusterSigma, minClustSize), haltingWindowLength, haltingWindowEpsilon, popSize);
    }

    public static OptimizationParameters standardCbnPSO(AbstractOptimizationProblem problem) {
        return OptimizerFactory.createCbnPSO(problem, 0.1, 5, -1, cbnDefaultHaltingWindowLength, cbnDefaultHaltingWindowEpsilon, 100);
    }

    public static OptimizationParameters createCbnPSO(AbstractOptimizationProblem problem, double clusterSigma, int minClustSize, int maxSpecSize, int haltingWindowLength, double haltingWindowEpsilon, int popSize) {
        OptimizationParameters psoParams = OptimizerFactory.standardPSO(problem);
        ParticleSwarmOptimization pso = (ParticleSwarmOptimization)psoParams.getOptimizer();
        ClusteringDensityBased clust = new ClusteringDensityBased(clusterSigma, minClustSize, new IndividualDataMetric("BestPosition"));
        return OptimizerFactory.createCbn(problem, (InterfaceOptimizer)pso, clust, maxSpecSize, new ClusteringDensityBased(clust), haltingWindowLength, haltingWindowEpsilon, popSize);
    }

    public static OptimizationParameters createCbn(AbstractOptimizationProblem problem, InterfaceOptimizer opt, InterfaceClustering clustDifferentiate, int maxSpecSize, InterfaceClustering clustMerge, int haltingWindowLength, double haltingWindowEpsilon, int popSize) {
        ClusterBasedNichingEA cbn = new ClusterBasedNichingEA();
        cbn.setOptimizer(opt);
        cbn.setMergingCA(clustMerge);
        cbn.setMaxSpeciesSize(maxSpecSize);
        cbn.setDifferentiationCA(clustDifferentiate);
        if (clustMerge != null) {
            cbn.setUseMerging(true);
        }
        cbn.setShowCycle(0);
        cbn.setHaltingWindow(haltingWindowLength);
        cbn.setEpsilonBound(haltingWindowEpsilon);
        return OptimizerFactory.makeParams((InterfaceOptimizer)cbn, popSize, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters standardCbnES(AbstractOptimizationProblem problem) {
        EvolutionStrategies es = new EvolutionStrategies();
        es.setMu(15);
        es.setLambda(50);
        es.setPlusStrategy(false);
        return OptimizerFactory.createCbn(problem, (InterfaceOptimizer)es, 0.1, 5, -1, cbnDefaultHaltingWindowLength, cbnDefaultHaltingWindowEpsilon, 100);
    }

    public static OptimizationParameters standardCbnCmaES(AbstractOptimizationProblem problem) {
        OptimizationParameters cmaEsParams = OptimizerFactory.cmaES(problem);
        EvolutionStrategies cmaES = (EvolutionStrategies)cmaEsParams.getOptimizer();
        return OptimizerFactory.createCbn(problem, (InterfaceOptimizer)cmaES, 0.1, 5, -1, cbnDefaultHaltingWindowLength, cbnDefaultHaltingWindowEpsilon, 100);
    }

    public static OptimizationParameters standardCbnGA(AbstractOptimizationProblem problem) {
        GeneticAlgorithm ga = new GeneticAlgorithm();
        return OptimizerFactory.createCbn(problem, (InterfaceOptimizer)ga, 0.1, 5, -1, cbnDefaultHaltingWindowLength, cbnDefaultHaltingWindowEpsilon, 100);
    }

    public static OptimizationParameters standardPBIL(AbstractOptimizationProblem problem) {
        PopulationBasedIncrementalLearning pbil = OptimizerFactory.createPBIL(0.04, 0.01, 0.5, 1, new SelectBestIndividuals(), 50, problem, null);
        return OptimizerFactory.makeParams((InterfaceOptimizer)pbil, pbil.getPopulation(), problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters stdClusteringHillClimbing(AbstractOptimizationProblem problem) {
        return OptimizerFactory.clusteringHillClimbing(problem, 1000, 100, 1.0E-6, PostProcessMethod.hillClimber, 0.05, 1.0E-6, 0.05);
    }

    public static OptimizationParameters clusteringHillClimbingNM(AbstractOptimizationProblem problem, int evalCycle, int popSize, double minImprovement, double sigmaClust) {
        return OptimizerFactory.clusteringHillClimbing(problem, evalCycle, popSize, minImprovement, PostProcessMethod.nelderMead, 0.01, 1.0E-8, sigmaClust);
    }

    public static OptimizationParameters clusteringHillClimbing(AbstractOptimizationProblem problem, int evalCycle, int popSize, double minImprovement, PostProcessMethod method, double hcInitialStep, double hcStepThresh, double sigmaClust) {
        ClusteringHillClimbing chc = new ClusteringHillClimbing();
        chc.setProblem(problem);
        chc.setEvalCycle(evalCycle);
        chc.setInitialPopSize(popSize);
        chc.setStepSizeInitial(hcInitialStep);
        chc.setLocalSearchMethod(method);
        chc.setMinImprovement(minImprovement);
        chc.setNotifyGuiEvery(0);
        chc.setStepSizeThreshold(hcStepThresh);
        chc.setSigmaClust(sigmaClust);
        return OptimizerFactory.makeParams((InterfaceOptimizer)chc, popSize, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters cmaES(AbstractOptimizationProblem problem) {
        EvolutionStrategies es = new EvolutionStrategies();
        es.setMu(15);
        es.setLambda(50);
        es.setPlusStrategy(false);
        if (!OptimizerFactory.assertIndyType(problem, InterfaceESIndividual.class)) {
            System.err.println("Error, CMA-ES is implemented for ES individuals only (requires double data types)");
            return null;
        }
        OptimizerFactory.setTemplateOperators(problem, new MutateESCovarianceMatrixAdaption(true), 1.0, new CrossoverESDefault(), 0.0);
        return OptimizerFactory.makeESParams(es, problem);
    }

    public static OptimizationParameters cmaESIPOP(AbstractOptimizationProblem problem) {
        return OptimizerFactory.createCmaEsIPop(problem, 2.0);
    }

    public static OptimizationParameters createCmaEsIPop(AbstractOptimizationProblem problem, double incLambdaFact) {
        EvolutionStrategyIPOP es = new EvolutionStrategyIPOP();
        AbstractEAIndividual indyTemplate = problem.getIndividualTemplate();
        if (indyTemplate == null || !(indyTemplate instanceof InterfaceESIndividual) && !(indyTemplate instanceof InterfaceDataTypeDouble)) {
            System.err.println("Error, CMA-ES is implemented for ES individuals only (requires double data types)");
            return null;
        }
        int dim = indyTemplate instanceof InterfaceESIndividual ? ((InterfaceESIndividual)((Object)indyTemplate)).getDGenotype().length : ((InterfaceDataTypeDouble)((Object)indyTemplate)).getDoubleData().length;
        int lambda = (int)(4.0 + 3.0 * Math.log(dim));
        es.setGenerationStrategy((int)Math.floor((double)lambda / 2.0), lambda, false);
        es.setForceOrigPopSize(false);
        es.setIncPopSizeFact(incLambdaFact);
        AbstractEAIndividual indy = indyTemplate;
        MutateESRankMuCMA cmaMut = new MutateESRankMuCMA();
        AbstractEAIndividual.setOperators(indy, cmaMut, 1.0, new CrossoverESDefault(), 0.0);
        return OptimizerFactory.makeESParams(es, problem);
    }

    public static OptimizationParameters standardNMS(AbstractOptimizationProblem problem) {
        NelderMeadSimplex nms = NelderMeadSimplex.createNelderMeadSimplex(problem, null);
        return OptimizerFactory.makeParams((InterfaceOptimizer)nms, 50, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters standardDE(AbstractOptimizationProblem problem) {
        DifferentialEvolution de = new DifferentialEvolution();
        de.setDEType(DEType.RandToBest);
        de.setDifferentialWeight(0.8);
        de.setCrossoverRate(0.6);
        de.setLambda(0.6);
        de.setMt(0.05);
        return OptimizerFactory.makeParams((InterfaceOptimizer)de, 50, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters standardES(AbstractOptimizationProblem problem) {
        EvolutionStrategies es = new EvolutionStrategies();
        es.setMu(15);
        es.setLambda(50);
        es.setPlusStrategy(false);
        if (!OptimizerFactory.assertIndyType(problem, InterfaceESIndividual.class)) {
            System.err.println("Error, standard ES is implemented for ES individuals only (requires double data types)");
            return null;
        }
        OptimizerFactory.setTemplateOperators(problem, new MutateESGlobal(0.2, MutateESCrossoverType.intermediate), 0.9, new CrossoverESDefault(), 0.2);
        return OptimizerFactory.makeESParams(es, problem);
    }

    public static OptimizationParameters standardGA(AbstractOptimizationProblem problem) {
        GeneticAlgorithm ga = new GeneticAlgorithm();
        ga.setElitism(true);
        return OptimizerFactory.makeParams((InterfaceOptimizer)ga, 100, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters standardPSO(AbstractOptimizationProblem problem) {
        ParticleSwarmOptimization pso = new ParticleSwarmOptimization();
        pso.setPhiValues(2.05, 2.05);
        pso.setTopology(PSOTopology.grid);
        pso.setTopologyRange(1);
        return OptimizerFactory.makeParams((InterfaceOptimizer)pso, 30, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters tribes(AbstractOptimizationProblem problem) {
        return OptimizerFactory.makeParams((InterfaceOptimizer)new Tribes(), 1, problem, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters standardNichingEs(AbstractOptimizationProblem prob) {
        return OptimizerFactory.createNichingEs(prob, -1.0, 100, 100, 10, 200, 0, 100, 50);
    }

    public static OptimizationParameters createNichingEs(AbstractOptimizationProblem prob, double nicheRadius, int muPerPeak, int lambdaPerPeak, int expectedPeaks, int rndImmigrants, int explorerPeaks, int resetExplInterval, int etaPresel) {
        EsDpiNiching nes = new EsDpiNiching(nicheRadius, muPerPeak, lambdaPerPeak, expectedPeaks, rndImmigrants, explorerPeaks, resetExplInterval, etaPresel);
        if (!OptimizerFactory.assertIndyType(prob, InterfaceESIndividual.class)) {
            System.err.println("Error, standard ES is implemented for ES individuals only (requires double data types)");
            return null;
        }
        OptimizerFactory.setTemplateOperators(prob, new MutateESGlobal(0.2, MutateESCrossoverType.intermediate), 0.9, new CrossoverESDefault(), 0.2);
        return OptimizerFactory.makeParams((InterfaceOptimizer)nes, 100, prob, 0L, OptimizerFactory.getTerminator());
    }

    public static OptimizationParameters standardNichingCmaEs(AbstractOptimizationProblem prob) {
        return OptimizerFactory.createNichingCmaEs(prob, -1.0, 10, 10, 0, 0, -1.0);
    }

    public static OptimizationParameters createNichingCmaEs(AbstractOptimizationProblem prob, double nicheRad) {
        return OptimizerFactory.createNichingCmaEs(prob, nicheRad, 10, 10, 0, 0, -1.0);
    }

    public static OptimizationParameters createNichingCmaEs(AbstractOptimizationProblem prob, double nicheRad, double stagnationEpsilon) {
        return OptimizerFactory.createNichingCmaEs(prob, nicheRad, 10, 10, 0, 0, stagnationEpsilon);
    }

    public static OptimizationParameters createNichingCmaEs(AbstractOptimizationProblem prob, double nicheRad, int nicheCount, double stagnationEpsilon) {
        return OptimizerFactory.createNichingCmaEs(prob, nicheRad, 10, nicheCount, 0, 0, stagnationEpsilon);
    }

    public static OptimizationParameters createNichingCmaEs(AbstractOptimizationProblem prob, double nicheRadius, int lambda, int expectedPeaks, int explorerPeaks, int resetExplInterval, double stagnationEpsilon) {
        EsDpiNichingCma nes = new EsDpiNichingCma(nicheRadius, lambda, expectedPeaks, explorerPeaks, resetExplInterval);
        if (stagnationEpsilon > 0.0) {
            nes.setEpsilonBound(stagnationEpsilon);
        }
        if (!OptimizerFactory.assertIndyType(prob, InterfaceESIndividual.class)) {
            System.err.println("Error, standard ES is implemented for ES individuals only (requires double data types)");
            return null;
        }
        OptimizerFactory.setTemplateOperators(prob, new MutateESRankMuCMA(), 1.0, new CrossoverESDefault(), 0.0);
        return OptimizerFactory.makeParams((InterfaceOptimizer)nes, 100, prob, 0L, OptimizerFactory.getTerminator());
    }

    private static boolean assertIndyType(AbstractOptimizationProblem prob, Class<InterfaceESIndividual> cls) {
        return cls.isAssignableFrom(prob.getIndividualTemplate().getClass());
    }

    public static void setTemplateOperators(AbstractOptimizationProblem prob, InterfaceMutation mute, double pMut, InterfaceCrossover cross, double pCross) {
        AbstractEAIndividual indy = prob.getIndividualTemplate();
        if (indy != null) {
            indy.setOperators(mute, pMut, cross, pCross);
        }
    }
}

