/*
 * Decompiled with CFR 0.152.
 */
package eva2;

import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationStateListener;
import eva2.optimization.Processor;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.operator.postprocess.InterfacePostProcessParams;
import eva2.optimization.operator.postprocess.PostProcessParams;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.population.Population;
import eva2.optimization.population.SolutionSet;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.statistics.StatisticsDummy;
import eva2.optimization.statistics.StatisticsStandalone;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.BitSet;

public class OptimizerRunnable
implements Runnable {
    private Processor proc;
    private boolean isFinished = false;
    private boolean doRestart = false;
    private boolean postProcessOnly = false;
    private InterfaceTextListener listener = null;
    private String ident = "OptimizerRunnable";
    private static int cntID = 0;
    private int rnblID = cntID++;

    public OptimizerRunnable(InterfaceOptimizationParameters params, String outputFilePrefix) {
        this(params, outputFilePrefix, false);
    }

    public OptimizerRunnable(InterfaceOptimizationParameters params, boolean restart) {
        this(params, new StatisticsDummy(), restart);
    }

    public OptimizerRunnable(InterfaceOptimizationParameters params, String outputFilePrefix, boolean restart) {
        this(params, new StatisticsStandalone(outputFilePrefix), restart);
    }

    public OptimizerRunnable(InterfaceOptimizationParameters params, InterfaceStatistics stats, boolean restart) {
        this.proc = new Processor(stats, params);
        if (this.proc.getStatistics() instanceof AbstractStatistics) {
            ((AbstractStatistics)this.proc.getStatistics()).setSaveParams(false);
        }
        this.doRestart = restart;
    }

    public void setIdentifier(String id) {
        this.ident = id;
    }

    public String getIdentifier() {
        return this.ident;
    }

    public int getID() {
        return this.rnblID;
    }

    public InterfaceOptimizationParameters getOptimizationParameters() {
        return this.proc.getOptimizationParameters();
    }

    public InterfaceStatistics getStats() {
        return this.proc.getStatistics();
    }

    public void setStatistics(InterfaceStatistics stats) {
        if (this.proc.isOptimizationRunning()) {
            throw new RuntimeException("Error - cannot change statistics instance during optimization.");
        }
        InterfaceOptimizationParameters params = this.proc.getOptimizationParameters();
        this.proc = new Processor(stats, params);
        if (this.proc.getStatistics() instanceof AbstractStatistics) {
            ((AbstractStatistics)this.proc.getStatistics()).setSaveParams(false);
        }
    }

    public void setTextListener(InterfaceTextListener lsnr) {
        this.proc.getStatistics().removeTextListener(this.listener);
        this.listener = lsnr;
        if (this.listener != null) {
            this.proc.getStatistics().addTextListener(this.listener);
        }
    }

    public void addOptimizationStateListener(OptimizationStateListener rsl) {
        if (this.proc != null) {
            this.proc.addListener(rsl);
        }
    }

    public void setDoRestart(boolean restart) {
        this.doRestart = restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isFinished = false;
        try {
            this.proc.setSaveParams(false);
            if (this.postProcessOnly) {
                this.proc.performPostProcessing((PostProcessParams)this.proc.getOptimizationParameters().getPostProcessParams(), this.listener);
            } else {
                if (this.doRestart) {
                    this.proc.restartOptimization();
                } else {
                    this.proc.startOptimization();
                }
                this.proc.runOptimizationOnce();
            }
        }
        catch (Exception e) {
            this.proc.getStatistics().printToTextListener("Exception in OptimizeThread::run: " + e.getMessage() + "\n");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.proc.getStatistics().printToTextListener(sw.toString());
        }
        this.isFinished = true;
        OptimizerRunnable optimizerRunnable = this;
        synchronized (optimizerRunnable) {
            this.notifyAll();
        }
    }

    public void setDoPostProcessOnly(boolean poPO) {
        this.postProcessOnly = poPO;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean wasAborted() {
        return this.proc != null && this.proc.wasAborted();
    }

    public void restartOpt() {
        this.proc.restartOptimization();
    }

    public void stopOpt() {
        this.proc.stopOptimization();
    }

    public IndividualInterface getResult() {
        return this.proc.getStatistics().getBestSolution();
    }

    public Population getResultPopulation() {
        return this.proc.getResultPopulation();
    }

    public SolutionSet getSolutionSet() {
        return (SolutionSet)this.proc.getOptimizationParameters().getOptimizer().getAllSolutions();
    }

    public void setPostProcessingParams(InterfacePostProcessParams ppp) {
        this.proc.getOptimizationParameters().setPostProcessParams(ppp);
    }

    public int getProgress() {
        return this.proc.getOptimizationParameters().getOptimizer().getPopulation().getFunctionCalls();
    }

    public String terminatedBecause() {
        if (this.isFinished) {
            if (this.postProcessOnly) {
                return "Post processing finished";
            }
            InterfaceTerminator term = this.proc.getOptimizationParameters().getTerminator();
            return term.lastTerminationMessage();
        }
        return "Not yet terminated";
    }

    public double[] getDoubleSolution() {
        IndividualInterface indy = this.getResult();
        if (indy instanceof InterfaceDataTypeDouble) {
            return ((InterfaceDataTypeDouble)((Object)indy)).getDoubleData();
        }
        return null;
    }

    public BitSet getBinarySolution() {
        IndividualInterface indy = this.getResult();
        if (indy instanceof InterfaceDataTypeBinary) {
            return ((InterfaceDataTypeBinary)((Object)indy)).getBinaryData();
        }
        return null;
    }

    public int[] getIntegerSolution() {
        IndividualInterface indy = this.getResult();
        if (indy instanceof InterfaceDataTypeInteger) {
            return ((InterfaceDataTypeInteger)((Object)indy)).getIntegerData();
        }
        return null;
    }

    public void setVerbosityLevel(InterfaceStatisticsParameters.OutputVerbosity vLev) {
        this.proc.getStatistics().getStatisticsParameters().setOutputVerbosity(vLev);
    }

    public void setOutputTo(InterfaceStatisticsParameters.OutputTo outp) {
        this.proc.getStatistics().getStatisticsParameters().setOutputTo(outp);
    }

    public void setMultiRuns(int multis) {
        this.proc.getStatistics().getStatisticsParameters().setMultiRuns(multis);
    }

    public void setOutputFullStatsToText(boolean addInfo) {
        this.proc.getStatistics().getStatisticsParameters().setOutputAllFieldsAsText(addInfo);
    }
}

