/*
 * Decompiled with CFR 0.152.
 */
package eva2.cli;

import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.individuals.IndividualInterface;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.optimization.statistics.InterfaceStatistics;
import eva2.optimization.statistics.InterfaceStatisticsListener;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.InterfaceTextListener;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class CommandLineStatistics
implements InterfaceStatistics {
    private InterfaceStatisticsParameters statisticsParameters;
    private List<LinkedHashMap<String, Object>> runs;
    private LinkedHashMap<String, Object> currentRun;
    private ArrayList<Map<String, Object>> currentGenerations;
    private InterfaceOptimizationParameters currentParameters;
    private int currentGeneration;

    public CommandLineStatistics(InterfaceStatisticsParameters statisticsParameters) {
        this.statisticsParameters = statisticsParameters;
        this.runs = new ArrayList<LinkedHashMap<String, Object>>(statisticsParameters.getMultiRuns());
    }

    @Override
    public void startOptimizationPerformed(String infoString, int runNumber, InterfaceOptimizationParameters params, List<InterfaceAdditionalPopulationInformer> informerList) {
        this.currentRun = new LinkedHashMap();
        this.currentRun.put("name", infoString);
        this.currentRun.put("runNumber", runNumber + 1);
        this.currentGenerations = new ArrayList();
        this.currentGeneration = 0;
        this.currentParameters = params;
    }

    @Override
    public void stopOptimizationPerformed(boolean normal, String stopMessage) {
        this.currentRun.put("stopMessage", stopMessage);
        this.currentRun.put("totalFunctionCalls", this.currentParameters.getOptimizer().getPopulation().getFunctionCalls());
        Population pop = this.currentParameters.getOptimizer().getAllSolutions().getSolutions();
        this.currentRun.put("solution", pop.getBestEAIndividual().getDoublePosition().clone());
        this.currentRun.put("bestFitness", pop.getBestFitness().clone());
        this.currentRun.put("meanFitness", pop.getMeanFitness().clone());
        this.runs.add(this.currentRun);
    }

    @Override
    public void addDataListener(InterfaceStatisticsListener listener) {
    }

    @Override
    public boolean removeDataListener(InterfaceStatisticsListener listener) {
        return false;
    }

    @Override
    public void addTextListener(InterfaceTextListener listener) {
    }

    @Override
    public boolean removeTextListener(InterfaceTextListener listener) {
        return false;
    }

    @Override
    public void printToTextListener(String ... s) {
        System.out.println(s);
    }

    @Override
    public void createNextGenerationPerformed(PopulationInterface pop, InterfaceOptimizer opt, List<InterfaceAdditionalPopulationInformer> informerList) {
        LinkedHashMap<String, Object> generation = new LinkedHashMap<String, Object>();
        generation.put("generation", this.currentGeneration);
        generation.put("bestFitness", pop.getBestFitness().clone());
        generation.put("meanFitness", pop.getMeanFitness().clone());
        generation.put("functionCalls", pop.getFunctionCalls());
        this.currentGenerations.add(generation);
        ++this.currentGeneration;
    }

    @Override
    public InterfaceStatisticsParameters getStatisticsParameters() {
        return this.statisticsParameters;
    }

    @Override
    public IndividualInterface getRunBestSolution() {
        return null;
    }

    @Override
    public IndividualInterface getBestSolution() {
        return null;
    }

    @Override
    public double[] getBestFitness() {
        return new double[0];
    }

    @Override
    public void postProcessingPerformed(Population resultPop) {
    }

    public List<LinkedHashMap<String, Object>> getRuns() {
        return this.runs;
    }
}

