/*
 * Decompiled with CFR 0.152.
 */
package eva2.cli;

import eva2.EvAInfo;
import eva2.cli.CommandLineStatistics;
import eva2.cli.OptimizationBuilder;
import eva2.cli.Parameter;
import eva2.cli.ParameterGenerator;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.Processor;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.StatisticsParameters;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.ReflectPackage;
import eva2.tools.StringTools;
import eva2.util.annotation.Description;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Main {
    public static void main(String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].equals("--help")) {
            Main.printHelp();
            System.exit(-1);
        } else if (args.length == 1 && args[0].equals("--version")) {
            Main.printVersion();
            System.exit(-1);
        } else if (args.length == 2 && args[0].equals("--help")) {
            String className = args[1];
            try {
                Class<?> clazz = Class.forName(className);
                Main.printHelpFor(clazz);
            }
            catch (ClassNotFoundException e) {
                System.out.printf("No help available for %s.\n", className);
            }
            System.exit(-1);
        } else {
            Main.executeArguments(args);
        }
    }

    private static void printVersion() {
        System.out.printf("EvA2 version \"%s\"\n", EvAInfo.getVersion());
    }

    private static void printHelp() {
        System.out.println("Usage: java -cp EvA2.jar eva2.cli.Main [args...]\n");
        Main.printHelpFor(OptimizationParameters.class);
        Main.printHelpFor(StatisticsParameters.class);
    }

    private static void printHelpFor(Class<?> clazz) {
        Class<?>[] subTypes;
        System.out.println(clazz.getName() + "\n");
        if (clazz.isAnnotationPresent(Description.class)) {
            Description description = clazz.getAnnotation(Description.class);
            System.out.printf("%s\n\n", description.value());
        }
        if ((clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) && (subTypes = ReflectPackage.getAssignableClassesInPackage(clazz.getPackage().getName(), clazz, true, true)).length > 0) {
            System.out.printf("Available types for %s\n\n", clazz.getName());
            for (Class<?> type : subTypes) {
                if (Modifier.isAbstract(type.getModifiers())) continue;
                Description description = clazz.getAnnotation(Description.class);
                System.out.printf("\t\u001b[1m%s\u001b[0m (%s)\n", type.getName(), StringTools.cutClassName(type.getName()));
                if (description != null) {
                    System.out.printf("\t\t%s", description.value());
                    continue;
                }
                System.out.println("\t\tNo description available.");
            }
            System.out.println();
        }
        ParameterGenerator generator = new ParameterGenerator(clazz, false);
        generator.generate();
        Map<String, List<Parameter>> paramList = generator.getParameterList();
        List<Parameter> parameters = paramList.get(clazz.getName());
        if (parameters.size() > 0) {
            System.out.println("Options:");
            for (Parameter key : parameters) {
                String typeDefinition;
                Class<?> type = key.getType();
                if (type.isEnum()) {
                    Enum[] enumConstants = (Enum[])type.getEnumConstants();
                    typeDefinition = "{";
                    for (int i = 0; i < enumConstants.length; ++i) {
                        typeDefinition = typeDefinition + enumConstants[i].name();
                        if (i == enumConstants.length - 1) continue;
                        typeDefinition = typeDefinition + ",";
                    }
                    typeDefinition = typeDefinition + "}";
                } else {
                    typeDefinition = key.getType().getName();
                }
                System.out.printf("\t\u001b[1m--%s\u001b[0m \u001b[4m%s\u001b[0m\n", key.getName(), typeDefinition);
                System.out.printf("\t\t%s\n", key.getDescription());
            }
        }
        System.out.print("\n\n");
    }

    private static void executeArguments(String[] args) {
        InterfaceOptimizationParameters parameters = OptimizationBuilder.parseOptimizerArguments(args);
        InterfaceStatisticsParameters statisticsParameters = OptimizationBuilder.parseStatisticsArguments(args);
        InterfaceTerminator terminator = parameters.getTerminator();
        InterfaceOptimizer optimizer = parameters.getOptimizer();
        InterfaceOptimizationProblem problem = parameters.getProblem();
        LinkedHashMap<String, Object> optimizationLog = new LinkedHashMap<String, Object>();
        optimizationLog.put("populationSize", parameters.getOptimizer().getPopulation().getTargetSize());
        optimizationLog.put("numberOfRuns", statisticsParameters.getMultiRuns());
        optimizationLog.put("seed", parameters.getRandomSeed());
        optimizationLog.put("problem", parameters.getProblem());
        CommandLineStatistics yamlStatistics = new CommandLineStatistics(statisticsParameters);
        Processor optimizationProcessor = new Processor(yamlStatistics, parameters);
        optimizationProcessor.setSaveParams(false);
        optimizationProcessor.startOptimization();
        optimizationProcessor.runOptimizationOnce();
        optimizationLog.put("runs", yamlStatistics.getRuns());
        DumperOptions options = new DumperOptions();
        options.setExplicitStart(true);
        options.setExplicitEnd(true);
        Yaml yaml = new Yaml();
        System.out.println(yaml.dump(optimizationLog));
    }
}

