/*
 * Decompiled with CFR 0.152.
 */
package eva2.cli;

import eva2.cli.ArgumentTree;
import eva2.gui.BeanInspector;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.optimization.statistics.StatisticsParameters;
import eva2.tools.ReflectPackage;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public final class OptimizationBuilder {
    private OptimizationBuilder() {
    }

    public static InterfaceOptimizationParameters parseOptimizerArguments(String[] args) {
        ArgumentTree argumentTree = OptimizationBuilder.parseArguments(args);
        return OptimizationBuilder.constructFromArgumentTree(OptimizationParameters.class, argumentTree);
    }

    public static InterfaceStatisticsParameters parseStatisticsArguments(String[] args) {
        ArgumentTree argumentTree = OptimizationBuilder.parseArguments(args);
        return OptimizationBuilder.constructFromArgumentTree(StatisticsParameters.class, argumentTree);
    }

    private static ArgumentTree parseArguments(String[] args) {
        HashMap<String, String> argumentMap = new HashMap<String, String>(args.length / 2);
        int i = 0;
        while (i < args.length) {
            if (!args[i].startsWith("--")) continue;
            String key = args[i].substring(2);
            if (i < args.length - 1 && !args[i + 1].startsWith("--")) {
                argumentMap.put(key, args[i + 1]);
                i += 2;
                continue;
            }
            argumentMap.put(key, null);
            ++i;
        }
        ArgumentTree argumentTree = new ArgumentTree();
        for (String key : argumentMap.keySet()) {
            OptimizationBuilder.insertIntoArgumentTree(argumentTree, key, (String)argumentMap.get(key));
        }
        return argumentTree;
    }

    private static void insertIntoArgumentTree(ArgumentTree tree, String key, String value) {
        if (!key.contains("-")) {
            if (!tree.containsKey(key)) {
                tree.put(key, new ArgumentTree());
            }
            ((ArgumentTree)tree.get(key)).setValue(value);
        } else {
            String baseKey = key.substring(0, key.indexOf(45));
            String restKey = key.substring(key.indexOf(45) + 1);
            if (!tree.containsKey(baseKey)) {
                tree.put(baseKey, new ArgumentTree());
            }
            OptimizationBuilder.insertIntoArgumentTree((ArgumentTree)tree.get(baseKey), restKey, value);
        }
    }

    private static <T> T constructFromArgumentTree(Class<T> clazz, ArgumentTree tree) {
        T instance = null;
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            Class[] params = new Class[]{};
            try {
                Constructor<T> constructor = clazz.getConstructor(params);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        if (tree.isEmpty()) {
            return instance;
        }
        try {
            BeanInfo info = clazz.isInterface() ? Introspector.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            int foundParameters = 0;
            for (PropertyDescriptor pd : properties) {
                Parameter param;
                String name = pd.getName();
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                Class<?> type = pd.getPropertyType();
                if (getter == null || setter == null || setter.isAnnotationPresent(Hidden.class)) continue;
                if (setter.isAnnotationPresent(Parameter.class) && !(param = setter.getAnnotation(Parameter.class)).name().isEmpty()) {
                    name = param.name();
                }
                if (tree.containsKey(name)) {
                    ++foundParameters;
                    Object obj = null;
                    if (type.isPrimitive() && ((ArgumentTree)tree.get(name)).getValue() != null) {
                        obj = BeanInspector.stringToPrimitive((String)((ArgumentTree)tree.get(name)).getValue(), type);
                    } else if (!type.isArray() || ((ArgumentTree)tree.get(name)).getValue() == null) {
                        if (type.isEnum() && ((ArgumentTree)tree.get(name)).getValue() != null) {
                            String enumName = (String)((ArgumentTree)tree.get(name)).getValue();
                            obj = Enum.valueOf(type, enumName);
                        } else {
                            String className = (String)((ArgumentTree)tree.get(name)).getValue();
                            Class<?> subType = className != null ? (className.endsWith("Problem") ? OptimizationBuilder.getClassFromName("eva2.problems", className, type) : OptimizationBuilder.getClassFromName("eva2.optimization", className, type)) : type;
                            obj = OptimizationBuilder.constructFromArgumentTree(subType, (ArgumentTree)tree.get(name));
                        }
                    }
                    if (obj != null) {
                        BeanInspector.callIfAvailable(instance, setter.getName(), new Object[]{obj});
                    }
                }
                if (tree.size() != foundParameters) {
                    continue;
                }
                break;
            }
        }
        catch (IntrospectionException ex) {
            ex.printStackTrace();
        }
        return instance;
    }

    private static Class<?> getClassFromName(String packageName, String name, Class type) {
        Class<?>[] classes;
        for (Class<?> clazz : classes = ReflectPackage.getAssignableClassesInPackage(packageName, type, true, true)) {
            if (!clazz.getName().equals(name) && !clazz.getSimpleName().equals(name)) continue;
            return clazz;
        }
        return null;
    }
}

