/*
 * Decompiled with CFR 0.152.
 */
package eva2.cli;

import eva2.cli.Parameter;
import eva2.optimization.OptimizationParameters;
import eva2.tools.ReflectPackage;
import eva2.util.annotation.Hidden;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterGenerator {
    private Class<?> clazz;
    private boolean recursive;
    private Map<String, List<Parameter>> parameterList;

    public ParameterGenerator(Class<?> clazz) {
        this(clazz, true);
    }

    public ParameterGenerator(Class<?> clazz, boolean recursive) {
        this.clazz = clazz;
        this.parameterList = new HashMap<String, List<Parameter>>();
        this.recursive = recursive;
    }

    public Map<String, List<Parameter>> getParameterList() {
        return this.parameterList;
    }

    public void generate() {
        this.generateForClass(this.clazz);
    }

    private void generateForClass(Class<?> clazz) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        this.parameterList.put(clazz.getName(), parameters);
        try {
            PropertyDescriptor[] properties;
            BeanInfo info = clazz.isInterface() ? Introspector.getBeanInfo(clazz) : Introspector.getBeanInfo(clazz, Object.class);
            for (PropertyDescriptor pd : properties = info.getPropertyDescriptors()) {
                Class<?>[] classes;
                Parameter parameter;
                String name = pd.getName();
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                Class<?> type = pd.getPropertyType();
                if (setter == null || setter.isAnnotationPresent(Hidden.class) || getter == null) continue;
                if (setter.isAnnotationPresent(eva2.util.annotation.Parameter.class)) {
                    eva2.util.annotation.Parameter param = setter.getAnnotation(eva2.util.annotation.Parameter.class);
                    if (!param.name().isEmpty()) {
                        name = param.name();
                    }
                    parameter = new Parameter(name, param.description(), type);
                } else {
                    parameter = new Parameter(name, "No description available.", type);
                }
                parameters.add(parameter);
                if (type == Object.class || !this.recursive) continue;
                for (Class<?> assignable : classes = ReflectPackage.getAssignableClassesInPackage("eva2", type, true, true)) {
                    if (this.parameterList.containsKey(assignable.getName()) || !assignable.getName().startsWith("eva2") || assignable.getName().startsWith("eva2.gui")) continue;
                    System.out.println(type.getName() + "\t->\t" + assignable.getName());
                    this.generateForClass(assignable);
                }
            }
        }
        catch (IntrospectionException ex) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        ParameterGenerator generator = new ParameterGenerator(OptimizationParameters.class);
        generator.generate();
        int paramCount = 0;
        Map<String, List<Parameter>> paramList = generator.getParameterList();
        for (String key : paramList.keySet()) {
            paramCount += paramList.get(key).size();
        }
        System.out.println("Total Parameter Count: " + paramCount);
        System.out.println("Total Type Count: " + paramList.size());
    }
}

