/*
 * Decompiled with CFR 0.152.
 */
package eva2.examples;

import eva2.OptimizerFactory;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.mutation.MutateESCovarianceMatrixAdaption;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.problems.FM0Problem;

public class TestingPlusCmaEs {
    public static void main(String[] args) {
        FM0Problem fm0 = new FM0Problem();
        OptimizationParameters esParams = OptimizerFactory.standardES(fm0);
        esParams.setTerminator(new EvaluationTerminator(2000));
        esParams.setRandomSeed(0L);
        AbstractEAIndividual.setOperators(fm0.getIndividualTemplate(), new MutateESCovarianceMatrixAdaption(true), 0.9, new CrossoverESDefault(), 0.1);
        EvolutionStrategies es = (EvolutionStrategies)esParams.getOptimizer();
        es.setMu(1);
        es.setLambda(5);
        es.setPlusStrategy(true);
        AbstractEAIndividual bestIndy = (AbstractEAIndividual)OptimizerFactory.optimizeToInd(esParams, null);
        System.out.println(esParams.getTerminator().lastTerminationMessage() + "\nFound solution: " + AbstractEAIndividual.getDefaultDataString(bestIndy));
    }
}

