/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.optimization.population.Population;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.tools.Pair;
import eva2.tools.SelectedTag;
import eva2.tools.StringTools;
import eva2.tools.Tag;
import eva2.util.annotation.Description;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanInspector {
    private static final Logger LOGGER = Logger.getLogger(BeanInspector.class.getName());

    public static boolean equalProperties(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            System.out.println("");
            return false;
        }
        System.out.println("equalProperties: " + obj1.getClass().getName() + " " + obj2.getClass().getName());
        if (!obj1.getClass().getName().equals(obj2.getClass().getName())) {
            System.out.println("");
            return false;
        }
        PropertyDescriptor[] Properties_1 = null;
        PropertyDescriptor[] Properties_2 = null;
        try {
            BeanInfo beanInfo1 = Introspector.getBeanInfo(obj1.getClass());
            BeanInfo beanInfo2 = Introspector.getBeanInfo(obj2.getClass());
            Properties_1 = beanInfo1.getPropertyDescriptors();
            Properties_2 = beanInfo2.getPropertyDescriptors();
            beanInfo1.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            LOGGER.log(Level.FINEST, "Could not introspect object.", ex);
            return false;
        }
        boolean BeansInside = false;
        boolean BeansEqual = true;
        for (int i = 0; i < Properties_1.length; ++i) {
            if (Properties_1[i].isHidden() || Properties_1[i].isExpert()) continue;
            Method getter_1 = Properties_1[i].getReadMethod();
            Method getter_2 = Properties_2[i].getReadMethod();
            Method setter_1 = Properties_1[i].getWriteMethod();
            if (getter_1 == null || setter_1 == null) continue;
            System.out.println("getter_1 = " + getter_1.getName() + " getter_2 = " + getter_2.getName());
            Object[] args_1 = new Object[]{};
            Object[] args_2 = new Object[]{};
            try {
                Object value_1 = getter_1.invoke(obj1, args_1);
                Object value_2 = getter_2.invoke(obj2, args_2);
                BeansInside = true;
                if (BeanInspector.equalProperties(value_1, value_2)) continue;
                BeansEqual = false;
                continue;
            }
            catch (Exception e) {
                System.out.println(" BeanTest.equalProperties " + e.getMessage());
            }
        }
        if (BeansInside) {
            return BeansEqual;
        }
        if (obj1 instanceof Integer || obj1 instanceof Boolean || obj1 instanceof Float || obj1 instanceof Double || obj1 instanceof Long || obj1 instanceof String) {
            return obj1.equals(obj2);
        }
        System.err.println(" Attention no match !!!");
        return true;
    }

    public static String toString(Object obj) {
        return BeanInspector.toString(obj, ';', false, "", 1, false);
    }

    public static String niceToString(Object obj) {
        return BeanInspector.toString(obj, ';', false, "    ", 1, true);
    }

    public static String toString(Object obj, char delim, boolean tight, String indentStr) {
        return BeanInspector.toString(obj, delim, tight, indentStr, 1, false);
    }

    private static String toString(Object obj, char delim, boolean tight, String indentStr, int indentDepth, boolean withNewlines) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("[");
            if (!tight) {
                sbuf.append(" ");
            }
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                if (withNewlines) {
                    sbuf.append('\n');
                }
                sbuf.append(BeanInspector.toString(Array.get(obj, i), delim, tight, indentStr, indentDepth, withNewlines));
                if (i >= len - 1 || tight) continue;
                sbuf.append(" ");
            }
            if (!tight) {
                sbuf.append(" ");
            }
            sbuf.append("]");
            return sbuf.toString();
        }
        if (type.isEnum()) {
            return BeanInspector.makeIndent(indentStr, indentDepth) + obj.toString();
        }
        if (obj instanceof List && !(obj instanceof Population)) {
            StringBuffer sbuf = new StringBuffer();
            if (withNewlines) {
                sbuf.append('\n');
            }
            BeanInspector.addIndent(sbuf, indentStr, indentDepth);
            sbuf.append("[");
            if (!tight) {
                sbuf.append(" ");
            }
            List lst = (List)obj;
            for (Object o : lst) {
                sbuf.append(o.toString());
                sbuf.append(delim);
                if (tight) continue;
                sbuf.append(" ");
            }
            if (!tight && sbuf.charAt(sbuf.length() - 2) == delim) {
                sbuf.setCharAt(sbuf.length() - 2, ' ');
            }
            sbuf.setCharAt(sbuf.length() - 1, ']');
            return sbuf.toString();
        }
        Method[] methods = obj.getClass().getDeclaredMethods();
        for (int ii = 0; ii < methods.length; ++ii) {
            if (!methods[ii].getName().equals("toString") || methods[ii].getParameterTypes().length != 0) continue;
            Object[] args = new Object[]{};
            try {
                String ret = (String)methods[ii].invoke(obj, args);
                return BeanInspector.makeIndent(indentStr, indentDepth) + ret;
            }
            catch (Exception e) {
                System.err.println(" ERROR +" + e.getMessage());
            }
        }
        Pair<String[], Object[]> nameVals = BeanInspector.getPublicPropertiesOf(obj, true, true);
        StringBuffer sbuf = new StringBuffer();
        if (withNewlines) {
            sbuf.append('\n');
        }
        BeanInspector.addIndent(sbuf, indentStr, indentDepth);
        sbuf.append(type.getName());
        sbuf.append("{");
        for (int i = 0; i < ((String[])nameVals.head).length; ++i) {
            if (((String[])nameVals.head)[i] == null) continue;
            if (withNewlines) {
                sbuf.append('\n');
            }
            BeanInspector.addIndent(sbuf, indentStr, indentDepth);
            sbuf.append(((String[])nameVals.head)[i]);
            sbuf.append("=");
            sbuf.append(BeanInspector.toString(((Object[])nameVals.tail)[i], delim, tight, indentStr, indentDepth + 1, withNewlines));
            sbuf.append(delim);
            if (tight) continue;
            sbuf.append(" ");
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    private static void addIndent(StringBuffer sbuf, String indentStr, int indentDepth) {
        if (indentStr != null && indentDepth > 0) {
            for (int i = 0; i < indentDepth; ++i) {
                sbuf.append(indentStr);
            }
        }
    }

    private static String makeIndent(String indentStr, int indentDepth) {
        if (indentStr != null) {
            if (indentDepth < 1) {
                return "";
            }
            StringBuilder sbuf = new StringBuilder(indentStr);
            for (int i = 2; i <= indentDepth; ++i) {
                sbuf.append(indentStr);
            }
            return sbuf.toString();
        }
        return "";
    }

    public static void main(String[] args) {
        System.out.println(BeanInspector.toString(new String[]{"asdf", "jdksfl", "werljk"}));
        System.out.println(BeanInspector.toString(new Population()));
        System.out.println(BeanInspector.toString(new GeneticAlgorithm()));
        System.out.println("----");
        System.out.println(BeanInspector.niceToString(new Population()));
        System.out.println(BeanInspector.niceToString(new GeneticAlgorithm()));
        System.out.println("----");
        System.out.println(BeanInspector.toString(new Population(), ';', false, ">", 1, false));
        System.out.println(BeanInspector.toString(new GeneticAlgorithm(), ';', false, ">", 1, false));
    }

    public static Pair<String[], Object[]> getPublicPropertiesOf(Object target, boolean requireSetter, boolean showHidden) {
        BeanInfo Info = null;
        PropertyDescriptor[] Properties2 = null;
        try {
            Info = Introspector.getBeanInfo(target.getClass());
            Properties2 = Info.getPropertyDescriptors();
            Info.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            System.err.println("BeanTest: Couldn't introspect");
            return null;
        }
        String[] nameArray = new String[Properties2.length];
        Object[] valArray = new Object[Properties2.length];
        for (int i = 0; i < Properties2.length; ++i) {
            if (Properties2[i].isHidden() && !showHidden || Properties2[i].isExpert()) continue;
            String name = Properties2[i].getDisplayName();
            Method getter = Properties2[i].getReadMethod();
            Method setter = Properties2[i].getWriteMethod();
            if (getter == null || setter == null && requireSetter) continue;
            Object[] args = new Object[]{};
            try {
                nameArray[i] = name;
                valArray[i] = getter.invoke(target, args);
                continue;
            }
            catch (Exception e) {
                System.err.println("BeanTest ERROR +" + e.getMessage());
            }
        }
        Pair<String[], Object[]> nameVals = new Pair<String[], Object[]>(nameArray, valArray);
        return nameVals;
    }

    public static void showInfo(Object obj) {
        System.out.println("Inspecting " + obj.getClass().getName());
        try {
            if (obj instanceof Integer) {
                System.out.println(" Prop = Integer" + obj.toString());
            }
            if (obj instanceof Boolean) {
                System.out.println(" Prop = Boolean" + obj.toString());
            }
            if (obj instanceof Long) {
                System.out.println(" Prop = Long" + obj.toString());
            }
            if (obj instanceof Double) {
                System.out.println(" Prop = Long" + obj.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        BeanInfo Info = null;
        PropertyDescriptor[] Properties2 = null;
        try {
            Info = Introspector.getBeanInfo(obj.getClass());
            Properties2 = Info.getPropertyDescriptors();
            Info.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            System.err.println("BeanTest: Couldn't introspect");
            return;
        }
        for (int i = 0; i < Properties2.length; ++i) {
            if (Properties2[i].isHidden() || Properties2[i].isExpert()) continue;
            String name = Properties2[i].getDisplayName();
            Method getter = Properties2[i].getReadMethod();
            Method setter = Properties2[i].getWriteMethod();
            if (getter == null || setter == null) continue;
            Object[] args = new Object[]{};
            try {
                Object value = getter.invoke(obj, args);
                System.out.println("Inspecting name = " + name);
                if (value instanceof Integer) {
                    Object[] args2 = new Object[]{999};
                    setter.invoke(obj, args2);
                }
                BeanInspector.showInfo(value);
                continue;
            }
            catch (Exception e) {
                System.out.println("BeanTest ERROR +" + e.getMessage());
            }
        }
    }

    public static Object callIfAvailable(Object obj, String mName, Object[] args) {
        Method meth = BeanInspector.hasMethod(obj, mName, BeanInspector.toClassArray(args));
        if (meth != null) {
            try {
                return meth.invoke(obj, args);
            }
            catch (Exception e) {
                System.err.println("Error on calling method " + mName + " on " + obj.getClass().getName());
                System.err.println("Object: " + obj.toString() + ", method name: " + mName);
                System.err.println("Arguments were " + BeanInspector.toString(args));
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static Class[] toClassArray(Object[] o) {
        if (o == null) {
            return null;
        }
        Class[] clz = new Class[o.length];
        for (int i = 0; i < o.length; ++i) {
            clz[i] = o[i].getClass();
        }
        return clz;
    }

    public static Method hasMethod(Object obj, String mName, Object[] args) {
        return BeanInspector.hasMethod(obj, mName, BeanInspector.toClassArray(args));
    }

    public static Method hasMethod(Object obj, String mName, Class[] paramTypes) {
        Method[] meths;
        Class<?> cls = obj.getClass();
        for (Method method : meths = cls.getMethods()) {
            if (!method.getName().equals(mName)) continue;
            Class<?>[] methParamTypes = method.getParameterTypes();
            if (paramTypes == null && methParamTypes.length == 0) {
                return method;
            }
            if (paramTypes == null || methParamTypes.length != paramTypes.length) continue;
            boolean mismatch = false;
            for (int i = 0; i < methParamTypes.length && !mismatch; ++i) {
                if (methParamTypes[i].isAssignableFrom(paramTypes[i]) || BeanInspector.isBoxableFrom(methParamTypes[i], paramTypes[i])) continue;
                mismatch = true;
            }
            if (mismatch) continue;
            return method;
        }
        return null;
    }

    private static boolean isBoxableFrom(Class clz1, Class clz2) {
        Class box = BeanInspector.getBoxedType(clz1);
        return box != null && clz2.isAssignableFrom(box);
    }

    public static Class getBoxedType(Class cls) {
        if (cls.isPrimitive()) {
            if (cls == Double.TYPE) {
                return Double.class;
            }
            if (cls == Character.TYPE) {
                return Character.class;
            }
            if (cls == Integer.TYPE) {
                return Integer.class;
            }
            if (cls == Boolean.TYPE) {
                return Boolean.class;
            }
            if (cls == Byte.TYPE) {
                return Byte.class;
            }
            if (cls == Short.TYPE) {
                return Short.class;
            }
            if (cls == Long.TYPE) {
                return Long.class;
            }
            if (cls == Float.TYPE) {
                return Float.class;
            }
            return Void.class;
        }
        return null;
    }

    public static Class getUnboxedType(Class cls) {
        if (cls == Double.class) {
            return Double.TYPE;
        }
        if (cls == Character.class) {
            return Character.TYPE;
        }
        if (cls == Integer.class) {
            return Integer.TYPE;
        }
        if (cls == Boolean.class) {
            return Boolean.TYPE;
        }
        if (cls == Byte.class) {
            return Byte.TYPE;
        }
        if (cls == Short.class) {
            return Short.TYPE;
        }
        if (cls == Long.class) {
            return Long.TYPE;
        }
        if (cls == Float.class) {
            return Float.TYPE;
        }
        if (cls == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    public static String getDescription(Object obj, boolean withValues) {
        String[] mems;
        StringBuilder sbuf = new StringBuilder(BeanInspector.getClassDescription(obj));
        sbuf.append("\n");
        for (String str : mems = BeanInspector.getMemberDescriptions(obj, withValues)) {
            sbuf.append(str);
        }
        return sbuf.toString();
    }

    public static String getClassDescription(Object obj) {
        StringBuilder infoBf = new StringBuilder("Type: ");
        infoBf.append(obj.getClass().getName());
        infoBf.append("\t");
        Object[] args = new Object[]{};
        Object ret = BeanInspector.callIfAvailable(obj, "getName", args);
        if (ret != null) {
            infoBf.append("\t");
            infoBf.append((String)ret);
        } else {
            Description description = obj.getClass().getAnnotation(Description.class);
            if (description != null) {
                infoBf.append("\t");
                infoBf.append(description.value());
            }
        }
        return infoBf.toString();
    }

    public static String[] getMemberDescriptions(Object obj, boolean withValues) {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(obj.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = bi.getPropertyDescriptors();
        ArrayList<String> memberInfoList = new ArrayList<String>();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            if (propertyDescriptors[i].isExpert()) continue;
            String name = propertyDescriptors[i].getDisplayName();
            Method getter = propertyDescriptors[i].getReadMethod();
            Method setter = propertyDescriptors[i].getWriteMethod();
            if (getter == null || setter == null) continue;
            try {
                Method tipTextMethod;
                Object[] args = new Object[]{};
                Object value = getter.invoke(obj, args);
                if (value == null) {
                    String getterClass = propertyDescriptors[i].getReadMethod().getDeclaringClass().getName();
                    if (getterClass.indexOf("java.") == 0) continue;
                    System.err.println("Warning: Property \"" + name + "\" has null initial value.  Skipping.");
                    continue;
                }
                StringBuilder memberInfoBf = new StringBuilder(40);
                memberInfoBf.append("Member:\t");
                memberInfoBf.append(name);
                memberInfoBf.append("\tType: ");
                if (propertyDescriptors[i].isHidden()) {
                    memberInfoBf.append("restricted, ");
                } else {
                    memberInfoBf.append("common, ");
                }
                String typeName = value.getClass().getName();
                if (value instanceof SelectedTag) {
                    Tag[] tags = ((SelectedTag)value).getTags();
                    memberInfoBf.append("String in {");
                    for (int k = 0; k < tags.length; ++k) {
                        memberInfoBf.append(tags[k].getString());
                        if (k + 1 >= tags.length) continue;
                        memberInfoBf.append(", ");
                    }
                    memberInfoBf.append("}");
                } else {
                    memberInfoBf.append(typeName);
                }
                if (withValues) {
                    memberInfoBf.append('\t');
                    memberInfoBf.append("Value: \t");
                    memberInfoBf.append(BeanInspector.toString(value));
                }
                if ((tipTextMethod = BeanInspector.hasMethod(obj, name + "TipText", null)) == null) {
                    memberInfoBf.append("\tNo further hint.");
                } else {
                    memberInfoBf.append("\tHint: ");
                    memberInfoBf.append(BeanInspector.toString(tipTextMethod.invoke(obj, args)));
                }
                memberInfoBf.append('\n');
                memberInfoList.add(memberInfoBf.toString());
                continue;
            }
            catch (Exception ex) {
                System.err.println("Skipping property " + name + " ; exception: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return memberInfoList.toArray(new String[1]);
    }

    public static double toDouble(Object val) throws IllegalArgumentException {
        if (val instanceof Integer) {
            return ((Integer)val).doubleValue();
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Byte) {
            return ((Byte)val).doubleValue();
        }
        if (val instanceof Short) {
            return ((Short)val).doubleValue();
        }
        if (val instanceof Long) {
            return ((Long)val).doubleValue();
        }
        if (val instanceof Float) {
            return ((Float)val).doubleValue();
        }
        if (val instanceof Void) {
            return 0.0;
        }
        throw new IllegalArgumentException("Illegal type, cant convert " + val.getClass() + " to double.");
    }

    public static Object stringToPrimitive(String str, Class<?> destType) throws NumberFormatException {
        if (destType == Integer.class || destType == Integer.TYPE) {
            return Integer.valueOf(str);
        }
        if (destType == Double.class || destType == Double.TYPE) {
            return Double.valueOf(str);
        }
        if (destType == Boolean.class || destType == Boolean.TYPE) {
            return Boolean.valueOf(str);
        }
        if (destType == Byte.class || destType == Byte.TYPE) {
            return Byte.valueOf(str);
        }
        if (destType == Short.class || destType == Short.TYPE) {
            return Short.valueOf(str);
        }
        if (destType == Long.class || destType == Long.TYPE) {
            return Long.valueOf(str);
        }
        if (destType == Float.class || destType == Float.TYPE) {
            return Float.valueOf(str);
        }
        if (destType == Character.class || destType == Character.TYPE) {
            return Character.valueOf(str.charAt(0));
        }
        System.err.println("warning, value interpreted as void type");
        return 0;
    }

    public static Object doubleToPrimitive(Double d, Class<?> destType) {
        if (destType == Double.class || destType == Double.TYPE) {
            return d;
        }
        if (destType == Integer.class || destType == Integer.TYPE) {
            return d.intValue();
        }
        if (destType == Boolean.class || destType == Boolean.TYPE) {
            return d != 0.0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (destType == Byte.class || destType == Byte.TYPE) {
            return d.byteValue();
        }
        if (destType == Short.class || destType == Short.TYPE) {
            return d.shortValue();
        }
        if (destType == Long.class || destType == Long.TYPE) {
            return d.longValue();
        }
        if (destType == Float.class || destType == Float.TYPE) {
            return Float.valueOf(d.floatValue());
        }
        System.err.println("warning: converting from double to character or void...");
        if (destType == Character.class || destType == Character.TYPE) {
            return Character.valueOf(d.toString().charAt(0));
        }
        return 0;
    }

    public static boolean isJavaPrimitive(Class<?> cls) {
        if (cls.isPrimitive()) {
            return true;
        }
        return cls == Double.class || cls == Integer.class || cls == Boolean.class || cls == Character.class || cls == Void.class || cls == Byte.class || cls == Short.class || cls == Long.class || cls == Float.class;
    }

    public static Class getJavaPrimitive(Class<?> cls) {
        if (cls.isPrimitive()) {
            return cls;
        }
        if (cls == Double.class) {
            return Double.TYPE;
        }
        if (cls == Integer.class) {
            return Integer.TYPE;
        }
        if (cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == Byte.class) {
            return Byte.TYPE;
        }
        if (cls == Short.class) {
            return Short.TYPE;
        }
        if (cls == Long.class) {
            return Long.TYPE;
        }
        if (cls == Float.class) {
            return Float.TYPE;
        }
        return null;
    }

    public static Object decodeType(Class<?> destType, Object value) {
        if (destType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (destType == String.class || destType == SelectedTag.class) {
            if (value.getClass() == String.class) {
                return value;
            }
            return value.toString();
        }
        if (BeanInspector.isJavaPrimitive(destType)) {
            try {
                if (value.getClass() == String.class) {
                    return BeanInspector.stringToPrimitive((String)value, destType);
                }
                return BeanInspector.doubleToPrimitive(BeanInspector.toDouble(value), destType);
            }
            catch (Exception e) {
                System.err.println("Error in converting type of " + value + " to " + destType.getName() + ": " + e.getMessage());
                return null;
            }
        }
        System.err.println("Error: unknown type, skipping decode " + value.getClass().getName() + " to " + destType.getName());
        return value;
    }

    public static Object getMem(Object obj, String mem) {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(obj.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return false;
        }
        PropertyDescriptor[] properties = bi.getPropertyDescriptors();
        Method getter = null;
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getDisplayName().equals(mem)) continue;
            getter = properties[i].getReadMethod();
            break;
        }
        if (getter != null) {
            try {
                return getter.invoke(obj, (Object[])null);
            }
            catch (Exception e) {
                System.err.println("Exception in invoking setter: " + e.getMessage());
                return null;
            }
        }
        System.err.println("Getter method for " + mem + " not found!");
        return null;
    }

    public static boolean setMem(Object obj, String mem, Object val) {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(obj.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return false;
        }
        PropertyDescriptor[] properties = bi.getPropertyDescriptors();
        Method setter = null;
        Class<?> type = null;
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].getDisplayName().equals(mem)) continue;
            setter = properties[i].getWriteMethod();
            type = properties[i].getPropertyType();
            break;
        }
        if (setter != null) {
            try {
                Object[] args = new Object[]{BeanInspector.decodeType(type, val)};
                if (args[0] != null) {
                    setter.invoke(obj, args);
                    return true;
                }
                System.err.println("no value to set");
                return false;
            }
            catch (Exception e) {
                System.err.println("Exception in invoking setter: " + e.getMessage());
                return false;
            }
        }
        System.err.println("Setter method for " + mem + " not found!");
        return false;
    }

    public static String getToolTipText(String name, MethodDescriptor[] methods, Object target, boolean stripToolTipToFirstPoint, int toHTMLLen) {
        String result = "";
        String tipName = name + "TipText";
        for (MethodDescriptor method : methods) {
            String mname = method.getDisplayName();
            Method meth = method.getMethod();
            if (!mname.equals(tipName) || !meth.getReturnType().equals(String.class)) continue;
            try {
                int ci;
                String tempTip;
                Object[] args = new Object[]{};
                result = tempTip = (String)meth.invoke(target, args);
                if (!stripToolTipToFirstPoint || (ci = tempTip.indexOf(46)) <= 0) break;
                result = tempTip.substring(0, ci);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Error calling TipText method.", ex);
            }
            break;
        }
        if (result.isEmpty()) {
            LOGGER.fine(String.format("No ToolTip for %s.%s available.", target.getClass().getName(), name));
        }
        if (toHTMLLen > 0) {
            return StringTools.toHTML(result, toHTMLLen);
        }
        return result;
    }

    public static String getToolTipText(String name, MethodDescriptor[] methods, Object target) {
        return BeanInspector.getToolTipText(name, methods, target, false, 0);
    }
}

