/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import com.sun.management.OperatingSystemMXBean;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.Timer;

public class CPUPanel
extends JPanel {
    private LinkedList<Double> processLoadList = new LinkedList();
    private LinkedList<Double> osLoadList = new LinkedList();
    private int maxTimeSteps = 100;
    private OperatingSystemMXBean osBean;

    public CPUPanel(int timeSteps) {
        Timer timer = new Timer(500, e -> {
            this.updateLoad();
            this.repaint();
        });
        timer.start();
        this.maxTimeSteps = timeSteps;
        this.setMinimumSize(new Dimension(timeSteps, 1));
        this.setPreferredSize(new Dimension(timeSteps, 1));
        this.osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    }

    private void updateLoad() {
        this.processLoadList.add(this.osBean.getProcessCpuLoad());
        this.osLoadList.add(this.osBean.getSystemCpuLoad());
        if (this.processLoadList.size() > this.maxTimeSteps) {
            this.processLoadList.removeFirst();
        }
        if (this.osLoadList.size() > this.maxTimeSteps) {
            this.osLoadList.removeFirst();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension panelSize = this.getSize();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(Color.LIGHT_GRAY);
        int pos = this.maxTimeSteps - this.osLoadList.size();
        for (Double load : this.osLoadList) {
            g2d.drawLine(pos, panelSize.height - 1, pos, (int)((double)(panelSize.height - 1) - (double)panelSize.height * load));
            ++pos;
        }
        g2d.setColor(Color.GREEN);
        pos = this.maxTimeSteps - this.processLoadList.size();
        for (Double load : this.processLoadList) {
            g2d.drawLine(pos, panelSize.height - 1, pos, (int)((double)(panelSize.height - 1) - (double)panelSize.height * load));
            ++pos;
        }
    }
}

