/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.utils.VerticalButtonUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicButtonUI;

class ClosableTabComponent
extends JPanel {
    private final JTabbedPane pane;
    private final JToolBar toolBar;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ClosableTabComponent(final JTabbedPane pane, JToolBar toolBar) {
        super(new FlowLayout(3, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.toolBar = toolBar;
        this.toolBar.setVisible(false);
        this.setOpaque(false);
        JLabel label = new JLabel(){

            @Override
            public String getText() {
                int index = pane.indexOfTabComponent(ClosableTabComponent.this);
                if (index != -1) {
                    return pane.getTitleAt(index);
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Hide this Tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ClosableTabComponent.this.pane.indexOfTabComponent(ClosableTabComponent.this);
            if (i != -1) {
                final String tabTitle = ClosableTabComponent.this.pane.getTitleAt(i);
                final Component tabPane = ClosableTabComponent.this.pane.getComponentAt(i);
                final int tabPosition = i;
                ClosableTabComponent.this.pane.remove(i);
                if (ClosableTabComponent.this.pane.getTabCount() == 0) {
                    ClosableTabComponent.this.pane.setVisible(false);
                }
                JButton tabButton = new JButton(tabTitle);
                tabButton.setUI(new VerticalButtonUI(-90));
                tabButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClosableTabComponent.this.pane.insertTab(tabTitle, null, tabPane, "", tabPosition);
                        ClosableTabComponent.this.pane.setTabComponentAt(tabPosition, ClosableTabComponent.this);
                        ClosableTabComponent.this.pane.setVisible(true);
                        ClosableTabComponent.this.toolBar.remove((Component)e.getSource());
                        if (ClosableTabComponent.this.toolBar.getComponentCount() == 0) {
                            ClosableTabComponent.this.toolBar.setVisible(false);
                        }
                    }
                });
                if (!ClosableTabComponent.this.toolBar.isVisible()) {
                    ClosableTabComponent.this.toolBar.setVisible(true);
                }
                ClosableTabComponent.this.toolBar.add(tabButton);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

