/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.JExtDesktopPane;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultDesktopManager;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ExtDesktopManager
extends DefaultDesktopManager {
    private static final Logger LOGGER = Logger.getLogger(ExtDesktopManager.class.getName());
    int WINDOW_LIST_START;
    public static final String INDEX = "Index";
    public static final String FRAME = "Frame";
    private JInternalFrame activeFrame = null;
    private JExtDesktopPane desktop;

    public ExtDesktopManager(JExtDesktopPane desktop) {
        this.desktop = desktop;
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        this.activeFrame = f;
    }

    @Override
    public void deactivateFrame(JInternalFrame f) {
        super.deactivateFrame(f);
        if (this.activeFrame == f) {
            this.activeFrame = null;
        }
    }

    public JInternalFrame getActiveFrame() {
        return this.activeFrame;
    }

    @Override
    public void closeFrame(JInternalFrame internalFrame) {
        int i;
        LOGGER.log(Level.FINE, "Closing Internal Frame: {0}", internalFrame.getTitle());
        super.closeFrame(internalFrame);
        int index = (Integer)internalFrame.getClientProperty(INDEX) + this.WINDOW_LIST_START - 1;
        this.desktop.getWindowMenu().remove(index);
        for (i = index; i < Math.min(this.WINDOW_LIST_START + 9, this.desktop.getWindowMenu().getItemCount()); ++i) {
            JMenuItem m = this.desktop.getWindowMenu().getItem(i);
            JInternalFrame frame = (JInternalFrame)m.getClientProperty(FRAME);
            frame.putClientProperty(INDEX, (Integer)frame.getClientProperty(INDEX) - 1);
            int winIndex = i - this.WINDOW_LIST_START + 1;
            m.setText(winIndex + " " + frame.getTitle());
            m.setMnemonic((char)(48 + winIndex));
            m.setAccelerator(KeyStroke.getKeyStroke(48 + winIndex, 8));
        }
        if (internalFrame.isSelected()) {
            Component tmp = null;
            boolean found = false;
            for (i = 0; i < this.desktop.getComponentCount() && !found; ++i) {
                tmp = this.desktop.getComponent(i);
                if (!(tmp instanceof JInternalFrame)) continue;
                found = true;
            }
            if (found) {
                this.desktop.selectFrame((JInternalFrame)tmp);
            } else {
                this.activeFrame = null;
            }
        }
    }
}

