/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.tools.BasicResourceLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class HtmlDemo {
    private JEditorPane htmlEditorPane;
    private String name;

    public HtmlDemo(String name) {
        this.name = name;
    }

    public JEditorPane getPane() {
        return this.htmlEditorPane;
    }

    public static void main(String[] args) {
        HtmlDemo demo = new HtmlDemo("ES.html");
        demo.show();
    }

    public boolean resourceExists() {
        URL url = ClassLoader.getSystemResource("html/" + this.name);
        return url != null;
    }

    public static boolean resourceExists(String mname) {
        URL url = ClassLoader.getSystemResource("html/" + mname);
        return url != null;
    }

    public void show() {
        try {
            URL url = ClassLoader.getSystemResource("html/" + this.name);
            try {
                this.htmlEditorPane = new JEditorPane(url);
            }
            catch (IOException ioe) {
                url = ClassLoader.getSystemResource("html/Default.html");
                this.htmlEditorPane = new JEditorPane(url);
            }
            this.htmlEditorPane.setEditable(false);
            this.htmlEditorPane.addHyperlinkListener(this.createHyperLinkListener());
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
            return;
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
            e.printStackTrace();
            return;
        }
        JFrame frame = new JFrame(this.name);
        BasicResourceLoader loader = BasicResourceLoader.getInstance();
        byte[] bytes = loader.getBytesFromResourceLocation("images/icon.png", true);
        frame.setIconImage(Toolkit.getDefaultToolkit().createImage(bytes));
        JScrollPane scroller = new JScrollPane();
        JViewport vp = scroller.getViewport();
        vp.add(this.htmlEditorPane);
        scroller.setPreferredSize(new Dimension(600, 500));
        frame.getContentPane().add((Component)scroller, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    public HyperlinkListener createHyperLinkListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e instanceof HTMLFrameHyperlinkEvent) {
                        ((HTMLDocument)HtmlDemo.this.htmlEditorPane.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                    } else {
                        try {
                            HtmlDemo.this.htmlEditorPane.setPage(e.getURL());
                        }
                        catch (IOException ioe) {
                            System.out.println("IOE: " + ioe);
                        }
                    }
                }
            }
        };
    }
}

