/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.JEFrame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDesktopPane;

public final class JEFrameRegister {
    private static JEFrameRegister instance = null;
    private List<JEFrame> frameList = new ArrayList<JEFrame>();
    private JDesktopPane desktopPane;

    private JEFrameRegister() {
    }

    public static JEFrameRegister getInstance() {
        if (instance == null) {
            instance = new JEFrameRegister();
        }
        return instance;
    }

    public void setDesktopPane(JDesktopPane desktopPane) {
        this.desktopPane = desktopPane;
        if (!this.frameList.isEmpty()) {
            for (JEFrame frame : this.frameList) {
                this.desktopPane.add(frame);
            }
        }
    }

    public void register(JEFrame jeFrame) {
        if (!this.frameList.contains(jeFrame)) {
            this.frameList.add(jeFrame);
            if (this.desktopPane != null) {
                this.desktopPane.add(jeFrame);
            }
        }
    }

    public void unregister(JEFrame jeFrame) {
        this.frameList.remove(jeFrame);
    }

    public List<JEFrame> getFrameList() {
        return this.frameList;
    }

    public void setFocusToNext(JEFrame jeFrame) {
        int idx = this.frameList.indexOf(jeFrame);
        idx = (idx + 1) % this.frameList.size();
        JEFrame toset = this.frameList.get(idx);
        toset.toFront();
    }

    public String[] getCommonPrefixes(int prefLen) {
        int i;
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<Integer> count = new ArrayList<Integer>();
        for (i = 0; i < this.frameList.size(); ++i) {
            String title = this.frameList.get(i).getTitle();
            String titPref = title.substring(0, Math.min(prefLen, title.length()));
            int earlierIndex = prefixes.indexOf(titPref);
            if (earlierIndex < 0) {
                prefixes.add(titPref);
                count.add(1);
                continue;
            }
            count.set(earlierIndex, 1 + (Integer)count.get(earlierIndex));
        }
        for (i = prefixes.size() - 1; i >= 0; --i) {
            if ((Integer)count.get(i) > 1) continue;
            prefixes.remove(i);
            count.remove(i);
        }
        return prefixes.toArray(new String[prefixes.size()]);
    }

    public void closeAllByPrefix(String prefix) {
        for (int i = 0; i < this.frameList.size(); ++i) {
            String title = this.frameList.get(i).getTitle();
            if (!title.startsWith(prefix)) continue;
            this.frameList.get(i).dispose();
        }
    }

    public void closeAll() {
        for (int i = 0; i < this.frameList.size(); ++i) {
            this.frameList.get(i).dispose();
        }
    }
}

