/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.ExtAction;
import eva2.gui.ExtDesktopManager;
import eva2.gui.JExtMenu;
import eva2.gui.editor.ComponentFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class JExtDesktopPane
extends JDesktopPane {
    private ActionListener actMenuFrame;
    private ExtDesktopManager desktopManager;
    private JExtMenu windowMenu;
    private ExtAction actWindowTileVert;
    private ExtAction actWindowTileHorz;
    private ExtAction actWindowOverlap;
    public static final int WINDOW_TILEVERT = 0;
    public static final int WINDOW_TILEHORZ = 1;
    public static final int WINDOW_OVERLAP = 2;
    public static final int WINDOW_ARRANGEICONS = 3;
    public static final int WINDOW_LIST = 4;
    public static final int TITLEBAR_HEIGHT = 25;

    public JExtDesktopPane() {
        this.setDragMode(1);
        this.windowMenu = new JExtMenu("&Windows");
        this.desktopManager = new ExtDesktopManager(this);
        this.setDesktopManager(this.desktopManager);
        this.actMenuFrame = event -> {
            if (!(event.getSource() instanceof JMenuItem)) {
                return;
            }
            JInternalFrame frame = (JInternalFrame)((JMenuItem)event.getSource()).getClientProperty("Frame");
            this.selectFrame(frame);
        };
        this.actWindowTileVert = new ExtAction("Tile &Vertically", "Tiles all windows vertically", KeyStroke.getKeyStroke(44, 2)){

            @Override
            public void actionPerformed(ActionEvent event) {
                JExtDesktopPane.this.tileWindows(0);
            }
        };
        this.windowMenu.add(this.actWindowTileVert);
        this.actWindowTileHorz = new ExtAction("Tile &Horizontally", "Tiles all windows horizontically", KeyStroke.getKeyStroke(46, 2)){

            @Override
            public void actionPerformed(ActionEvent event) {
                JExtDesktopPane.this.tileWindows(1);
            }
        };
        this.windowMenu.add(this.actWindowTileHorz);
        this.actWindowOverlap = new ExtAction("&Cascade Windows", "Cascades all visible windows", KeyStroke.getKeyStroke(77, 2)){

            @Override
            public void actionPerformed(ActionEvent event) {
                JExtDesktopPane.this.overlapWindows();
            }
        };
        this.windowMenu.add(this.actWindowOverlap);
        this.windowMenu.addSeparator();
        this.desktopManager.WINDOW_LIST_START = 4;
    }

    public ExtAction getWindowAction(int action) {
        switch (action) {
            case 0: {
                return this.actWindowTileVert;
            }
            case 1: {
                return this.actWindowTileHorz;
            }
            case 2: {
                return this.actWindowOverlap;
            }
        }
        return null;
    }

    public void overlapWindows() {
        int minWidth = 150;
        int minHeight = 100;
        JInternalFrame[] frames = this.getOpenFrames();
        if (frames.length == 0) {
            return;
        }
        int oCount = Math.min(frames.length, Math.min((this.getWidth() - 150) / 25 + 1, (this.getHeight() - 100) / 25 + 1));
        int fWidth = this.getWidth() - (oCount - 1) * 25;
        int fHeight = this.getHeight() - (oCount - 1) * 25;
        int indent = 0;
        for (int i = 0; i < frames.length; ++i) {
            frames[frames.length - i - 1].setLocation(indent * 25, indent * 25);
            frames[frames.length - i - 1].setSize(fWidth, fHeight);
            indent = (i + 1) % oCount == 0 ? 0 : indent + 1;
        }
    }

    public void tileWindows(int orientation) {
        block8: {
            JInternalFrame[] frames;
            block7: {
                frames = this.getOpenFrames();
                if (frames.length == 0) {
                    return;
                }
                if (orientation != 0) break block7;
                int rows = (int)Math.rint(Math.sqrt(frames.length) - 0.49);
                int cols = frames.length / rows;
                int rHeight = this.getHeight() / rows;
                int cWidth = this.getWidth() / cols;
                int col = 0;
                int row = 0;
                for (int i = 0; i < frames.length; ++i) {
                    frames[i].setLocation(col * cWidth, row * rHeight);
                    frames[i].setSize(cWidth, rHeight);
                    if (col == cols - 1) {
                        ++row;
                        col = 0;
                    } else {
                        ++col;
                    }
                    if (row <= 0 || frames.length - i - (cols + 1) * (rows - row) <= 0) continue;
                    cWidth = this.getWidth() / ++cols;
                }
                break block8;
            }
            if (orientation != 1) break block8;
            int cols = (int)Math.rint(Math.sqrt(frames.length) - 0.49);
            int rows = frames.length / cols;
            int cWidth = this.getWidth() / cols;
            int rHeight = this.getHeight() / rows;
            int row = 0;
            int col = 0;
            for (int i = 0; i < frames.length; ++i) {
                frames[i].setLocation(col * cWidth, row * rHeight);
                frames[i].setSize(cWidth, rHeight);
                if (row == rows - 1) {
                    ++col;
                    row = 0;
                } else {
                    ++row;
                }
                if (col <= 0 || frames.length - i - (rows + 1) * (cols - col) <= 0) continue;
                rHeight = this.getHeight() / ++rows;
            }
        }
    }

    public JInternalFrame[] getOpenFrames() {
        Vector<Component> vResults = new Vector<Component>(10);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component tmp = this.getComponent(i);
            if (!(tmp instanceof JInternalFrame)) continue;
            vResults.addElement(tmp);
        }
        Object[] result = new JInternalFrame[vResults.size()];
        vResults.copyInto(result);
        return result;
    }

    public int getFrameCount() {
        return this.getComponentCount(c -> c instanceof JInternalFrame || c instanceof JInternalFrame.JDesktopIcon && ((JInternalFrame.JDesktopIcon)c).getInternalFrame() != null);
    }

    public int getComponentCount(ComponentFilter c) {
        int result = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!c.accept(this.getComponent(i))) continue;
            ++result;
        }
        return result;
    }

    public void selectFrame(JInternalFrame f) {
        if (f != null) {
            try {
                if (f.isIcon()) {
                    f.setIcon(false);
                } else {
                    f.setSelected(true);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof JInternalFrame) {
            JInternalFrame docFrame = (JInternalFrame)comp;
            int frameIndex = this.windowMenu.getItemCount() - this.desktopManager.WINDOW_LIST_START + 1;
            if (docFrame.getClientProperty("Index") != null) {
                return;
            }
            docFrame.putClientProperty("Index", frameIndex);
            JMenuItem m = new JMenuItem((frameIndex < 10 ? frameIndex + " " : "") + docFrame.getTitle());
            if (frameIndex < 10) {
                m.setMnemonic((char)(48 + frameIndex));
                m.setAccelerator(KeyStroke.getKeyStroke(48 + frameIndex, 8));
            }
            m.setToolTipText("Shows the window " + docFrame.getTitle());
            m.putClientProperty("Frame", docFrame);
            m.addActionListener(this.actMenuFrame);
            this.windowMenu.add(m);
        }
    }

    public JMenu getWindowMenu() {
        return this.windowMenu;
    }
}

