/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.ExtActionChangedListener;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class JExtToolBar
extends JToolBar {
    @Override
    public JButton add(Action a) {
        JButton button = super.add(a);
        button.setText(null);
        button.setMargin(new Insets(0, 0, 0, 0));
        Object o = a.getValue("ToolTip");
        String toolTip = o != null ? (String)o : "";
        o = a.getValue("KeyStroke");
        button.setToolTipText(toolTip + this.getKeyText((KeyStroke)o));
        return button;
    }

    private String getKeyText(KeyStroke k) {
        StringBuilder result = new StringBuilder();
        if (k != null) {
            int modifiers = k.getModifiers();
            if (modifiers > 0) {
                result.append(KeyEvent.getKeyModifiersText(modifiers)).append("+");
            }
            result.append(KeyEvent.getKeyText(k.getKeyCode()));
        }
        if (result.length() > 0) {
            result.insert(0, " [");
            result.append("]");
        }
        return result.toString();
    }

    @Override
    protected PropertyChangeListener createActionChangeListener(JButton b) {
        return new ExtActionChangedListener(b){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JButton button = (JButton)this.component;
                String propertyName = e.getPropertyName();
                if (!propertyName.equals("Name")) {
                    if (propertyName.equals("enabled")) {
                        button.setEnabled((Boolean)e.getNewValue());
                        button.repaint();
                    } else if (e.getPropertyName().equals("SmallIcon")) {
                        button.setIcon((Icon)e.getNewValue());
                        button.invalidate();
                        button.repaint();
                    } else if (propertyName.equals("ToolTip") || propertyName.equals("KeyStroke")) {
                        Action source = (Action)e.getSource();
                        Object o = source.getValue("ToolTip");
                        String toolTip = o != null ? (String)o : "";
                        o = source.getValue("KeyStroke");
                        button.setToolTipText(toolTip + JExtToolBar.this.getKeyText((KeyStroke)o));
                    }
                }
            }
        };
    }
}

