/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.JEFrame;
import eva2.gui.JTextoutputFrameInterface;
import eva2.gui.LineBufferDocumentFilter;
import eva2.gui.PopupListener;
import eva2.optimization.tools.FileTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;

public class JTextoutputFrame
implements JTextoutputFrameInterface,
ActionListener,
Serializable {
    private JMenuItem clearItem;
    private JMenuItem saveItem;
    protected String frameTitle = "undefined";
    private transient JTextArea textArea = null;
    private final JInternalFrame frame;
    private JPopupMenu popup;

    public JTextoutputFrame(String title) {
        this.frameTitle = title;
        this.frame = new JEFrame(this.frameTitle);
        this.frame.setClosable(false);
        this.textArea = null;
    }

    @Override
    public void print(String text) {
        if (this.textArea == null) {
            this.createFrame();
        }
        this.textArea.append(text);
        this.textArea.repaint();
    }

    @Override
    public void println(String txt) {
        this.print(txt + '\n');
    }

    @Override
    public void setShow(boolean bShow) {
        if (this.frame.isVisible() != bShow) {
            if (this.frame.isVisible()) {
                this.frame.dispose();
                this.textArea.setText(null);
            } else {
                if (this.textArea == null) {
                    this.createFrame();
                } else {
                    this.frame.setVisible(true);
                }
                this.frame.setEnabled(true);
            }
        }
    }

    private void createFrame() {
        this.textArea = new JTextArea(10, 80);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        this.textArea.setCaretPosition(0);
        this.textArea.setTabSize(16);
        this.textArea.setFont(new Font("Courier New", 0, 12));
        ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new LineBufferDocumentFilter(this.textArea, 2500));
        this.frame.getContentPane().setLayout(new BorderLayout());
        JScrollPane scrollpane = new JScrollPane(this.textArea);
        this.frame.getContentPane().add((Component)scrollpane, "Center");
        scrollpane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = (JViewport)e.getSource();
                int height = viewport.getViewSize().height;
                if (height != this.lastHeight) {
                    this.lastHeight = height;
                    int x = height - viewport.getExtentSize().height;
                    viewport.setViewPosition(new Point(0, x));
                }
            }
        });
        this.makePopupMenu();
        this.frame.pack();
        this.frame.setSize(800, 400);
        this.frame.setVisible(true);
    }

    void makePopupMenu() {
        this.popup = new JPopupMenu();
        this.clearItem = new JMenuItem("Clear");
        this.clearItem.addActionListener(this);
        this.popup.add(this.clearItem);
        this.saveItem = new JMenuItem("Save as...");
        this.saveItem.addActionListener(this);
        this.popup.add(this.saveItem);
        PopupListener popupListener = new PopupListener(this.popup);
        this.textArea.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem src = (JMenuItem)e.getSource();
        if (src == this.clearItem) {
            this.textArea.setText(null);
        } else if (src == this.saveItem) {
            FileTools.saveObjectWithFileChooser(this.frame, this.textArea.getText(), null);
        } else {
            System.err.println("Unknown popup component (JTextoutputFrame)!");
        }
    }
}

