/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

class LineBufferDocumentFilter
extends DocumentFilter {
    private JTextArea area;
    private int max;

    public LineBufferDocumentFilter(JTextArea area, int max) {
        this.area = area;
        this.max = max;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, offset, text, attr);
        int lines = this.area.getLineCount();
        if (lines > this.max) {
            int linesToRemove = lines - this.max - 1;
            int lengthToRemove = this.area.getLineStartOffset(linesToRemove);
            this.remove(fb, 0, lengthToRemove);
        }
    }
}

