/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class LoggingLevelLabel
extends JLabel {
    private JPopupMenu menu;
    private String[] options = new String[]{"Info", "Warning", "Severe", "Fine", "Finer", "Finest", "All"};
    private static final Logger LOGGER = Logger.getLogger(LoggingLevelLabel.class.getName());

    public LoggingLevelLabel() {
        this.setToolTipText("Click to change current logging level");
        this.createPopupMenu();
        this.updateText();
    }

    private void createPopupMenu() {
        this.menu = new JPopupMenu();
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                LoggingLevelLabel.this.menu.show(ev.getComponent(), ev.getX(), ev.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        MenuActionListener menuAction = new MenuActionListener();
        for (String option : this.options) {
            JMenuItem menuItem = new JMenuItem(option);
            menuItem.addActionListener(menuAction);
            this.menu.add(menuItem);
        }
    }

    private void updateText() {
        Level lvl = LOGGER.getLevel();
        if (lvl == null) {
            lvl = LOGGER.getParent().getLevel();
        }
        this.setText("<html><b>Level</b>: " + lvl.getName());
    }

    private void setLoggerLevel(Level level) {
        Logger.getLogger("eva2").setLevel(level);
        LOGGER.log(Level.INFO, "Logging Level changed to {0}", level.getName());
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JMenuItem menuItem = (JMenuItem)ev.getSource();
            String levelName = menuItem.getText();
            try {
                Level level = Level.parse(levelName.toUpperCase());
                LoggingLevelLabel.this.setLoggerLevel(level);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.INFO, "Could not determine new logging level!", ex);
            }
            LoggingLevelLabel.this.updateText();
        }
    }
}

