/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.LoggingHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LoggingPanel
extends JPanel {
    protected static Logger LOGGER = Logger.getLogger(LoggingPanel.class.getName());
    protected JTextArea loggingTextArea = new JTextArea(10, 20);
    protected Handler loggingHandler;

    public LoggingPanel() {
        this.loggingTextArea.setEditable(false);
        this.loggingTextArea.setLineWrap(true);
        this.loggingTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Info"), "First");
        this.loggingHandler = new LoggingHandler(this);
        Logger rootLogger = Logger.getLogger("eva2");
        rootLogger.addHandler(this.loggingHandler);
        JScrollPane scrollpane = new JScrollPane(this.loggingTextArea);
        scrollpane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.add((Component)scrollpane, "Center");
        scrollpane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = (JViewport)e.getSource();
                int height = viewport.getViewSize().height;
                if (height != this.lastHeight) {
                    this.lastHeight = height;
                    int x = height - viewport.getExtentSize().height;
                    viewport.setViewPosition(new Point(0, x));
                }
            }
        });
    }

    protected static String getTimestamp() {
        return new SimpleDateFormat("HH:mm:ss:").format(new Date());
    }

    public void logMessage(String message) {
        this.loggingTextArea.append(LoggingPanel.getTimestamp() + ' ' + message);
        this.loggingTextArea.append("\n");
    }
}

