/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.InterfaceStandaloneOptimization;
import eva2.gui.PropertyDoubleArray;
import eva2.gui.SwingWorker;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.mocco.MOCCOChooseMOStrategy;
import eva2.optimization.mocco.MOCCOChooseReferencePoint;
import eva2.optimization.mocco.MOCCOChooseReferenceSolution;
import eva2.optimization.mocco.MOCCOInitialPopulationSize;
import eva2.optimization.mocco.MOCCOParameterizeGDF;
import eva2.optimization.mocco.MOCCOParameterizeMO;
import eva2.optimization.mocco.MOCCOParameterizeRefPoint;
import eva2.optimization.mocco.MOCCOParameterizeSO;
import eva2.optimization.mocco.MOCCOParameterizeSTEP;
import eva2.optimization.mocco.MOCCOParameterizeTchebycheff;
import eva2.optimization.mocco.MOCCOPhase;
import eva2.optimization.mocco.MOCCOProblemInitialization;
import eva2.optimization.mocco.MOCCOProblemRedefinition;
import eva2.optimization.mocco.MOCCOState;
import eva2.optimization.mocco.paretofrontviewer.MOCCOViewer;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.operator.moso.MOSOWeightedFitness;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.optimization.strategies.IslandModelEA;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceMultiObjectiveDeNovoProblem;
import eva2.problems.InterfaceOptimizationObjective;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.problems.TF1Problem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class MOCCOStandalone
implements InterfaceStandaloneOptimization,
InterfacePopulationChangedEventListener,
Serializable {
    public volatile MOCCOState state = new MOCCOState();
    private SwingWorker worker;
    private volatile boolean stillWorking = false;
    public int iteration = -1;
    private JFrame mainFrame;
    private boolean debug = false;
    public MOCCOViewer view;
    public JPanel mainPanel;
    public JPanel parameterPanel;
    public JPanel controlPanel;
    public JPanel buttonPanel;
    private JLabel currentState;
    private JProgressBar progressBar;

    public void initMOCCOFrame() {
        this.state.isVisible = true;
        this.mainFrame = new JFrame();
        this.mainFrame.setTitle("MOCCO - Interactive Multi-Objective Optimization");
        this.mainFrame.setSize(1200, 750);
        this.mainFrame.setLocation(50, 50);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        this.mainPanel = new JPanel();
        this.parameterPanel = new JPanel();
        this.parameterPanel.setPreferredSize(new Dimension(500, 300));
        this.parameterPanel.setMinimumSize(new Dimension(500, 300));
        this.controlPanel = new JPanel();
        this.view = new MOCCOViewer(this);
        this.mainFrame.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.parameterPanel, "West");
        this.mainPanel.add((Component)this.view, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BorderLayout());
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        this.currentState = new JLabel("Problem Initialization");
        tmpP.add(this.currentState);
        this.progressBar = new JProgressBar();
        tmpP.add(this.progressBar);
        this.buttonPanel.add((Component)tmpP, "Center");
        this.controlPanel.setMinimumSize(new Dimension(400, 0));
        this.controlPanel.setPreferredSize(new Dimension(400, 0));
        this.buttonPanel.add((Component)this.controlPanel, "East");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.mainFrame.validate();
        this.MOCCOOptimization();
    }

    public void MOCCOOptimization() {
        boolean cont = true;
        while (cont) {
            block58: {
                MOCCOPhase tmpP;
                block57: {
                    ++this.iteration;
                    while (this.stillWorking) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (this.state.originalProblem == null) {
                        this.state.originalProblem = new TF1Problem();
                        tmpP = new MOCCOProblemInitialization(this);
                        tmpP.initProcessElementParametrization();
                        while (!tmpP.isFinished()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {}
                        }
                        this.state.currentProblem = (InterfaceOptimizationProblem)this.state.originalProblem.clone();
                        this.view.problemChanged(true);
                        this.parameterPanel.removeAll();
                        tmpP = new MOCCOInitialPopulationSize(this);
                        tmpP.initProcessElementParametrization();
                        while (!tmpP.isFinished()) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {}
                        }
                        this.state.initialPopulationSize = Math.max(1, this.state.initialPopulationSize);
                        Population pop = new Population();
                        pop.setTargetSize(this.state.initialPopulationSize);
                        this.state.currentProblem = (InterfaceOptimizationProblem)this.state.originalProblem.clone();
                        this.state.currentProblem.initializePopulation(pop);
                        this.state.currentProblem.evaluate(pop);
                        this.state.addPopulation2History(pop);
                        this.view.problemChanged(true);
                    }
                    ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.state.currentProblem)).deactivateRepresentationEdit();
                    this.updateStatus("Analysis/Redefinition", 33);
                    tmpP = new MOCCOProblemRedefinition(this);
                    tmpP.initProcessElementParametrization();
                    while (!tmpP.isFinished()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    this.state.makeFitnessCache(true);
                    this.state.currentProblem.initializeProblem();
                    this.state.makeBackup();
                    this.view.problemChanged(true);
                    if (!this.state.currentProblem.isMultiObjective()) break block57;
                    this.updateStatus("MO Strategy Selection", 50);
                    tmpP = new MOCCOChooseMOStrategy(this);
                    tmpP.initProcessElementParametrization();
                    while (!tmpP.isFinished()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    block16 : switch (((MOCCOChooseMOStrategy)tmpP).getMOStrategy()) {
                        case 0: {
                            this.updateStatus("MOEA Parameterization", 75);
                            tmpP = new MOCCOParameterizeMO(this);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            break block58;
                        }
                        case 1: {
                            this.updateStatus("Reference Solution...", 75);
                            tmpP = new MOCCOChooseReferenceSolution(this);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            Object reference = ((MOCCOChooseReferenceSolution)tmpP).getReferenceSolution();
                            this.updateStatus("STEP Parameterization...", 90);
                            tmpP = new MOCCOParameterizeSTEP(this);
                            ((MOCCOParameterizeSTEP)tmpP).setReferenceSolution((AbstractEAIndividual)reference);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            break block58;
                        }
                        case 2: {
                            this.updateStatus("Reference Point...", 75);
                            tmpP = new MOCCOChooseReferencePoint(this);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            Object reference = ((MOCCOChooseReferencePoint)tmpP).getReferencePoint();
                            this.updateStatus("Reference Point Parameterization...", 90);
                            tmpP = new MOCCOParameterizeRefPoint(this);
                            ((MOCCOParameterizeRefPoint)tmpP).setReferencePoint((double[])reference);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            break block58;
                        }
                        case 3: {
                            this.updateStatus("Reference Point...", 75);
                            tmpP = new MOCCOChooseReferencePoint(this);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            Object reference = ((MOCCOChooseReferencePoint)tmpP).getReferencePoint();
                            this.updateStatus("Tchebycheff Method Parameterization...", 90);
                            tmpP = new MOCCOParameterizeTchebycheff(this);
                            ((MOCCOParameterizeTchebycheff)tmpP).setReferencePoint((double[])reference);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            break block58;
                        }
                        case 4: {
                            this.updateStatus("Reference Solution...", 75);
                            tmpP = new MOCCOChooseReferenceSolution(this);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            Object reference = ((MOCCOChooseReferenceSolution)tmpP).getReferenceSolution();
                            this.updateStatus("Geoffrion-Dyer-Feinberg Method Parameterization...", 90);
                            tmpP = new MOCCOParameterizeGDF(this);
                            ((MOCCOParameterizeGDF)tmpP).setReferenceSolution((AbstractEAIndividual)reference);
                            tmpP.initProcessElementParametrization();
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                            }
                            break block58;
                        }
                        default: {
                            tmpP = new MOCCOParameterizeMO(this);
                            while (!tmpP.isFinished()) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException e) {}
                                break block16;
                            }
                            break block58;
                        }
                    }
                    {
                        continue;
                        break;
                    }
                }
                this.updateStatus("SO-Optimizer Parameterization", 66);
                tmpP = new MOCCOParameterizeSO(this);
                tmpP.initProcessElementParametrization();
                while (!tmpP.isFinished()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.updateStatus("Optimizing...", 0);
            this.startExperiment();
        }
    }

    private void checkForObjectives(String w) {
        System.out.println("I'm currently " + w);
        System.out.print("Original Problem is ");
        if (this.state.originalProblem.isMultiObjective()) {
            System.out.println("multi-objective.");
        } else {
            System.out.println("single-objective.");
        }
        System.out.print("Current Problem is ");
        if (this.state.currentProblem.isMultiObjective()) {
            System.out.println("multi-objective.");
        } else {
            System.out.println("single-objective.");
        }
        if (this.state.backupProblem != null) {
            System.out.print("Backup Problem is ");
            if (this.state.backupProblem.isMultiObjective()) {
                System.out.println("multi-objective.");
            } else {
                System.out.println("single-objective.");
            }
        } else {
            System.out.println("No Backup Problem");
        }
    }

    private void checktForMOSO(String w) {
        System.out.println("I'm currently at " + w);
        InterfaceMOSOConverter moso = ((AbstractMultiObjectiveOptimizationProblem)this.state.currentProblem).getMOSOConverter();
        System.out.println("MOSO selected: " + moso.getName());
        InterfaceOptimizationObjective[] obj = ((InterfaceMultiObjectiveDeNovoProblem)((Object)this.state.currentProblem)).getProblemObjectives();
        String s = "Objectives: {";
        for (int i = 0; i < obj.length; ++i) {
            s = s + obj[i].getIdentName();
            if (i >= obj.length - 1) continue;
            s = s + "; ";
        }
        s = s + "}";
        System.out.println("" + s);
        if (moso instanceof MOSOWeightedFitness) {
            PropertyDoubleArray prop = ((MOSOWeightedFitness)moso).getWeights();
            s = "Weights   : {";
            for (int i = 0; i < prop.getNumRows(); ++i) {
                s = s + prop.getValue(i, 0);
                if (i >= prop.getNumRows() - 1) continue;
                s = s + "; ";
            }
            s = s + "}";
            System.out.println("" + s);
        }
    }

    public static void main(String[] args) {
        MOCCOStandalone go = new MOCCOStandalone();
        if (args.length == 0) {
            go.initMOCCOFrame();
        } else {
            String file = args[0];
            go.openObject(file);
            if (go.state == null) {
                System.out.println("No valid input state!");
                System.exit(0);
            } else if (go.state.optimizer.getPopulation().getFunctionCalls() == 0) {
                go.startExperiment();
                file = file.replaceAll(".ser", "");
                go.saveObject(file + "_Finished.ser");
            } else {
                go.initMOCCOFrame();
            }
        }
    }

    public Object openObject(String loadFrom) {
        File selected = new File(loadFrom);
        try {
            ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(new FileInputStream(selected)));
            Object obj = oi.readObject();
            oi.close();
            if (!(obj instanceof MOCCOState)) {
                throw new Exception("Object not of type MOCCOState");
            }
            return obj;
        }
        catch (Exception ex) {
            if (this.mainFrame != null) {
                JOptionPane.showMessageDialog(this.mainFrame, "Couldn't read object: " + selected.getName() + "\n" + ex.getMessage(), "Open object file", 0);
            } else {
                System.out.println("Couldn't read object: " + selected.getName() + "\n" + ex.getMessage());
            }
            return null;
        }
    }

    public void saveObject(String saveAs) {
        File sFile = new File(saveAs);
        try {
            ObjectOutputStream oo = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sFile)));
            oo.writeObject(this.state);
            oo.close();
        }
        catch (Exception ex) {
            if (this.mainFrame != null) {
                JOptionPane.showMessageDialog(this.mainFrame, "Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage(), "Save object", 0);
            }
            System.out.println("Couldn't write to file: " + sFile.getName() + "\n" + ex.getMessage());
        }
    }

    @Override
    public void startExperiment() {
        if (this.mainFrame != null) {
            // empty if block
        }
        this.stillWorking = true;
        this.state.optimizer.setProblem(this.state.currentProblem);
        if (this.debug) {
            System.out.println("" + this.state.optimizer.getStringRepresentation());
        }
        this.state.currentProblem.evaluate(this.state.optimizer.getPopulation());
        this.state.optimizer.getPopulation().setFunctionCalls(0);
        if (this.state.optimizer.getPopulation().size() == 0) {
            this.state.optimizer.initialize();
        }
        this.state.optimizer.addPopulationChangedEventListener(this);
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                return MOCCOStandalone.this.doWork();
            }

            @Override
            public void finished() {
                Population[] pop = null;
                if (MOCCOStandalone.this.state.optimizer instanceof IslandModelEA) {
                    InterfaceOptimizer[] opt = ((IslandModelEA)MOCCOStandalone.this.state.optimizer).getOptimizers();
                    pop = new Population[opt.length];
                    for (int i = 0; i < opt.length; ++i) {
                        pop[i] = opt[i].getPopulation();
                    }
                }
                MOCCOStandalone.this.state.restore();
                if (pop == null) {
                    MOCCOStandalone.this.state.addPopulation2History(MOCCOStandalone.this.state.optimizer.getPopulation());
                } else {
                    for (int i = 0; i < pop.length; ++i) {
                        MOCCOStandalone.this.state.currentProblem.evaluate(pop[i]);
                        MOCCOStandalone.this.state.addPopulation2History(pop[i]);
                    }
                }
                if (MOCCOStandalone.this.view != null) {
                    MOCCOStandalone.this.view.problemChanged(true);
                }
                MOCCOStandalone.this.stillWorking = false;
            }
        };
        this.worker.start();
    }

    void updateStatus(String t, final int i) {
        if (this.progressBar != null) {
            Runnable doSetProgressBarValue = new Runnable(){

                @Override
                public void run() {
                    MOCCOStandalone.this.progressBar.setValue(i);
                }
            };
            SwingUtilities.invokeLater(doSetProgressBarValue);
        }
        this.currentState.setText(t);
    }

    Object doWork() {
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            while (!this.state.terminator.isTerminated(this.state.optimizer.getPopulation())) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.state.optimizer.optimize();
            }
            System.gc();
        }
        catch (InterruptedException e) {
            this.updateStatus("Interrupted", 0);
            return "Interrupted";
        }
        this.updateStatus("All Done", 0);
        return "All Done";
    }

    @Override
    public void setShow(boolean t) {
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.equals("NextGenerationPerformed") && this.state.isVisible) {
            int currentProgress;
            Population population = ((InterfaceOptimizer)source).getPopulation();
            double x = 100.0;
            if (this.state.terminator instanceof EvaluationTerminator) {
                double y = x / (double)((EvaluationTerminator)this.state.terminator).getFitnessCalls();
                currentProgress = (int)((double)population.getFunctionCalls() * y);
            } else {
                currentProgress = 0;
            }
            this.updateStatus("Optimizing...", currentProgress);
        }
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }
}

