/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.EvAInfo;
import eva2.gui.MainFrame;
import eva2.tools.StringTools;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) {
        Object[] values;
        int[] arities;
        String[] keys;
        Integer[] unknownArgs;
        if (System.getProperty("mrj.version") != null || System.getProperty("os.name").toLowerCase().contains("mac")) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "EvA2");
            System.setProperty("apple.awt.application.name", "EvA2");
            System.setProperty("apple.awt.graphics.EnableQ2DX", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        if ((unknownArgs = StringTools.parseArguments(args, keys = new String[]{"--help", "--autorun", "--nosplash", "--nogui", "--params", "--treeView"}, arities = new int[]{0, 0, 0, 0, 1, 0}, values = new Object[keys.length], true)).length > 0) {
            LOGGER.warning("Unrecognized command line options: ");
            for (Integer unknownArg : unknownArgs) {
                System.err.println("   " + args[unknownArg]);
            }
            if (values[0] == null) {
                System.err.println("Try --help as argument.");
            }
        }
        Logger rootLogger = Logger.getLogger("eva2");
        rootLogger.setLevel(Level.INFO);
        rootLogger.setUseParentHandlers(false);
        if (values[0] != null) {
            System.out.println(Main.usage());
        } else {
            boolean autorun = values[1] != null;
            boolean nosplash = values[2] != null;
            boolean nogui = values[3] != null;
            boolean treeView = values[5] != null;
            String paramsFile = StringTools.checkSingleStringArg(keys[4], values[4], arities[4] - 1);
            new MainFrame(paramsFile, autorun, nosplash, nogui, treeView);
        }
    }

    public static String usage() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("EvA2");
        sbuf.append(" - ");
        sbuf.append("Evolutionary Algorithms Workbench 2");
        sbuf.append(" - Version ");
        sbuf.append(EvAInfo.getVersion());
        sbuf.append("\n");
        sbuf.append("License: ");
        sbuf.append("lgpl-3.0.txt");
        sbuf.append("\n");
        sbuf.append("Homepage: ");
        sbuf.append("http://www.cogsys.cs.uni-tuebingen.de/software/EvA2");
        sbuf.append("\n");
        sbuf.append("Command-line arguments:\n");
        sbuf.append("\t--help: Show this text and exit\n");
        sbuf.append("\t--nosplash: Deactivate splash screen\n");
        sbuf.append("\t--nogui: Deactivate GUI (makes most sense with autorun and params set)\n");
        sbuf.append("\t--autorun: Start an optimization immediately and exit after execution\n");
        sbuf.append("\t--params PARAMFILE: Load the (serialized) parameters file on start\n");
        return sbuf.toString();
    }
}

