/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.EvAInfo;
import eva2.gui.AboutDialog;
import eva2.gui.CPUPanel;
import eva2.gui.ExtAction;
import eva2.gui.HtmlDemo;
import eva2.gui.JEFrame;
import eva2.gui.JEFrameRegister;
import eva2.gui.JExtDesktopPane;
import eva2.gui.JExtDesktopPaneToolBar;
import eva2.gui.JExtMenu;
import eva2.gui.JParaPanel;
import eva2.gui.LoggingLevelLabel;
import eva2.gui.LoggingPanel;
import eva2.gui.SplashScreen;
import eva2.gui.TabbedFrameMaker;
import eva2.gui.TreeNode;
import eva2.gui.TreeSelectionListener;
import eva2.optimization.InterfaceOptimizationParameters;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.OptimizationStateListener;
import eva2.optimization.modules.AbstractModuleAdapter;
import eva2.optimization.modules.GenericModuleAdapter;
import eva2.optimization.modules.ModuleAdapter;
import eva2.optimization.modules.OptimizationModuleAdapter;
import eva2.optimization.statistics.AbstractStatistics;
import eva2.optimization.statistics.InterfaceStatisticsListener;
import eva2.optimization.statistics.InterfaceStatisticsParameters;
import eva2.tools.BasicResourceLoader;
import eva2.tools.EVAERROR;
import eva2.tools.ReflectPackage;
import eva2.util.ClassPreloader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

public class MainFrame
extends JFrame
implements OptimizationStateListener {
    private static final long serialVersionUID = 8232856334379977970L;
    private final int splashScreenTime;
    private boolean clientInitialized = false;
    private JDesktopPane desktopPane;
    private JPanel configurationPane;
    private Runnable initRunnable = null;
    private transient JProgressBar progressBar;
    private ExtAction actPreferences;
    private ExtAction actQuit;
    private static final Logger LOGGER = Logger.getLogger(MainFrame.class.getName());
    private ModuleAdapter currentModuleAdapter = null;
    private ExtAction actHelp;
    private ExtAction actAbout;
    private ExtAction actLicense;
    private String useDefaultModule = null;
    private long startTime = 0L;
    private boolean withGUI = true;
    private boolean withTreeView = false;
    private TabbedFrameMaker frameMaker = null;
    private Window parentWindow;
    private List<OptimizationStateListener> superListenerList = null;

    public void addOptimizationStateListener(OptimizationStateListener l) {
        if (this.superListenerList == null) {
            this.superListenerList = new ArrayList<OptimizationStateListener>();
        }
        this.superListenerList.add(l);
    }

    public boolean removeOptimizationStateListener(OptimizationStateListener l) {
        return this.superListenerList != null && this.superListenerList.remove(l);
    }

    public MainFrame() {
        this(null, false, false);
    }

    public MainFrame(String paramsFile, boolean autorun, boolean nosplash) {
        this(null, paramsFile, null, autorun, nosplash, false, false);
    }

    public MainFrame(boolean autorun, boolean nosplash) {
        this(null, autorun, nosplash);
    }

    public MainFrame(String paramsFile, boolean autorun, boolean noSplash, boolean noGui, boolean withTreeView) {
        this(null, paramsFile, null, autorun, noSplash, noGui, withTreeView);
    }

    public MainFrame(InterfaceOptimizationParameters optimizationParameters, boolean autorun, boolean noSplash, boolean noGui) {
        this(null, null, optimizationParameters, autorun, noSplash, noGui, false);
    }

    public MainFrame(Window parent, String paramsFile, InterfaceOptimizationParameters goParams, boolean autorun, boolean noSplash, boolean noGui) {
        this(parent, paramsFile, goParams, autorun, noSplash, noGui, false);
    }

    public MainFrame(final Window parent, final String paramsFile, final InterfaceOptimizationParameters optimizationParameters, final boolean autorun, final boolean noSplash, boolean noGui, boolean showTreeView) {
        final SplashScreen splashScreen = new SplashScreen("images/EvASplashScreen.png");
        this.preloadClasses();
        this.withGUI = !noGui;
        this.withTreeView = showTreeView;
        if (!noSplash && this.withGUI) {
            try {
                splashScreen.splash();
            }
            catch (HeadlessException e) {
                LOGGER.severe("Error: no xserver present - deactivating GUI.");
                this.withGUI = false;
            }
        }
        this.splashScreenTime = 2500;
        this.initRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    long startTime = System.currentTimeMillis();
                    MainFrame.this.init(paramsFile, optimizationParameters, parent);
                    long wait = System.currentTimeMillis() - startTime;
                    LOGGER.info("Loaded EvA2 in " + wait + "ms.");
                    if (!autorun) {
                        if (!noSplash) {
                            try {
                                if (wait < (long)MainFrame.this.splashScreenTime) {
                                    Thread.sleep((long)MainFrame.this.splashScreenTime - wait);
                                }
                            }
                            catch (Exception ignored) {}
                        }
                    } else {
                        if (!MainFrame.this.withGUI && MainFrame.this.currentModuleAdapter instanceof GenericModuleAdapter) {
                            ((GenericModuleAdapter)MainFrame.this.currentModuleAdapter).getStatistics().setSaveParams(false);
                            LOGGER.info("Autorun without GUI - not saving statistics parameters...");
                        }
                        if (MainFrame.this.withGUI) {
                            MainFrame.this.frameMaker.onUserStart();
                        } else {
                            MainFrame.this.currentModuleAdapter.startOptimization();
                        }
                    }
                    if (!noSplash && MainFrame.this.withGUI) {
                        splashScreen.dispose();
                    }
                    MainFrame.this.clientInitialized = true;
                    this.notifyAll();
                }
            }
        };
        SwingUtilities.invokeLater(this.initRunnable);
    }

    private void initLookAndFeel() {
        if (System.getProperty("os.name").equals("Linux")) {
            return;
        }
        if (System.getProperty("mrj.version") != null || System.getProperty("os.name").toLowerCase().contains("mac")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                LOGGER.log(Level.INFO, "Could not set Look&Feel", ex);
            }
        } else {
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Could not set Look&Feel", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitClientInitialized() {
        if (this.initRunnable != null) {
            Runnable runnable = this.initRunnable;
            synchronized (runnable) {
                if (!this.clientInitialized) {
                    try {
                        this.initRunnable.wait();
                        this.initRunnable = null;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void preloadClasses() {
        ClassPreloader cp = new ClassPreloader("eva2.optimization.strategies.InterfaceOptimizer", "eva2.problems.InterfaceOptimizationProblem", "eva2.optimization.operator.terminators.InterfaceTerminator");
        new Thread(cp).start();
    }

    public boolean startOptimization() {
        if (this.currentModuleAdapter != null) {
            this.currentModuleAdapter.startOptimization();
            return true;
        }
        return false;
    }

    private static void setUIFont(FontUIResource fontResource) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, fontResource);
        }
    }

    private void init(String paramsFile, InterfaceOptimizationParameters optimizationParameters, Window parent) {
        this.useDefaultModule = EvAInfo.propDefaultModule();
        this.parentWindow = parent;
        this.setDefaultCloseOperation(0);
        MainFrame.setUIFont(new FontUIResource("SansSerif", 0, 11));
        if (this.useDefaultModule != null) {
            this.useDefaultModule = this.useDefaultModule.trim();
            if (this.useDefaultModule.length() < 1) {
                this.useDefaultModule = null;
            }
        }
        if (this.withGUI) {
            this.initLookAndFeel();
            GridBagConstraints gbConstraints = new GridBagConstraints();
            this.setTitle("EvA2");
            this.setLayout(new GridBagLayout());
            this.setMinimumSize(new Dimension(1024, 800));
            this.desktopPane = new JExtDesktopPane();
            JEFrameRegister.getInstance().setDesktopPane(this.desktopPane);
            JExtDesktopPaneToolBar desktopToolBar = new JExtDesktopPaneToolBar((JExtDesktopPane)this.desktopPane);
            JPanel desktopPanel = new JPanel(new GridBagLayout());
            GridBagConstraints desktopConst = new GridBagConstraints();
            desktopConst.gridx = 0;
            desktopConst.gridy = 0;
            desktopConst.fill = 2;
            desktopConst.weightx = 1.0;
            desktopPanel.add((Component)desktopToolBar, desktopConst);
            desktopConst.gridy = 1;
            desktopConst.fill = 1;
            desktopConst.weighty = 1.0;
            desktopPanel.add((Component)this.desktopPane, desktopConst);
            BasicResourceLoader loader = BasicResourceLoader.getInstance();
            byte[] bytes = loader.getBytesFromResourceLocation("images/icon.png", true);
            this.setIconImage(Toolkit.getDefaultToolkit().createImage(bytes));
            LoggingPanel logPanel = new LoggingPanel();
            logPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.createActions();
            this.setSize(1024, 800);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenSize.width - this.getWidth()) / 2, (int)((double)(screenSize.height - this.getHeight()) / 2.5));
            this.configurationPane = new JPanel(new GridBagLayout());
            gbConstraints.ipadx = 5;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.gridx = 0;
            gbConstraints.gridy = 1;
            gbConstraints.fill = 3;
            gbConstraints.gridwidth = -1;
            gbConstraints.gridheight = -1;
            this.add((Component)this.configurationPane, gbConstraints);
            JSplitPane horizontalSplit = new JSplitPane(0, true);
            horizontalSplit.setTopComponent(desktopPanel);
            horizontalSplit.setBottomComponent(logPanel);
            horizontalSplit.setDividerSize(8);
            horizontalSplit.setOneTouchExpandable(true);
            horizontalSplit.setResizeWeight(1.0);
            horizontalSplit.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            horizontalSplit.setContinuousLayout(true);
            horizontalSplit.setDividerLocation(0.25);
            gbConstraints.gridx = 1;
            gbConstraints.gridy = 1;
            gbConstraints.fill = 1;
            gbConstraints.gridwidth = 0;
            gbConstraints.gridheight = -1;
            this.add((Component)horizontalSplit, gbConstraints);
            JPanel statusBar = new JPanel(new FlowLayout(2));
            JPanel statusBarControls = new JPanel();
            statusBarControls.setLayout(new BoxLayout(statusBarControls, 2));
            statusBarControls.add(Box.createHorizontalGlue());
            Logger.getLogger("eva2").setLevel(Level.INFO);
            LoggingLevelLabel loggingOption = new LoggingLevelLabel();
            statusBarControls.add(loggingOption);
            statusBarControls.add(Box.createHorizontalStrut(5));
            statusBarControls.add(new JSeparator(1));
            statusBarControls.add(Box.createHorizontalStrut(5));
            statusBarControls.add(new JLabel("Progress"));
            statusBarControls.add(Box.createHorizontalStrut(5));
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            statusBarControls.add(this.progressBar);
            statusBarControls.add(Box.createHorizontalStrut(5));
            statusBarControls.add(new JSeparator(1));
            statusBarControls.add(Box.createHorizontalStrut(5));
            statusBarControls.add(new JLabel("CPU"));
            statusBarControls.add(Box.createHorizontalStrut(5));
            statusBarControls.add(new CPUPanel(100));
            statusBar.add(statusBarControls);
            gbConstraints.gridx = 0;
            gbConstraints.gridy = 2;
            gbConstraints.gridwidth = 2;
            gbConstraints.weighty = 0.0;
            gbConstraints.fill = 2;
            gbConstraints.anchor = 20;
            this.add((Component)statusBar, gbConstraints);
        }
        if (this.useDefaultModule != null) {
            if (optimizationParameters == null && paramsFile != null && paramsFile.length() > 0) {
                optimizationParameters = OptimizationParameters.getInstance(paramsFile, false);
            }
            this.loadSpecificModule(this.useDefaultModule, optimizationParameters);
        }
        if (this.withGUI) {
            this.buildMenu();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    BasicResourceLoader loader = BasicResourceLoader.getInstance();
                    byte[] bytes = loader.getBytesFromResourceLocation("images/icon.png", true);
                    ImageIcon icon = new ImageIcon(bytes);
                    int result = JOptionPane.showConfirmDialog(MainFrame.this, "Do you really want to exit EvA2?", "Exit Application", 0, 3, icon);
                    if (result == 0) {
                        MainFrame.this.close();
                    }
                }
            });
            LOGGER.log(Level.INFO, "Working directory is: {0}", System.getProperty("user.dir"));
            LOGGER.log(Level.FINE, "Class path is: {0}", System.getProperty("java.class.path", "."));
            if (!this.configurationPane.isVisible()) {
                this.configurationPane.setVisible(true);
            }
            this.setVisible(true);
            LOGGER.info("EvA2 ready");
        }
    }

    public void close() {
        LOGGER.info("Closing EvA2 Client. Bye!");
        Set<String> keys = System.getenv().keySet();
        if (keys.contains("MATLAB")) {
            LOGGER.info("EvA2 workbench has been started from Matlab: not killing JVM");
        } else if (this.parentWindow == null) {
            System.exit(1);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void refreshMainPanels() {
        this.frameMaker.refreshPanels();
    }

    public static MainFrame initClientGUI(OptimizationParameters goParams, InterfaceStatisticsListener statisticsListener, WindowListener windowListener, Window parent) {
        MainFrame evaClient = new MainFrame(parent, null, goParams, false, true, false, false);
        evaClient.awaitClientInitialized();
        evaClient.addWindowListener(windowListener);
        evaClient.getStatistics().getStatisticsParameters().setOutputAllFieldsAsText(true);
        evaClient.getStatistics().addDataListener(statisticsListener);
        evaClient.refreshMainPanels();
        return evaClient;
    }

    private void createActions() {
        this.actAbout = new ExtAction("&About", "Product Information"){

            @Override
            public void actionPerformed(ActionEvent event) {
                LOGGER.info(event.getActionCommand());
                MainFrame.this.showAboutDialog();
            }
        };
        this.actLicense = new ExtAction("&License", "View License"){

            @Override
            public void actionPerformed(ActionEvent event) {
                LOGGER.info(event.getActionCommand());
                MainFrame.this.showLicense();
            }
        };
        this.actQuit = new ExtAction("&Quit", "Quit EvA2 workbench", KeyStroke.getKeyStroke(81, 2)){

            @Override
            public void actionPerformed(ActionEvent event) {
                int result = JOptionPane.showConfirmDialog(MainFrame.this, "Do you really want to exit EvA2?", "Exit Application", 0);
                if (result == 0) {
                    MainFrame.this.close();
                }
            }
        };
        this.actPreferences = new ExtAction("&Preferences", "Show preferences dialog", KeyStroke.getKeyStroke(80, 2)){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        };
        this.actHelp = new ExtAction("&Help", "Show help contents", KeyStroke.getKeyStroke(112, 0)){

            @Override
            public void actionPerformed(ActionEvent event) {
                String helpHS = "EvA2Help/EvA2Help.hs";
                ClassLoader cl = MainFrame.class.getClassLoader();
                try {
                    URL hsURL = HelpSet.findHelpSet((ClassLoader)cl, (String)helpHS);
                    HelpSet helpSet = new HelpSet(null, hsURL);
                    JHelpContentViewer helpPane = new JHelpContentViewer(helpSet);
                    JHelpNavigator helpNavigator = (JHelpNavigator)helpSet.getNavigatorView("TOC").createNavigator((HelpModel)helpPane.getModel());
                    JEFrame helpFrame = new JEFrame("Help contents");
                    JSplitPane helpSplit = new JSplitPane(1, (Component)helpNavigator, (Component)helpPane);
                    helpFrame.add(helpSplit);
                    helpFrame.setVisible(true);
                    helpFrame.setMaximum(true);
                }
                catch (Exception ee) {
                    LOGGER.log(Level.WARNING, "Could not open application help", ee);
                }
            }
        };
    }

    private void buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JExtMenu menuHelp = new JExtMenu("&Help");
        menuHelp.add(this.actHelp);
        menuHelp.addSeparator();
        menuHelp.add(this.actAbout);
        menuHelp.add(this.actLicense);
        JExtMenu menuOptions = new JExtMenu("&Options");
        menuOptions.add(this.actPreferences);
        menuOptions.addSeparator();
        menuOptions.add(this.actQuit);
        menuBar.add(menuOptions);
        menuBar.add(((JExtDesktopPane)this.desktopPane).getWindowMenu());
        menuBar.add(menuHelp);
    }

    public InterfaceOptimizationParameters getOptimizationParameters() {
        if (this.currentModuleAdapter != null && this.currentModuleAdapter instanceof AbstractModuleAdapter) {
            return ((AbstractModuleAdapter)this.currentModuleAdapter).getOptimizationParameters();
        }
        return null;
    }

    public AbstractStatistics getStatistics() {
        return ((GenericModuleAdapter)this.currentModuleAdapter).getStatistics();
    }

    public InterfaceStatisticsParameters getStatisticsParameter() {
        return ((GenericModuleAdapter)this.currentModuleAdapter).getStatistics().getStatisticsParameters();
    }

    private void loadSpecificModule(String selectedModule, InterfaceOptimizationParameters optimizationParameters) {
        OptimizationModuleAdapter newModuleAdapter = null;
        try {
            InterfaceOptimizationParameters params = optimizationParameters;
            if (optimizationParameters == null) {
                params = OptimizationParameters.getInstance();
            }
            newModuleAdapter = new OptimizationModuleAdapter(selectedModule, params, this.withGUI ? null : "EvA2");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error loading module.", e);
            EVAERROR.EXIT("Error while comAdapter.GetModuleAdapter Host: " + e.getMessage());
        }
        if (newModuleAdapter == null) {
            String dir;
            URL baseDir = this.getClass().getClassLoader().getResource("");
            String cp = System.getProperty("java.class.path", ".");
            String string = dir = baseDir == null ? System.getProperty("user.dir") : baseDir.getPath();
            if (!cp.contains(dir)) {
                System.err.println("classpath does not contain base directory!");
                System.err.println("adding base dir and trying again...");
                System.setProperty("java.class.path", cp + System.getProperty("path.separator") + dir);
                ReflectPackage.resetDynCP();
                this.loadSpecificModule(selectedModule, optimizationParameters);
            }
        } else {
            newModuleAdapter.addOptimizationStateListener(this);
            try {
                if (this.withGUI) {
                    this.frameMaker = newModuleAdapter.getModuleFrame();
                    JPanel moduleContainer = this.frameMaker.makePanel();
                    this.configurationPane.setVisible(false);
                    this.configurationPane.removeAll();
                    GridBagConstraints gbConstraints = new GridBagConstraints();
                    gbConstraints.weightx = 1.0;
                    gbConstraints.weighty = 0.0;
                    gbConstraints.gridx = 0;
                    gbConstraints.gridy = 0;
                    gbConstraints.gridwidth = 2;
                    gbConstraints.fill = 2;
                    gbConstraints.anchor = 19;
                    this.add((Component)this.frameMaker.getToolBar(), gbConstraints);
                    GridBagConstraints gbConstraints2 = new GridBagConstraints();
                    gbConstraints2.gridx = 0;
                    gbConstraints2.gridy = 0;
                    gbConstraints2.fill = 3;
                    gbConstraints2.weighty = 1.0;
                    this.configurationPane.add((Component)moduleContainer, gbConstraints2);
                    this.configurationPane.validate();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while newModuleAdapter.getModuleFrame(): " + e.getMessage(), e);
                EVAERROR.EXIT("Error while newModuleAdapter.getModuleFrame(): " + e.getMessage());
            }
            this.currentModuleAdapter = newModuleAdapter;
        }
    }

    public JComponent getEvATreeView(JParaPanel goPanel, String title, Object object) {
        TreeNode root = new TreeNode(title, object);
        JTree jtree = new JTree(root);
        JScrollPane treeView = new JScrollPane(jtree);
        TreeSelectionListener treeListener = new TreeSelectionListener(root, goPanel.getEditor(), jtree);
        return treeView;
    }

    private void showAboutDialog() {
        AboutDialog aboutDialog = new AboutDialog(this);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.setVisible(true);
        aboutDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    private void showLicense() {
        HtmlDemo lgpl = new HtmlDemo("lgpl-3.0.txt");
        HtmlDemo gpl = new HtmlDemo("gpl-3.0.txt");
        gpl.show();
        lgpl.show();
    }

    @Override
    public void performedRestart(String infoString) {
        if (this.superListenerList != null) {
            for (OptimizationStateListener l : this.superListenerList) {
                l.performedRestart(infoString);
            }
        }
        LOGGER.log(Level.INFO, "Restarted processing {0}", infoString);
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void performedStart(String infoString) {
        if (this.superListenerList != null) {
            for (OptimizationStateListener l : this.superListenerList) {
                l.performedStart(infoString);
            }
        }
        LOGGER.log(Level.INFO, "Started processing {0}", infoString);
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void performedStop() {
        if (this.superListenerList != null) {
            for (OptimizationStateListener l : this.superListenerList) {
                l.performedStop();
            }
        }
        long t = System.currentTimeMillis() - this.startTime;
        LOGGER.info(String.format("Stopped after %1$d.%2$tL s", t / 1000L, t % 1000L));
        if (!this.withGUI) {
            System.exit(0);
        }
    }

    @Override
    public void updateProgress(final int percent, String msg) {
        if (this.superListenerList != null) {
            for (OptimizationStateListener l : this.superListenerList) {
                l.updateProgress(percent, msg);
            }
        }
        if (msg != null) {
            LOGGER.info(msg);
        }
        if (this.progressBar != null) {
            Runnable doSetProgressBarValue = new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.progressBar.setValue(percent);
                }
            };
            SwingUtilities.invokeLater(doSetProgressBarValue);
        }
    }
}

