/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.HtmlDemo;
import eva2.gui.PanelMaker;
import eva2.optimization.OptimizationStateListener;
import eva2.optimization.modules.ModuleAdapter;
import eva2.optimization.statistics.OptimizationJob;
import eva2.tools.ToolBoxGui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;

public class ModuleButtonPanelMaker
implements OptimizationStateListener,
Serializable,
PanelMaker {
    private static final Logger LOGGER = Logger.getLogger(ModuleButtonPanelMaker.class.getName());
    private String name = "GENERAL";
    private ModuleAdapter moduleAdapter;
    private boolean runningState;
    private JButton runButton;
    private JButton postProcessButton;
    private JButton stopButton;
    private JButton scheduleButton;
    private JButton helpButton;
    private JToolBar toolBar;
    private String helpFileName;

    public ModuleButtonPanelMaker(ModuleAdapter adapter, boolean state) {
        this.runningState = state;
        this.moduleAdapter = adapter;
        this.toolBar = new JToolBar();
    }

    @Override
    public JToolBar makePanel() {
        this.toolBar.setFloatable(false);
        this.moduleAdapter.addOptimizationStateListener(this);
        this.runButton = ToolBoxGui.createIconifiedButton("images/Play24.gif", "Start", true);
        this.runButton.setToolTipText("Start the current optimization run.");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ModuleButtonPanelMaker.this.onUserStart();
            }
        });
        this.runButton.setEnabled(!this.runningState);
        this.toolBar.add(this.runButton);
        this.stopButton = ToolBoxGui.createIconifiedButton("images/Stop24.gif", "Stop", true);
        this.stopButton.setToolTipText("Stop the current optimization run.");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    ModuleButtonPanelMaker.this.moduleAdapter.stopOptimization();
                }
                catch (Exception ee) {
                    LOGGER.log(Level.WARNING, "Error while stopping job.", ee);
                }
            }
        });
        this.stopButton.setEnabled(this.runningState);
        this.toolBar.add(this.stopButton);
        this.postProcessButton = ToolBoxGui.createIconifiedButton("images/History24.gif", "Post Process", true);
        this.postProcessButton.setToolTipText("Start post processing according to available parameters.");
        this.postProcessButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (!ModuleButtonPanelMaker.this.moduleAdapter.startPostProcessing()) {
                        JOptionPane.showMessageDialog(null, "Post processing seems deactivated! Check the settings.", "Warning", 2);
                    }
                }
                catch (Exception ee) {
                    LOGGER.log(Level.WARNING, "Error in run", ee);
                }
            }
        });
        this.postProcessButton.setEnabled(this.runningState && this.moduleAdapter.hasPostProcessing());
        this.toolBar.add(this.postProcessButton);
        this.scheduleButton = ToolBoxGui.createIconifiedButton("images/Server24.gif", "Schedule", true);
        this.scheduleButton.setToolTipText("Schedule the currently configured optimization as a job.");
        this.scheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OptimizationJob job = ModuleButtonPanelMaker.this.moduleAdapter.scheduleJob();
                if (job == null) {
                    LOGGER.log(Level.WARNING, "There was an error on scheduling your job");
                }
            }
        });
        this.scheduleButton.setEnabled(true);
        this.toolBar.add(this.scheduleButton);
        this.makeHelpButton();
        return this.toolBar;
    }

    public void onUserStart() {
        try {
            this.moduleAdapter.startOptimization();
            this.stopButton.setEnabled(true);
            this.runButton.setEnabled(false);
            this.postProcessButton.setEnabled(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.print("Error in run: " + ex + " : " + ex.getMessage());
        }
    }

    private void makeHelpButton() {
        if (this.helpFileName != null && !this.helpFileName.equals("")) {
            this.helpButton = new JButton("Description");
            this.helpButton.setToolTipText("Description of the current optimization algorithm.");
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if (ModuleButtonPanelMaker.this.helpFileName != null) {
                            HtmlDemo temp = new HtmlDemo(ModuleButtonPanelMaker.this.helpFileName);
                            temp.show();
                        }
                        ModuleButtonPanelMaker.this.helpButton.setEnabled(true);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                        System.out.print("Error in run: " + ee + " : " + ee.getMessage());
                    }
                }
            });
            this.toolBar.add(this.helpButton);
        }
    }

    @Override
    public void performedStop() {
        this.runButton.setEnabled(true);
        this.postProcessButton.setEnabled(true);
        this.runButton.repaint();
        this.stopButton.setEnabled(false);
        this.toolBar.repaint();
    }

    @Override
    public void performedStart(String infoString) {
    }

    @Override
    public void performedRestart(String infoString) {
    }

    @Override
    public void updateProgress(int percent, String msg) {
    }

    public String getName() {
        return this.name;
    }

    public void setHelperFilename(String fileName) {
        if (fileName == null && fileName.equals(this.helpFileName)) {
            return;
        }
        if (fileName != null) {
            if (this.helpFileName == null) {
                this.helpFileName = fileName;
                this.makeHelpButton();
            } else if (!this.helpFileName.equals(fileName)) {
                this.toolBar.remove(this.helpButton);
                this.helpFileName = fileName;
                this.makeHelpButton();
            }
        } else {
            this.toolBar.remove(this.helpButton);
            this.helpFileName = fileName;
        }
    }
}

