/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.PropertySheetPanel;
import eva2.gui.TypeSelector;
import eva2.gui.TypeSelectorItem;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.tools.FileTools;
import eva2.tools.BasicResourceLoader;
import eva2.tools.SerializedObject;
import eva2.yaml.BeanSerializer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OptimizationEditorPanel
extends JPanel
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(OptimizationEditorPanel.class.getName());
    private Object backupObject;
    private PropertyChangeSupport propChangeSupport;
    private TypeSelector typeSelector;
    private PropertySheetPanel propertySheetPanel;
    private JButton openButton;
    private JButton saveButton;
    private JButton okayButton;
    private JButton cancelButton;
    private JPanel typeSelectionPanel;
    private GenericObjectEditor genericObjectEditor = null;
    private int tipMaxLen = 100;

    public OptimizationEditorPanel(Object target, Object backup, PropertyChangeSupport support, GenericObjectEditor goe) {
        this(target, backup, support, goe, false);
    }

    private void buildTypeSelectionPanel() {
        this.typeSelector = new TypeSelector();
        this.typeSelector.setEditable(false);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.typeSelectionPanel = new JPanel(new GridBagLayout());
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        JLabel typeLabel = new JLabel("Type:");
        typeLabel.setLabelFor(this.typeSelector);
        typeLabel.setDisplayedMnemonic('t');
        this.typeSelectionPanel.add((Component)typeLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 2;
        this.typeSelectionPanel.add((Component)this.typeSelector, gbConstraints);
    }

    public OptimizationEditorPanel(Object target, Object backup, PropertyChangeSupport support, GenericObjectEditor goe, boolean withCancel) {
        this.backupObject = backup;
        this.propChangeSupport = support;
        this.genericObjectEditor = goe;
        try {
            if (!Proxy.isProxyClass(target.getClass())) {
                this.backupObject = this.copyObject(target);
            }
        }
        catch (OutOfMemoryError err) {
            this.backupObject = null;
            System.gc();
            LOGGER.severe("Could not create backup object: not enough memory (OptimizationEditorPanel backup of " + target + ")");
        }
        this.buildTypeSelectionPanel();
        this.propertySheetPanel = new PropertySheetPanel();
        this.propertySheetPanel.addPropertyChangeListener(event -> this.propChangeSupport.firePropertyChange("", this.backupObject, this.genericObjectEditor.getValue()));
        this.openButton = this.makeIconButton("images/Open16.gif", "Open");
        this.openButton.setToolTipText("Load a configured object");
        this.openButton.setEnabled(true);
        this.openButton.addActionListener(event -> {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("YAML file", "yml", "yaml");
            Object object = FileTools.openObject(this.openButton, this.genericObjectEditor.getClassType(), filter);
            if (object != null) {
                this.genericObjectEditor.setValue(object);
                this.genericObjectEditor.setValue(object);
            }
        });
        this.saveButton = this.makeIconButton("images/Save16.gif", "Save");
        this.saveButton.setToolTipText("Save the current configured object");
        this.saveButton.setEnabled(true);
        this.saveButton.addActionListener(event -> {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("YAML file", "yml", "yaml");
            FileTools.saveObjectWithFileChooser(this.saveButton, BeanSerializer.serializeObject(this.genericObjectEditor.getValue()), filter);
        });
        this.okayButton = new JButton("OK");
        this.okayButton.setEnabled(true);
        this.okayButton.addActionListener(event -> {
            this.updateClassType();
            this.updateChildPropertySheet();
            Container container = this.getParent();
            while (!(container instanceof JDialog)) {
                container = container.getParent();
            }
            ((JDialog)container).dispose();
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setEnabled(true);
        this.cancelButton.addActionListener(event -> {
            if (this.backupObject != null) {
                this.genericObjectEditor.setValue(this.copyObject(this.backupObject));
                this.updateClassType();
                this.updateChooser();
                this.updateChildPropertySheet();
            }
            Container container = this.getParent();
            while (!(container instanceof JDialog)) {
                container = container.getParent();
            }
            ((JDialog)container).dispose();
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        this.add((Component)this.typeSelectionPanel, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridy = 1;
        gbConstraints.gridheight = -1;
        gbConstraints.fill = 1;
        this.add((Component)this.propertySheetPanel, gbConstraints);
        JToolBar buttonBar = new JToolBar();
        buttonBar.setRollover(true);
        buttonBar.setFloatable(false);
        buttonBar.add(this.openButton);
        buttonBar.add(this.saveButton);
        buttonBar.add(Box.createHorizontalGlue());
        if (withCancel) {
            buttonBar.add(this.cancelButton);
        }
        buttonBar.add(this.okayButton);
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridy = 2;
        gbConstraints.anchor = 21;
        gbConstraints.fill = 2;
        this.add((Component)buttonBar, gbConstraints);
        if (this.genericObjectEditor.getClassType() != null) {
            this.updateClassType();
            this.updateChooser();
            this.updateChildPropertySheet();
        }
        this.typeSelector.addItemListener(this);
    }

    private JButton makeIconButton(String iconSrc, String title) {
        byte[] bytes = BasicResourceLoader.getInstance().getBytesFromResourceLocation(iconSrc, false);
        JButton newButton = bytes == null ? new JButton(title) : new JButton(new ImageIcon(Toolkit.getDefaultToolkit().createImage(bytes)));
        return newButton;
    }

    public void setEnabledOkCancelButtons(boolean enabled) {
        this.okayButton.setEnabled(enabled);
        this.okayButton.setVisible(enabled);
        this.cancelButton.setEnabled(enabled);
    }

    protected Object copyObject(Object source) {
        Object result = null;
        try {
            SerializedObject so = new SerializedObject(source);
            result = so.getObject();
        }
        catch (Exception ex) {
            System.err.println("GenericObjectEditor: Problem making backup object");
            System.err.println(source.getClass().getName());
            ex.printStackTrace();
        }
        return result;
    }

    public void addOkListener(ActionListener a) {
        this.okayButton.addActionListener(a);
    }

    public void addCancelListener(ActionListener a) {
        this.cancelButton.addActionListener(a);
    }

    public void removeOkListener(ActionListener a) {
        this.okayButton.removeActionListener(a);
    }

    public void removeCancelListener(ActionListener a) {
        this.cancelButton.removeActionListener(a);
    }

    public void setTarget(Object o) {
        this.propertySheetPanel.setTarget(o);
    }

    public void updateClassType() {
        this.typeSelector.updateClassType(this.genericObjectEditor.getClassType().getName());
        if (this.typeSelector.getItemCount() > 1) {
            this.typeSelectionPanel.setVisible(true);
        } else {
            this.typeSelectionPanel.setVisible(false);
        }
    }

    public void updateChooser() {
        String objectName = this.genericObjectEditor.getValue().getClass().getName();
        for (int i = 0; i < this.typeSelector.getItemCount(); ++i) {
            TypeSelectorItem element = (TypeSelectorItem)this.typeSelector.getItemAt(i);
            if (!objectName.equals(element.getId())) continue;
            this.typeSelector.getModel().setSelectedItem(element);
            break;
        }
    }

    public void updateChildPropertySheet() {
        this.propertySheetPanel.setTarget(this.genericObjectEditor.getValue());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.typeSelector && e.getStateChange() == 1) {
            String className = ((TypeSelectorItem)this.typeSelector.getSelectedItem()).getId();
            try {
                Object n = Class.forName(className).newInstance();
                this.genericObjectEditor.setValue(n);
            }
            catch (Exception ex) {
                System.err.println("Exception in itemStateChanged " + ex.getMessage());
                System.err.println("Classpath is " + System.getProperty("java.class.path"));
                ex.printStackTrace();
                this.typeSelector.hidePopup();
                this.typeSelector.setSelectedIndex(0);
                JOptionPane.showMessageDialog(this, "Could not create an example of\n" + className + "\n" + "from the current classpath. Is the resource folder at the right place?\nIs the class abstract or the default constructor missing?", "GenericObjectEditor", 0);
            }
        }
    }
}

