/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.DetailButton;
import eva2.gui.PropertyBoolSelector;
import eva2.gui.PropertyPanel;
import eva2.gui.PropertyText;
import eva2.gui.PropertyValueSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

final class PropertyCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Logger LOGGER = Logger.getLogger(PropertyCellEditor.class.getName());
    private Object value;

    PropertyCellEditor() {
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent component;
        this.LOGGER.log(Level.FINEST, "Editor Component: " + value.getClass());
        this.value = value;
        if (value instanceof String) {
            component = new JLabel(value.toString());
        } else if (value instanceof PropertyPanel) {
            component = new JPanel();
            component.setLayout(new BorderLayout());
            component.add((Component)((PropertyPanel)value), "Center");
            DetailButton dialogButton = new DetailButton();
            dialogButton.addActionListener(event -> {
                ((PropertyPanel)value).showDialog();
                this.fireEditingStopped();
            });
            component.add((Component)dialogButton, "After");
        } else if (value instanceof PropertyText) {
            component = (PropertyText)value;
        } else if (value instanceof PropertyBoolSelector) {
            component = (PropertyBoolSelector)value;
        } else if (value instanceof PropertyValueSelector) {
            component = (PropertyValueSelector)value;
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        return component;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        int selectedColumn;
        JTable sourceTable = (JTable)anEvent.getSource();
        String columnName = sourceTable.getColumnName(selectedColumn = sourceTable.getSelectedColumn());
        return !"Property".equals(columnName);
    }
}

