/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.DetailButton;
import eva2.gui.PropertyBoolSelector;
import eva2.gui.PropertyPanel;
import eva2.gui.PropertyText;
import eva2.gui.PropertyValueSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

final class PropertyCellRenderer
extends DefaultTableCellRenderer {
    private Logger LOGGER = Logger.getLogger(PropertyCellRenderer.class.getName());

    PropertyCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            return this;
        }
        if (value instanceof String) {
            this.setText((String)value);
            return this;
        }
        if (value instanceof PropertyPanel) {
            JPanel component = new JPanel();
            component.setLayout(new BorderLayout());
            component.add((Component)((PropertyPanel)value), "Center");
            DetailButton dialogButton = new DetailButton();
            component.add((Component)dialogButton, "After");
            return component;
        }
        if (value instanceof PropertyText) {
            this.setText(((PropertyText)value).getText());
            return this;
        }
        if (value instanceof PropertyBoolSelector) {
            return (PropertyBoolSelector)value;
        }
        if (value instanceof PropertyValueSelector) {
            PropertyValueSelector elector = (PropertyValueSelector)value;
            this.setText(elector.getSelectedItem().toString());
            return this;
        }
        this.LOGGER.log(Level.FINEST, "Cell Component: " + value.getClass());
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

