/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class PropertyDialog
extends JDialog {
    private PropertyEditor propertyEditor;
    private Component editorComponent;

    public PropertyDialog(Window parent, PropertyEditor editor, String title) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(PropertyDialog.getFrameNameFromEditor(editor));
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.propertyEditor = editor;
        this.editorComponent = editor.getCustomEditor();
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.editorComponent, "Center");
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    protected static String getFrameNameFromEditor(PropertyEditor editor) {
        if (editor.getValue().getClass().isArray()) {
            return "Array of " + StringTools.cutClassName(editor.getValue().getClass().getComponentType().getName());
        }
        return StringTools.cutClassName(editor.getValue().getClass().getName());
    }

    public void updateFrameTitle(PropertyEditor editor) {
        this.setTitle(PropertyDialog.getFrameNameFromEditor(editor));
    }

    public PropertyEditor getEditor() {
        return this.propertyEditor;
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", actionListener);
        return rootPane;
    }
}

