/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.BeanInspector;
import java.io.Serializable;

public class PropertyDoubleArray
implements Serializable {
    private double[][] doubleArray;
    private int numCols = 1;

    public PropertyDoubleArray(double[] d) {
        this.setDoubleArray(d);
    }

    public PropertyDoubleArray(double[][] d) {
        this.setDoubleArray(d);
    }

    public PropertyDoubleArray(PropertyDoubleArray d) {
        this.doubleArray = (double[][])d.doubleArray.clone();
        this.numCols = d.numCols;
    }

    public PropertyDoubleArray(int rows, int cols, double ... d) {
        this.doubleArray = rows > 0 && cols > 0 ? new double[rows][cols] : (double[][])null;
        this.numCols = cols;
        int index = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.doubleArray[i][j] = d[index];
                if (++index < d.length) continue;
                index = 0;
            }
        }
    }

    public Object clone() {
        return new PropertyDoubleArray(this);
    }

    public void setDoubleArray(double[] d) {
        this.doubleArray = new double[d.length][1];
        for (int i = 0; i < d.length; ++i) {
            this.doubleArray[i][0] = d[i];
        }
        this.numCols = 1;
    }

    public void setDoubleArray(double[][] d) {
        this.doubleArray = d;
        this.numCols = d.length > 0 ? d[0].length : 1;
    }

    public double[][] getDoubleArrayShallow() {
        return this.doubleArray;
    }

    public double[] getDoubleColumnAsVector(int col) {
        if (col >= this.numCols) {
            throw new IllegalArgumentException("Error, invalid column selected, " + col + " of " + this.numCols);
        }
        double[] ret = new double[this.doubleArray.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.doubleArray[i][col];
        }
        return ret;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getNumRows() {
        return this.doubleArray.length;
    }

    public double getValue(int i, int j) {
        if (i < 0 || j < 0 || i >= this.getNumRows() || j >= this.getNumCols()) {
            throw new IllegalArgumentException("Error, invalid access to double array: " + i + "," + j + " within " + this.getNumRows() + "," + this.getNumCols());
        }
        return this.doubleArray[i][j];
    }

    public void adaptRowCount(int k) {
        if (k != this.doubleArray.length) {
            double[][] newDD = new double[k][this.numCols];
            for (int i = 0; i < k; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    newDD[i][j] = i < this.doubleArray.length ? this.doubleArray[i][j] : this.doubleArray[this.doubleArray.length - 1][j];
                }
            }
            this.setDoubleArray(newDD);
        }
    }

    public void deleteRow(int k) {
        if (k < 0 || k >= this.getNumRows()) {
            throw new IllegalArgumentException("Invalid index to deleteRow: " + k + " is not a valid row.");
        }
        double[][] newDD = new double[this.getNumRows() - 1][this.getNumCols()];
        int inc = 0;
        for (int i = 0; i < newDD.length; ++i) {
            if (i == k) {
                inc = 1;
            }
            System.arraycopy(this.doubleArray[i + inc], 0, newDD[i], 0, this.getNumCols());
        }
        this.setDoubleArray(newDD);
    }

    public void addRowCopy(int k) {
        if (k < 0 || k >= this.getNumRows()) {
            k = this.getNumRows() - 1;
        }
        double[][] newDD = new double[this.getNumRows() + 1][this.getNumCols()];
        for (int i = 0; i < this.getNumRows(); ++i) {
            System.arraycopy(this.doubleArray[i], 0, newDD[i], 0, this.getNumCols());
        }
        if (k >= 0) {
            System.arraycopy(newDD[k], 0, newDD[newDD.length - 1], 0, this.getNumCols());
        } else {
            for (int j = 0; j < this.getNumCols(); ++j) {
                newDD[newDD.length - 1][j] = 1.0;
            }
        }
        this.setDoubleArray(newDD);
    }

    public void normalizeColumns() {
        double colSum = 0.0;
        for (int j = 0; j < this.getNumCols(); ++j) {
            int i;
            colSum = 0.0;
            for (i = 0; i < this.getNumRows(); ++i) {
                colSum += this.doubleArray[i][j];
            }
            if (colSum == 0.0) continue;
            for (i = 0; i < this.getNumRows(); ++i) {
                double[] dArray = this.doubleArray[i];
                int n = j;
                dArray[n] = dArray[n] / colSum;
            }
        }
    }

    public boolean isValidRow(int k) {
        return k >= 0 && k < this.getNumRows();
    }

    public String toString() {
        return BeanInspector.toString(this.doubleArray);
    }
}

