/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.BeanInspector;
import eva2.gui.MultiLineString;
import eva2.gui.PropertyDoubleArray;
import eva2.gui.PropertyEpsilonConstraint;
import eva2.gui.PropertyEpsilonThreshold;
import eva2.gui.PropertyFilePath;
import eva2.gui.PropertyIntArray;
import eva2.gui.PropertyOptimizationObjectives;
import eva2.gui.PropertyOptimizationObjectivesWithParam;
import eva2.gui.PropertySelectableList;
import eva2.gui.PropertyWeightedLPTchebycheff;
import eva2.gui.editor.AreaEditor;
import eva2.gui.editor.ArrayEditor;
import eva2.gui.editor.DoubleArrayEditor;
import eva2.gui.editor.EnumEditor;
import eva2.gui.editor.EpsilonConstraintEditor;
import eva2.gui.editor.EpsilonThresholdEditor;
import eva2.gui.editor.FilePathEditor;
import eva2.gui.editor.GenericObjectEditor;
import eva2.gui.editor.IntArrayEditor;
import eva2.gui.editor.MultiLineStringEditor;
import eva2.gui.editor.ObjectArrayEditor;
import eva2.gui.editor.OptimizationObjectivesEditor;
import eva2.gui.editor.OptimizationObjectivesWithParamEditor;
import eva2.gui.editor.StringSelectionEditor;
import eva2.gui.editor.TagEditor;
import eva2.gui.editor.WeigthedLPTchebycheffEditor;
import eva2.optimization.individuals.codings.gp.GPArea;
import eva2.optimization.operator.terminators.InterfaceTerminator;
import eva2.tools.Primitives;
import eva2.tools.SelectedTag;
import eva2.tools.StringSelection;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.JPanel;

public class PropertyEditorProvider {
    public static boolean useDefaultGOE = true;

    public static PropertyEditor findEditor(Class<?> cls) {
        JPanel editor = PropertyEditorManager.findEditor(cls);
        if (editor == null && Primitives.isWrapperType(cls)) {
            editor = PropertyEditorManager.findEditor(Primitives.unwrap(cls));
        }
        if (editor == null && useDefaultGOE) {
            if (cls.isArray()) {
                Class<?> unwrapped;
                Class<?> clazz = unwrapped = Primitives.isWrapperType(cls.getComponentType()) ? Primitives.unwrap(cls.getComponentType()) : cls;
                editor = unwrapped.isPrimitive() ? new ArrayEditor() : new ObjectArrayEditor(unwrapped.getComponentType());
            } else if (cls.isEnum()) {
                editor = new EnumEditor();
            } else {
                editor = new GenericObjectEditor();
                ((GenericObjectEditor)((Object)editor)).setClassType(cls);
            }
        }
        return editor;
    }

    public static PropertyEditor findEditor(PropertyDescriptor prop, Object value) {
        PropertyEditor editor = null;
        Class<?> pec = prop.getPropertyEditorClass();
        Class<?> type = prop.getPropertyType();
        try {
            if (pec != null) {
                editor = (ObjectArrayEditor)pec.newInstance();
            }
        }
        catch (Exception e) {
            editor = null;
        }
        if (editor == null) {
            if (value != null) {
                editor = Primitives.isWrapperType(value.getClass()) ? PropertyEditorManager.findEditor(Primitives.unwrap(value.getClass())) : PropertyEditorManager.findEditor(value.getClass());
            }
            if (editor == null && BeanInspector.isJavaPrimitive(value.getClass())) {
                Class prim = BeanInspector.getBoxedType(value.getClass());
                if (prim != null) {
                    editor = PropertyEditorManager.findEditor(prim);
                }
                if (editor == null && (prim = BeanInspector.getUnboxedType(value.getClass())) != null) {
                    editor = PropertyEditorManager.findEditor(prim);
                }
            }
            if (editor == null) {
                editor = PropertyEditorManager.findEditor(type);
            }
            if (editor == null && useDefaultGOE) {
                if (type.isArray()) {
                    Class<?> unwrapped;
                    Class<?> clazz = unwrapped = Primitives.isWrapperType(type.getComponentType()) ? Primitives.unwrap(type.getComponentType()) : type;
                    editor = unwrapped.isPrimitive() ? new ArrayEditor() : new ObjectArrayEditor(unwrapped.getComponentType());
                } else if (type.isEnum()) {
                    editor = new EnumEditor();
                } else {
                    editor = new GenericObjectEditor();
                    ((GenericObjectEditor)editor).setClassType(type);
                }
            }
        }
        if (editor == null) {
            String getterClass = prop.getReadMethod().getDeclaringClass().getName();
            if (getterClass.indexOf("java.") != 0) {
                System.err.println("Warning: Can't find public property editor for property \"" + prop.getDisplayName() + "\" (class \"" + type.getName() + "\").  Skipping.");
            }
        } else if (editor instanceof GenericObjectEditor) {
            ((GenericObjectEditor)editor).setClassType(type);
        }
        return editor;
    }

    public static void installEditors() {
        PropertyEditorManager.registerEditor(Enum.class, null);
        PropertyEditorManager.registerEditor(SelectedTag.class, TagEditor.class);
        PropertyEditorManager.registerEditor(Enum.class, EnumEditor.class);
        PropertyEditorManager.registerEditor(int[].class, ArrayEditor.class);
        PropertyEditorManager.registerEditor(double[].class, ArrayEditor.class);
        PropertyEditorManager.registerEditor(String[].class, ArrayEditor.class);
        PropertyEditorManager.registerEditor(InterfaceTerminator[].class, ArrayEditor.class);
        PropertyEditorManager.registerEditor(StringSelection.class, StringSelectionEditor.class);
        PropertyEditorManager.registerEditor(GPArea.class, AreaEditor.class);
        PropertyEditorManager.registerEditor(PropertyDoubleArray.class, DoubleArrayEditor.class);
        PropertyEditorManager.registerEditor(PropertyIntArray.class, IntArrayEditor.class);
        PropertyEditorManager.registerEditor(PropertyEpsilonThreshold.class, EpsilonThresholdEditor.class);
        PropertyEditorManager.registerEditor(PropertyEpsilonConstraint.class, EpsilonConstraintEditor.class);
        PropertyEditorManager.registerEditor(PropertyWeightedLPTchebycheff.class, WeigthedLPTchebycheffEditor.class);
        PropertyEditorManager.registerEditor(PropertyFilePath.class, FilePathEditor.class);
        PropertyEditorManager.registerEditor(PropertyOptimizationObjectives.class, OptimizationObjectivesEditor.class);
        PropertyEditorManager.registerEditor(PropertyOptimizationObjectivesWithParam.class, OptimizationObjectivesWithParamEditor.class);
        PropertyEditorManager.registerEditor(MultiLineString.class, MultiLineStringEditor.class);
        PropertyEditorManager.registerEditor(PropertySelectableList.class, ArrayEditor.class);
    }
}

