/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.PropertyDialog;
import eva2.tools.StringTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertyPanel
extends JPanel {
    private PropertyEditor propertyEditor;
    private PropertyDialog propertyDialog;
    private JLabel textLabel;

    public PropertyPanel(PropertyEditor editor) {
        this.setToolTipText("Click to edit properties for this object");
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 2;
        this.propertyEditor = editor;
        this.textLabel = new JLabel();
        this.add((Component)this.textLabel, gbConstraints);
    }

    public final void showDialog() {
        Window parent = (Window)this.getRootPane().getParent();
        if (this.propertyDialog == null) {
            this.propertyDialog = new PropertyDialog(parent, this.propertyEditor, StringTools.cutClassName(this.propertyEditor.getClass().getName()));
            this.propertyDialog.setPreferredSize(new Dimension(500, 300));
            this.propertyDialog.setModal(true);
            this.propertyDialog.setVisible(true);
        } else {
            this.propertyDialog.updateFrameTitle(this.propertyEditor);
            this.propertyDialog.setVisible(false);
            this.propertyDialog.requestFocus();
        }
    }

    @Override
    public void removeNotify() {
        if (this.propertyDialog != null) {
            this.propertyDialog = null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets i = this.textLabel.getInsets();
        Rectangle box = new Rectangle(i.left, i.top, this.getSize().width - i.left - i.right, this.getSize().height - i.top - i.bottom);
        Color back = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(i.left, i.top, this.getSize().width - i.right - i.left, this.getSize().height - i.bottom - i.top);
        g.setColor(back);
        this.propertyEditor.paintValue(g, box);
    }

    public PropertyEditor getEditor() {
        return this.propertyEditor;
    }
}

