/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class PropertySelectableList<T>
implements Serializable {
    protected T[] objects;
    protected boolean[] selections;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public PropertySelectableList(T[] initial) {
        this.objects = initial;
        this.selections = new boolean[initial.length];
    }

    public PropertySelectableList(PropertySelectableList<T> b) {
        if (b.objects != null) {
            this.objects = (Object[])b.objects.clone();
        }
        if (b.selections != null) {
            this.selections = new boolean[b.selections.length];
            System.arraycopy(b.selections, 0, this.selections, 0, this.selections.length);
        }
    }

    public Object clone() {
        return new PropertySelectableList<T>(this);
    }

    public void setObjects(T[] o) {
        this.objects = o;
        this.selections = new boolean[o.length];
        this.propertyChangeSupport.firePropertyChange("PropertySelectableList", null, this);
    }

    public void setObjects(T[] o, boolean[] selection) {
        this.objects = o;
        this.selections = selection;
        if (o.length != selection.length) {
            throw new RuntimeException("Error, mismatching length of arrays in " + this.getClass());
        }
        this.propertyChangeSupport.firePropertyChange("PropertySelectableList", null, this);
    }

    public T[] getObjects() {
        return this.objects;
    }

    public T[] getSelectedObjects() {
        Object[] selObjects = (Object[])this.getObjects().clone();
        for (int i = 0; i < selObjects.length; ++i) {
            if (this.selections[i]) continue;
            selObjects[i] = null;
        }
        return selObjects;
    }

    public void setSelectionByIndices(int[] selection) {
        this.selections = new boolean[this.getObjects().length];
        for (int i = 0; i < selection.length; ++i) {
            this.selections[selection[i]] = true;
        }
        this.propertyChangeSupport.firePropertyChange("PropertySelectableList", null, this);
    }

    public void setSelection(boolean[] selection) {
        this.selections = selection;
        this.propertyChangeSupport.firePropertyChange("PropertySelectableList", null, this);
    }

    public boolean[] getSelection() {
        return this.selections;
    }

    public void setSelectionForElement(int index, boolean b) {
        if (this.selections[index] != b) {
            this.selections[index] = b;
            this.propertyChangeSupport.firePropertyChange("PropertySelectableList", null, this);
        }
    }

    public int size() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.length;
    }

    public T get(int i) {
        return this.objects[i];
    }

    public boolean isSelected(int i) {
        return this.selections[i];
    }

    public void clear() {
        this.objects = null;
        this.selections = null;
        this.propertyChangeSupport.firePropertyChange("PropertySelectableList", null, this);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }
}

