/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.BeanInspector;
import eva2.gui.HtmlDemo;
import eva2.gui.PropertyBoolSelector;
import eva2.gui.PropertyCellEditor;
import eva2.gui.PropertyCellRenderer;
import eva2.gui.PropertyEditorProvider;
import eva2.gui.PropertyPanel;
import eva2.gui.PropertyText;
import eva2.gui.PropertyValueSelector;
import eva2.gui.TitledSeparator;
import eva2.gui.editor.GenericObjectEditor;
import eva2.tools.StringTools;
import eva2.util.annotation.Description;
import eva2.util.annotation.Hidden;
import eva2.util.annotation.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public final class PropertySheetPanel
extends JPanel
implements PropertyChangeListener {
    public static final Logger LOGGER = Logger.getLogger(PropertySheetPanel.class.getName());
    private Object targetObject;
    private PropertyDescriptor[] propertyDescriptors;
    private MethodDescriptor[] methodDescriptors;
    private PropertyEditor[] propertyEditors;
    private Object[] objectValues;
    private JComponent[] views;
    private JComponent[] viewWrappers;
    private JLabel[] propertyLabels;
    private String[] toolTips;
    private String className;
    private JButton helpButton;
    private int numEditableProperties = 0;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ToolTipTable propertyTable;
    private DefaultTableModel propertyTableModel;

    public PropertySheetPanel() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.wasModified(evt);
        this.propertyChangeSupport.removePropertyChangeListener(this);
        this.propertyChangeSupport.firePropertyChange("", null, this.targetObject);
        this.propertyChangeSupport.addPropertyChangeListener(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public static JComponent getView(PropertyEditor editor) {
        String[] tags;
        JComponent view = editor.isPaintable() && editor.supportsCustomEditor() ? new PropertyPanel(editor) : ((tags = editor.getTags()) != null ? (tags.length == 2 && tags[0].equals("True") && tags[1].equals("False") ? new PropertyBoolSelector(editor) : new PropertyValueSelector(editor)) : (editor.getAsText() != null ? new PropertyText(editor) : null));
        return view;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setTarget(Object targ) {
        this.propertyTableModel = new DefaultTableModel();
        this.propertyTableModel.addColumn("Property");
        this.propertyTableModel.addColumn("Value");
        this.propertyTable = new ToolTipTable(this.propertyTableModel);
        this.propertyTable.setDefaultRenderer(Object.class, new PropertyCellRenderer());
        this.propertyTable.setDefaultEditor(Object.class, new PropertyCellEditor());
        this.propertyTable.setRowHeight(22);
        this.propertyTable.setDragEnabled(false);
        this.propertyTable.setGridColor(Color.LIGHT_GRAY);
        this.propertyTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.removeAll();
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        this.numEditableProperties = 0;
        this.targetObject = targ;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.targetObject.getClass());
            this.propertyDescriptors = bi.getPropertyDescriptors();
            this.methodDescriptors = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            LOGGER.log(Level.SEVERE, "Could not create editor for object.", ex);
            return;
        }
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = 1;
        gbConstraints.ipady = 10;
        Description description = targ.getClass().getAnnotation(Description.class);
        if (description != null) {
            int rowHeight = 12;
            JPanel jPanel = this.makeInfoPanel(description.value(), targ, rowHeight);
            if (jPanel != null) {
                gbConstraints.gridx = 0;
                gbConstraints.gridy = 0;
                gbConstraints.fill = 2;
                gbConstraints.anchor = 19;
                this.add((Component)new TitledSeparator("Info"), gbConstraints);
                gbConstraints.gridy = 1;
                this.add((Component)jPanel, gbConstraints);
            }
        }
        int methsFound = 0;
        for (MethodDescriptor methodDescriptor : this.methodDescriptors) {
            String name = methodDescriptor.getDisplayName();
            Method meth = methodDescriptor.getMethod();
            if (name.equals("hideHideable")) {
                Object[] args = new Object[]{};
                try {
                    meth.invoke(this.targetObject, args);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++methsFound;
            } else if (name.equals("customPropertyOrder")) {
                ++methsFound;
                this.reorderProperties(meth);
            }
            if (methsFound == 2) break;
        }
        this.propertyEditors = new PropertyEditor[this.propertyDescriptors.length];
        this.objectValues = PropertySheetPanel.getValues(this.targetObject, this.propertyDescriptors, true, true, true);
        this.views = new JComponent[this.propertyDescriptors.length];
        this.viewWrappers = new JComponent[this.propertyDescriptors.length];
        this.propertyLabels = new JLabel[this.propertyDescriptors.length];
        this.toolTips = new String[this.propertyDescriptors.length];
        boolean bl = false;
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            JComponent newView;
            String name;
            block16: {
                name = this.propertyDescriptors[i].getDisplayName();
                if (this.objectValues[i] == null) continue;
                try {
                    void var5_9;
                    this.propertyEditors[i] = this.makeEditor(this.propertyDescriptors[i], name, this.objectValues[i]);
                    if (this.propertyEditors[i] == null) continue;
                    if (this.propertyDescriptors[i].getWriteMethod() != null && this.propertyDescriptors[i].getWriteMethod().isAnnotationPresent(Parameter.class)) {
                        Parameter parameter = this.propertyDescriptors[i].getWriteMethod().getAnnotation(Parameter.class);
                        this.toolTips[var5_9] = parameter.description();
                    } else {
                        this.toolTips[var5_9] = BeanInspector.getToolTipText(name, this.methodDescriptors, this.targetObject);
                    }
                    ++var5_9;
                    newView = PropertySheetPanel.getView(this.propertyEditors[i]);
                    if (newView == null) {
                        LOGGER.warning("Warning: Property \"" + name + "\" has non-displayable editor.  Skipping.");
                    }
                    break block16;
                }
                catch (Exception ex) {
                    LOGGER.warning("Skipping property " + name + " ; exception: " + ex);
                    ex.printStackTrace();
                }
                continue;
            }
            this.propertyTableModel.addRow(new Object[]{this.prepareLabel(name), newView});
        }
        this.propertyTable.setToolTips(this.toolTips);
        gbConstraints.gridy = 2;
        this.add((Component)new TitledSeparator("Properties"), gbConstraints);
        JScrollPane scrollableTable = new JScrollPane(this.propertyTable, 20, 30);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 3;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        scrollableTable.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.add((Component)scrollableTable, gbConstraints);
        this.setMinimumSize(new Dimension(350, 0));
        this.validate();
        this.setVisible(true);
    }

    private String prepareLabel(String label) {
        label = StringTools.translateGreek(label);
        label = StringTools.humaniseCamelCase(label);
        label = StringTools.subscriptIndices(label);
        label = "<html>" + label + "</html>";
        return label;
    }

    public static PropertyDescriptor[] getProperties(Object target) {
        BeanInfo bi;
        try {
            bi = Introspector.getBeanInfo(target.getClass());
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
        return bi.getPropertyDescriptors();
    }

    public static String[] getPropertyNames(Object target) {
        return PropertySheetPanel.getNames(PropertySheetPanel.getProperties(target));
    }

    public static Object[] getPropertyValues(Object target, boolean omitExpert, boolean omitHidden, boolean onlySetAndGettable) {
        return PropertySheetPanel.getValues(target, PropertySheetPanel.getProperties(target), omitExpert, omitHidden, onlySetAndGettable);
    }

    public static String[] getNames(PropertyDescriptor[] props) {
        String[] names = new String[props.length];
        for (int i = 0; i < props.length; ++i) {
            names[i] = props[i].getDisplayName();
        }
        return names;
    }

    public static Object[] getValues(Object target, PropertyDescriptor[] props, boolean omitExpert, boolean omitHidden, boolean onlySetAndGettable) {
        Object[] values = new Object[props.length];
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getDisplayName();
            if (props[i].isExpert() && omitExpert || props[i].isHidden() && omitHidden) continue;
            Method getter = props[i].getReadMethod();
            Method setter = props[i].getWriteMethod();
            if (onlySetAndGettable && (getter == null || setter == null) || setter != null && setter.isAnnotationPresent(Hidden.class)) continue;
            Object[] args = new Object[]{};
            Object value = null;
            try {
                value = getter.invoke(target, args);
            }
            catch (Exception ex) {
                System.out.println("Exception on getting value for property " + name + " on target " + target.toString());
                ex.printStackTrace();
                values[i] = null;
            }
            values[i] = value;
        }
        return values;
    }

    private PropertyEditor makeEditor(PropertyDescriptor property, String name, Object value) {
        PropertyEditor editor = PropertyEditorProvider.findEditor(property, value);
        if (editor == null) {
            return null;
        }
        if (value == null) {
            String getterClass = property.getReadMethod().getDeclaringClass().getName();
            if (getterClass.indexOf("java.") != 0) {
                System.out.println("Warning: Property \"" + name + "\" of class " + this.targetObject.getClass() + " has null initial value.  Skipping.");
            }
            return null;
        }
        editor.setValue(value);
        editor.addPropertyChangeListener(this);
        return editor;
    }

    private PropertyDescriptor[] reorderProperties(Method meth) {
        Object[] args = new Object[]{};
        Object retV = null;
        PropertyDescriptor[] newProps = null;
        try {
            retV = meth.invoke(this.targetObject, args);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (retV != null) {
            try {
                if (retV.getClass().isArray()) {
                    String[] swProps = (String[])retV;
                    PropertyDescriptor[] oldProps = (PropertyDescriptor[])this.propertyDescriptors.clone();
                    newProps = new PropertyDescriptor[oldProps.length];
                    int firstNonNull = 0;
                    for (int i = 0; i < oldProps.length; ++i) {
                        if (i < swProps.length) {
                            int pInOld = this.findProp(oldProps, swProps[i]);
                            newProps[i] = oldProps[pInOld];
                            oldProps[pInOld] = null;
                            continue;
                        }
                        firstNonNull = this.findFirstNonNullAfter(oldProps, firstNonNull);
                        newProps[i] = oldProps[firstNonNull];
                        ++firstNonNull;
                    }
                    this.propertyDescriptors = newProps;
                }
            }
            catch (Exception e) {
                System.err.println("Error during reordering properties: " + e.getMessage());
                return this.propertyDescriptors;
            }
        }
        return newProps;
    }

    private int findFirstNonNullAfter(PropertyDescriptor[] arr, int firstLook) {
        for (int i = firstLook; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            return i;
        }
        return -1;
    }

    private int findProp(PropertyDescriptor[] oldProps, String string) {
        for (int i = 0; i < oldProps.length; ++i) {
            String name;
            if (oldProps[i] == null || (name = oldProps[i].getDisplayName()).compareTo(string) != 0) continue;
            return i;
        }
        LOGGER.warning("Error, property not found: " + string);
        return -1;
    }

    private JPanel makeInfoPanel(String infoText, Object targ, int rowHeight) {
        this.className = targ.getClass().getName();
        this.helpButton = new JButton();
        this.helpButton.setToolTipText("More information about " + this.className);
        this.helpButton.addActionListener(event -> this.openHelpFrame());
        this.helpButton.putClientProperty("JButton.buttonType", "help");
        JTextArea infoTextArea = new JTextArea();
        infoTextArea.setText(infoText);
        infoTextArea.setFont(new Font("SansSerif", 0, rowHeight));
        infoTextArea.setEditable(false);
        infoTextArea.setLineWrap(true);
        infoTextArea.setWrapStyleWord(true);
        infoTextArea.setBackground(this.getBackground());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.add((Component)infoTextArea, "Center");
        if (HtmlDemo.resourceExists(this.getHelpFileName())) {
            infoPanel.add((Component)this.helpButton, "After");
        } else {
            LOGGER.log(Level.FINE, "Not adding help button because of missing {0}", this.getHelpFileName());
        }
        return infoPanel;
    }

    protected String getHelpFileName() {
        return StringTools.cutClassName(this.className) + ".html";
    }

    protected void openHelpFrame() {
        HtmlDemo temp = new HtmlDemo(this.getHelpFileName());
        temp.show();
    }

    public int editableProperties() {
        return this.numEditableProperties;
    }

    synchronized boolean updateValue(int i, Object newValue) {
        PropertyDescriptor property = this.propertyDescriptors[i];
        Method getter = this.propertyDescriptors[i].getReadMethod();
        this.objectValues[i] = newValue;
        Method setter = property.getWriteMethod();
        PropertyEditor tmpEdit = null;
        tmpEdit = PropertyEditorProvider.findEditor(this.propertyDescriptors[i], newValue);
        if (tmpEdit == null) {
            tmpEdit = PropertyEditorProvider.findEditor(this.propertyDescriptors[i].getPropertyType());
        }
        if (tmpEdit.getClass() != this.propertyEditors[i].getClass()) {
            this.objectValues[i] = newValue;
            this.propertyEditors[i] = tmpEdit;
            if (tmpEdit instanceof GenericObjectEditor) {
                ((GenericObjectEditor)tmpEdit).setClassType(this.propertyDescriptors[i].getPropertyType());
            }
            this.propertyEditors[i].setValue(newValue);
            JComponent newView = null;
            newView = PropertySheetPanel.getView(tmpEdit);
            if (newView == null) {
                LOGGER.warning("Property \"" + this.propertyDescriptors[i].getDisplayName() + "\" has non-displayable editor.  Skipping.");
                return false;
            }
            this.propertyEditors[i].addPropertyChangeListener(this);
            this.views[i] = newView;
            if (this.toolTips[i] != null) {
                this.views[i].setToolTipText(this.toolTips[i]);
            }
            this.viewWrappers[i].removeAll();
            this.viewWrappers[i].setLayout(new BorderLayout());
            this.viewWrappers[i].add((Component)this.views[i], "Center");
            this.viewWrappers[i].repaint();
        }
        try {
            Object[] args = new Object[]{newValue};
            args[0] = newValue;
            Object[] args2 = new Object[]{};
            setter.invoke(this.targetObject, args);
            this.objectValues[i] = getter.invoke(this.targetObject, args2);
            if (newValue instanceof Integer && ((Integer)newValue).intValue() != ((Integer)this.objectValues[i]).intValue()) {
                this.propertyEditors[i].setValue(this.objectValues[i]);
            }
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof PropertyVetoException) {
                LOGGER.warning("PropertySheetPanel.wasModified(): WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage());
            } else {
                LOGGER.warning("PropertySheetPanel.wasModified(): InvocationTargetException while updating " + property.getName());
                LOGGER.warning("PropertySheetPanel.wasModified(): " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            LOGGER.warning("PropertySheetPanel.wasModified(): Unexpected exception while updating " + property.getName());
        }
        if (this.views[i] != null && this.views[i] instanceof PropertyPanel) {
            this.views[i].repaint();
            this.revalidate();
        }
        return true;
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        int propIndex = -1;
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            for (int i = 0; i < this.propertyEditors.length; ++i) {
                if (this.propertyEditors[i] != editor) continue;
                propIndex = i;
                if (this.wasModified(i, editor.getValue(), true)) break;
            }
            if (propIndex == -1) {
                LOGGER.severe("Could not identify event editor! (PropertySheetPanel)");
            }
        } else {
            LOGGER.warning("Unknown event source! (PropertySheetPanel)");
        }
    }

    synchronized boolean wasModified(int propIndex, Object value, boolean followDependencies) {
        Object o;
        int i;
        if (!this.updateValue(propIndex, value)) {
            return false;
        }
        boolean doRepaint = false;
        for (i = 0; i < this.propertyEditors.length; ++i) {
            if (i == propIndex || !this.updateFieldView(i)) continue;
            doRepaint = true;
        }
        if (doRepaint) {
            for (Container p = this; p != null && !p.getSize().equals(((Container)p).getPreferredSize()); p = p.getParent()) {
                p.setSize(((Container)p).getPreferredSize());
            }
        }
        for (i = 0; i < this.propertyDescriptors.length; ++i) {
            Object o2;
            Method getter = null;
            if (this.propertyEditors[i] == null) continue;
            try {
                getter = this.propertyDescriptors[i].getReadMethod();
                Object[] args = new Object[]{};
                o2 = getter.invoke(this.targetObject, args);
            }
            catch (Exception ex) {
                o2 = null;
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
            if (o2 != null && o2 == this.objectValues[i] && BeanInspector.isJavaPrimitive(o2.getClass()) || o2 != null && o2.equals(this.objectValues[i])) continue;
            this.objectValues[i] = o2;
            if (this.propertyEditors[i] == null) continue;
            this.propertyEditors[i].removePropertyChangeListener(this);
            this.propertyEditors[i].setValue(o2);
            this.propertyEditors[i].addPropertyChangeListener(this);
            if (this.views[i] == null) continue;
            this.views[i].repaint();
        }
        if (followDependencies && (o = BeanInspector.callIfAvailable(this.targetObject, "getGOEPropertyUpdateLinks", null)) != null && o instanceof String[]) {
            this.maybeTriggerUpdates(propIndex, (String[])o);
        }
        if (Beans.isInstanceOf(this.targetObject, Component.class)) {
            ((Component)Beans.getInstanceOf(this.targetObject, Component.class)).repaint();
        }
        return true;
    }

    private boolean updateFieldView(int i) {
        boolean valChanged = false;
        boolean doRepaint = false;
        Object[] args = new Object[]{};
        Method getter = this.propertyDescriptors[i].getReadMethod();
        if (this.propertyDescriptors[i].isHidden() || this.propertyDescriptors[i].isExpert()) {
            if (this.propertyLabels[i] != null && this.propertyLabels[i].isVisible()) {
                this.viewWrappers[i].setVisible(false);
                this.views[i].setVisible(false);
                this.propertyLabels[i].setVisible(false);
                doRepaint = true;
            }
            return doRepaint;
        }
        if (this.propertyLabels[i] != null && !this.propertyLabels[i].isVisible()) {
            this.viewWrappers[i].setVisible(true);
            this.views[i].setVisible(true);
            this.propertyLabels[i].setVisible(true);
            doRepaint = true;
        }
        try {
            if (this.views[i] != null) {
                Object val = getter.invoke(this.targetObject, args);
                if (this.views[i] instanceof PropertyBoolSelector) {
                    boolean bl = valChanged = ((PropertyBoolSelector)this.views[i]).isSelected() != ((Boolean)val).booleanValue();
                    if (valChanged) {
                        ((PropertyBoolSelector)this.views[i]).setSelected((Boolean)val);
                    }
                } else if (this.views[i] instanceof PropertyText) {
                    boolean bl = valChanged = !((PropertyText)this.views[i]).getText().equals(val.toString());
                    if (valChanged) {
                        ((PropertyText)this.views[i]).setText(val.toString());
                    }
                } else if (!(this.views[i] instanceof PropertyPanel)) {
                    if (this.views[i] instanceof PropertyValueSelector) {
                        this.views[i].repaint();
                    } else {
                        System.out.println("Warning: Property \"" + i + "\" not recognized.  Skipping.");
                    }
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Exception in PropertySheetPanel");
        }
        return doRepaint;
    }

    private void maybeTriggerUpdates(int propIndex, String[] links) {
        int max = links.length;
        if (max % 2 == 1) {
            System.err.println("Error in PropertySheetPanel:maybeTriggerUpdates: odd number of strings provided!");
            --max;
        }
        for (int i = 0; i < max; i += 2) {
            if (!links[i].equals(this.propertyDescriptors[propIndex].getName())) continue;
            this.updateLinkedProperty(links[i + 1]);
        }
    }

    private void updateLinkedProperty(String propName) {
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            if (!this.propertyDescriptors[i].getName().equals(propName)) continue;
            Method getter = this.propertyDescriptors[i].getReadMethod();
            Object val = null;
            try {
                val = getter.invoke(this.targetObject, (Object[])null);
            }
            catch (Exception e) {
                val = null;
                e.printStackTrace();
            }
            if (val != null) {
                this.propertyEditors[i].setValue(val);
            } else {
                System.err.println("Error in PropertySheetPanel:updateLinkedProperty");
            }
            return;
        }
    }

    class ToolTipTable
    extends JTable {
        private String[] toolTips;

        public ToolTipTable(TableModel model) {
            super(model);
        }

        public void setToolTips(String[] toolTips) {
            this.toolTips = toolTips;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            try {
                if (this.toolTips != null && rowIndex <= this.toolTips.length) {
                    tip = this.toolTips[rowIndex];
                }
            }
            catch (RuntimeException e1) {
                // empty catch block
            }
            return tip;
        }
    }
}

