/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PropertySlider
extends JPanel {
    private PropertyEditor propertyEditor;
    private JSlider slider;

    PropertySlider(PropertyEditor pe) {
        this.propertyEditor = pe;
        this.slider = new JSlider(-10, 90, 20);
        this.slider.addChangeListener(new SliderListener());
        this.slider.setValue((Integer)this.propertyEditor.getValue());
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(5);
        this.slider.setPaintLabels(true);
        this.add(this.slider);
        this.propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertySlider.this.updateUs();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PropertySlider.this.updateEditor();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PropertySlider.this.updateEditor();
            }
        });
    }

    protected void updateUs() {
        try {
            this.slider.setValue((Integer)this.propertyEditor.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void updateEditor() {
        try {
            this.propertyEditor.setValue(this.slider.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    class SliderListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider s1 = (JSlider)e.getSource();
            System.out.println("slider" + s1.getValue());
            PropertySlider.this.updateEditor();
        }
    }
}

