/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditor;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class PropertyText
extends JTextField {
    private Logger LOGGER = Logger.getLogger(PropertyText.class.getName());
    private PropertyEditor propertyEditor;

    public PropertyText(PropertyEditor pe) {
        super(pe.getAsText());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.propertyEditor = pe;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PropertyText.this.updateEditor();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PropertyText.this.updateEditor();
            }
        });
    }

    protected void updateEditor() {
        try {
            String x = this.getText();
            if (!this.propertyEditor.getAsText().equals(x)) {
                this.propertyEditor.setAsText(x);
            }
        }
        catch (IllegalArgumentException ex) {
            this.LOGGER.finer(ex.getMessage());
        }
    }

    public boolean checkConsistency() {
        String x = this.getText();
        return x.equals(this.propertyEditor.getAsText());
    }

    public void updateFromEditor() {
        this.setText(this.propertyEditor.getAsText());
    }
}

