/*
 * Decompiled with CFR 0.152.
 */
package eva2.gui;

import eva2.gui.BeanInspector;
import eva2.gui.InterfaceStandaloneOptimization;
import eva2.gui.JParaPanel;
import eva2.gui.SwingWorker;
import eva2.gui.plot.Plot;
import eva2.optimization.OptimizationParameters;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.GAIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.crossover.CrossoverGAGINPoint;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.operator.mutation.MutateESLocal;
import eva2.optimization.operator.selection.SelectTournament;
import eva2.optimization.operator.terminators.EvaluationTerminator;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.EvolutionStrategies;
import eva2.optimization.strategies.GeneticAlgorithm;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.F1Problem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

@Description(value="This is a simple example framework for Evolutionary Algorithms.")
public class StandaloneOptimization
implements InterfaceStandaloneOptimization,
InterfacePopulationChangedEventListener,
Serializable {
    private transient JFrame mainFrame;
    private transient JPanel mainPanel;
    private transient JPanel buttonPanel;
    private transient JButton runButton;
    private transient JButton stopButton;
    private transient JButton continueButton;
    private transient JButton showSolutionButton;
    private transient JComponent optionsPanel;
    private transient JComponent parameterPanel1;
    private transient JComponent parameterPanel2;
    private transient JComponent statusPanel;
    private transient JLabel statusField;
    private transient JProgressBar progressBar;
    private transient SwingWorker worker;
    private transient boolean show = false;
    private OptimizationParameters optimizationParameters;
    private transient int multiRuns = 1;
    private transient int recentFunctionCalls;
    private transient int currentExperiment = 0;
    private transient int currentRun;
    private transient int currentProgress;
    private transient String experimentName;
    private transient String outputPath = "";
    private transient String outputFileName = "none";
    private transient Population backupPopulation;
    private transient boolean continueFlag;
    private transient Plot plot;
    private transient ArrayList performedRuns = new ArrayList();
    private transient ArrayList<Double[]> tmpData;
    private transient BufferedWriter outputFile;
    private transient List list;
    ActionListener runListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            StandaloneOptimization.this.worker = new SwingWorker(){

                @Override
                public Object construct() {
                    return StandaloneOptimization.this.doWork();
                }

                @Override
                public void finished() {
                    StandaloneOptimization.this.runButton.setEnabled(true);
                    StandaloneOptimization.this.continueButton.setEnabled(true);
                    StandaloneOptimization.this.stopButton.setEnabled(false);
                    StandaloneOptimization.this.backupPopulation = (Population)StandaloneOptimization.this.optimizationParameters.getOptimizer().getPopulation().clone();
                }
            };
            StandaloneOptimization.this.worker.start();
            StandaloneOptimization.this.runButton.setEnabled(false);
            StandaloneOptimization.this.continueButton.setEnabled(false);
            StandaloneOptimization.this.stopButton.setEnabled(true);
        }
    };
    ActionListener stopListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            StandaloneOptimization.this.runButton.setEnabled(true);
            StandaloneOptimization.this.continueButton.setEnabled(true);
            StandaloneOptimization.this.stopButton.setEnabled(false);
            StandaloneOptimization.this.worker.interrupt();
            for (int i = 0; i < StandaloneOptimization.this.multiRuns; ++i) {
                StandaloneOptimization.this.plot.clearGraph(1000 + i);
            }
        }
    };
    ActionListener continueListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            StandaloneOptimization.this.worker = new SwingWorker(){

                @Override
                public Object construct() {
                    return StandaloneOptimization.this.doWork();
                }

                @Override
                public void finished() {
                    StandaloneOptimization.this.runButton.setEnabled(true);
                    StandaloneOptimization.this.continueButton.setEnabled(true);
                    StandaloneOptimization.this.stopButton.setEnabled(false);
                    StandaloneOptimization.this.backupPopulation = (Population)StandaloneOptimization.this.optimizationParameters.getOptimizer().getPopulation().clone();
                    StandaloneOptimization.this.continueFlag = false;
                }
            };
            StandaloneOptimization.this.continueFlag = true;
            StandaloneOptimization.this.multiRuns = 1;
            StandaloneOptimization.this.worker.start();
            StandaloneOptimization.this.runButton.setEnabled(false);
            StandaloneOptimization.this.continueButton.setEnabled(false);
            StandaloneOptimization.this.stopButton.setEnabled(true);
        }
    };
    ActionListener showSolListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JFrame frame = new JFrame();
            frame.setTitle("The current best solution for " + StandaloneOptimization.this.optimizationParameters.getProblem().getName());
            frame.setSize(400, 300);
            frame.setLocation(450, 250);
            Population pop = StandaloneOptimization.this.optimizationParameters.getOptimizer().getPopulation();
            frame.getContentPane().add(StandaloneOptimization.this.optimizationParameters.getProblem().drawIndividual(pop.getGeneration(), pop.getFunctionCalls(), pop.getBestEAIndividual()));
            frame.validate();
            frame.setVisible(true);
        }
    };

    public StandaloneOptimization() {
        this.optimizationParameters = OptimizationParameters.getInstance();
        this.experimentName = this.optimizationParameters.getOptimizer().getName() + "-" + this.performedRuns.size();
        this.optimizationParameters.addPopulationChangedEventListener(this);
        RNG.setRandomSeed(this.optimizationParameters.getRandomSeed());
    }

    public OptimizationParameters getGOParameters() {
        return this.optimizationParameters;
    }

    public void initFrame() {
        this.progressBar = new JProgressBar();
        this.mainFrame = new JFrame();
        this.mainFrame.setTitle("Genetic Optimizing");
        this.mainFrame.setSize(500, 400);
        this.mainFrame.setLocation(530, 50);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        this.mainPanel = new JPanel();
        this.mainFrame.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.runButton = new JButton("Run");
        this.runButton.addActionListener(this.runListener);
        this.runButton.setEnabled(true);
        this.runButton.setToolTipText("Run the optimization process with the current parameter settings.");
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(this.stopListener);
        this.stopButton.setEnabled(false);
        this.stopButton.setToolTipText("Stop the runnig the optimization process.");
        this.continueButton = new JButton("Continue");
        this.continueButton.addActionListener(this.continueListener);
        this.continueButton.setEnabled(false);
        this.continueButton.setToolTipText("Resume the previous optimization (check termination criteria and multiruns = 1!).");
        this.showSolutionButton = new JButton("Show Solution");
        this.showSolutionButton.addActionListener(this.showSolListener);
        this.showSolutionButton.setEnabled(true);
        this.showSolutionButton.setToolTipText("Show the current best solution.");
        this.buttonPanel.add(this.runButton);
        this.buttonPanel.add(this.continueButton);
        this.buttonPanel.add(this.stopButton);
        this.buttonPanel.add(this.showSolutionButton);
        this.mainPanel.add((Component)this.buttonPanel, "North");
        JParaPanel paraPanel = new JParaPanel(this, "MyGUI");
        Class<?> object = null;
        Class<?> editor = null;
        String tmp = "eva2.optimization.tools.InterfaceTest";
        try {
            object = Class.forName(tmp);
        }
        catch (ClassNotFoundException e) {
            System.out.println("No Class found for " + tmp);
        }
        tmp = "eva2.gui.editor.GenericObjectEditor";
        try {
            editor = Class.forName(tmp);
        }
        catch (ClassNotFoundException e) {
            System.out.println("No Class found for " + tmp);
        }
        if (object != null && editor != null) {
            paraPanel.registerEditor(object, editor);
        }
        this.parameterPanel1 = paraPanel.makePanel();
        this.optionsPanel = new JTabbedPane();
        JParaPanel paraPanel2 = new JParaPanel(this.optimizationParameters, "MyGUI");
        this.parameterPanel2 = paraPanel2.makePanel();
        ((JTabbedPane)this.optionsPanel).addTab("Optimization Parameters", this.parameterPanel2);
        ((JTabbedPane)this.optionsPanel).addTab("Statistics", this.parameterPanel1);
        this.mainPanel.add((Component)this.optionsPanel, "Center");
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BorderLayout());
        this.statusField = new JLabel("Click Run to begin...");
        this.progressBar = new JProgressBar();
        this.statusPanel.add((Component)this.statusField, "North");
        this.statusPanel.add((Component)this.progressBar, "South");
        this.mainPanel.add((Component)this.statusPanel, "South");
        double[] tmpD = new double[]{1.0, 1.0};
        this.plot = new Plot("EA Lecture Plot", "Function calls", "Fitness", true);
        this.mainFrame.validate();
        this.mainFrame.setVisible(true);
    }

    @Override
    public void startExperiment() {
        this.optimizationParameters.setOptimizer(new EvolutionStrategies());
        this.optimizationParameters.setProblem(new F1Problem());
        EvaluationTerminator terminator = new EvaluationTerminator();
        terminator.setFitnessCalls(50000);
        this.optimizationParameters.setTerminator(terminator);
        this.multiRuns = 10;
        int experimentType = 0;
        this.experimentName = "InferringGRN";
        this.outputFileName = "Result";
        this.outputPath = "results/";
        AbstractEAIndividual tmpIndy = new ESIndividualDoubleData();
        MutateESFixedStepSize tmpMut = new MutateESFixedStepSize();
        switch (experimentType) {
            case 0: {
                this.outputFileName = "Prim4_StructSkelGATESTIT";
                GeneticAlgorithm ga = new GeneticAlgorithm();
                SelectTournament tour = new SelectTournament();
                tour.setTournamentSize(10);
                ga.setParentSelection(tour);
                ga.setPartnerSelection(tour);
                this.optimizationParameters.setOptimizer(ga);
                this.optimizationParameters.getOptimizer().getPopulation().setTargetSize(100);
                F1Problem problem = new F1Problem();
                tmpIndy = new GAIndividualDoubleData();
                ((GAIndividualDoubleData)tmpIndy).setCrossoverOperator(new CrossoverGAGINPoint());
                ((GAIndividualDoubleData)tmpIndy).setCrossoverProbability(1.0);
                ((GAIndividualDoubleData)tmpIndy).setMutationProbability(1.0);
                problem.setEAIndividual((InterfaceDataTypeDouble)((Object)tmpIndy));
                this.optimizationParameters.getOptimizer().setProblem(problem);
                this.optimizationParameters.getOptimizer().addPopulationChangedEventListener(this);
                this.doWork();
                break;
            }
            case 1: {
                this.outputFileName = "X360_StandardES";
                EvolutionStrategies es = new EvolutionStrategies();
                this.optimizationParameters.setOptimizer(es);
                this.optimizationParameters.getOptimizer().getPopulation().setTargetSize(50);
                F1Problem problem = new F1Problem();
                tmpIndy = new ESIndividualDoubleData();
                ((AbstractEAIndividual)tmpIndy).setMutationOperator(new MutateESLocal());
                problem.setEAIndividual((InterfaceDataTypeDouble)((Object)tmpIndy));
                this.optimizationParameters.getOptimizer().setProblem(problem);
                this.optimizationParameters.getOptimizer().addPopulationChangedEventListener(this);
                this.doWork();
                break;
            }
        }
    }

    public Object doWork() {
        try {
            this.optimizationParameters.saveInstance();
            if (this.show) {
                this.statusField.setText("Optimizing...");
            }
            RNG.setRandomSeed(this.optimizationParameters.getRandomSeed());
            if (!this.outputFileName.equalsIgnoreCase("none")) {
                String name = "";
                SimpleDateFormat formatter = new SimpleDateFormat("E'_'yyyy.MM.dd'_'HH.mm.ss");
                String startDate = formatter.format(new Date());
                name = this.outputPath + this.outputFileName + "_" + this.experimentName + "_" + startDate + ".dat";
                try {
                    this.outputFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
                }
                catch (FileNotFoundException e) {
                    System.out.println("Could not open output file! Filename: " + name);
                }
            } else {
                this.outputFile = null;
            }
            this.optimizationParameters.getProblem().initializeProblem();
            this.optimizationParameters.getOptimizer().setProblem(this.optimizationParameters.getProblem());
            ArrayList<ArrayList<Double[]>> tmpMultiRun = new ArrayList<ArrayList<Double[]>>();
            this.performedRuns.add(tmpMultiRun);
            for (int j = 0; j < this.multiRuns; ++j) {
                this.optimizationParameters.getProblem().initializeProblem();
                this.tmpData = new ArrayList();
                this.currentRun = j;
                if (this.show) {
                    this.statusField.setText("Optimizing Run " + (j + 1) + " of " + this.multiRuns + " Multi Runs...");
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.writeToFile(" FitnessCalls\t Best\t Mean\t Worst \t" + BeanInspector.toString(this.optimizationParameters.getProblem().getAdditionalDataHeader(), '\t', false, ""));
                if (this.continueFlag && this.backupPopulation != null) {
                    this.recentFunctionCalls += this.backupPopulation.getFunctionCalls();
                    this.optimizationParameters.getOptimizer().getProblem().initializeProblem();
                    this.optimizationParameters.getOptimizer().addPopulationChangedEventListener(null);
                    this.optimizationParameters.getOptimizer().setPopulation(this.backupPopulation);
                    this.optimizationParameters.getOptimizer().getProblem().evaluate(this.optimizationParameters.getOptimizer().getPopulation());
                    this.optimizationParameters.getOptimizer().getProblem().evaluate(this.optimizationParameters.getOptimizer().getPopulation().getArchive());
                    this.optimizationParameters.getOptimizer().initializeByPopulation(this.backupPopulation, false);
                    this.optimizationParameters.getOptimizer().getPopulation().setFunctionCalls(0);
                    this.optimizationParameters.addPopulationChangedEventListener(this);
                } else {
                    this.recentFunctionCalls = 0;
                    this.optimizationParameters.getOptimizer().initialize();
                }
                while (!this.optimizationParameters.getTerminator().isTerminated(this.optimizationParameters.getOptimizer().getPopulation())) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    this.optimizationParameters.getOptimizer().optimize();
                }
                System.gc();
                tmpMultiRun.add(this.tmpData);
            }
            if (this.show) {
                this.plot.setInfoString(this.currentExperiment, this.experimentName, 0.5f);
            }
            if (this.show) {
                this.draw();
            }
            this.experimentName = this.optimizationParameters.getOptimizer().getName() + "-" + this.performedRuns.size();
        }
        catch (InterruptedException e) {
            this.updateStatus(0);
            if (this.show) {
                this.statusField.setText("Interrupted...");
            }
            return "Interrupted";
        }
        if (this.outputFile != null) {
            try {
                this.outputFile.close();
            }
            catch (IOException e) {
                System.out.println("Failed to close output file!");
            }
        }
        if (this.show) {
            for (int i = 0; i < this.multiRuns; ++i) {
                this.plot.clearGraph(1000 + i);
            }
        }
        this.updateStatus(0);
        if (this.show) {
            this.statusField.setText("Finished...");
        }
        return "All Done";
    }

    private void draw() {
        for (int i = this.performedRuns.size() - 1; i < this.performedRuns.size(); ++i) {
            Double[] tmpD;
            int p;
            ArrayList singleRun;
            int j;
            ArrayList multiRuns = (ArrayList)this.performedRuns.get(i);
            int minRunLen = Integer.MAX_VALUE;
            for (j = 0; j < multiRuns.size(); ++j) {
                singleRun = (ArrayList)multiRuns.get(j);
                minRunLen = Math.min(minRunLen, singleRun.size());
            }
            double[][] data = new double[minRunLen][3];
            for (j = 0; j < multiRuns.size(); ++j) {
                singleRun = (ArrayList)multiRuns.get(j);
                for (p = 0; p < data.length; ++p) {
                    tmpD = (Double[])singleRun.get(p);
                    data[p][0] = tmpD[0];
                    double[] dArray = data[p];
                    dArray[1] = dArray[1] + tmpD[1] / (double)multiRuns.size();
                }
            }
            for (j = 0; j < multiRuns.size(); ++j) {
                singleRun = (ArrayList)multiRuns.get(j);
                for (p = 0; p < data.length; ++p) {
                    tmpD = (Double[])singleRun.get(p);
                    double[] dArray = data[p];
                    dArray[2] = dArray[2] + Math.pow(data[p][1] - tmpD[1], 2.0) / (double)multiRuns.size();
                }
            }
            this.plot.clearGraph(this.currentExperiment);
            for (j = 0; j < data.length; ++j) {
                if (this.continueFlag) {
                    this.plot.setConnectedPoint(data[j][0] + (double)this.recentFunctionCalls, data[j][1], this.currentExperiment);
                    continue;
                }
                this.plot.setConnectedPoint(data[j][0], data[j][1], this.currentExperiment);
            }
            ++this.currentExperiment;
        }
    }

    void updateStatus(final int i) {
        if (this.progressBar != null) {
            Runnable doSetProgressBarValue = new Runnable(){

                @Override
                public void run() {
                    StandaloneOptimization.this.progressBar.setValue(i);
                }
            };
            SwingUtilities.invokeLater(doSetProgressBarValue);
        }
    }

    public static void main(String[] args) {
        StandaloneOptimization program = new StandaloneOptimization();
        RNG.setRandomSeed(1L);
        program.initFrame();
        program.setShow(true);
    }

    @Override
    public void setShow(boolean t) {
        this.show = t;
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.equals("NextGenerationPerformed")) {
            Population population = ((InterfaceOptimizer)source).getPopulation();
            double x = 100 / this.multiRuns;
            if (this.optimizationParameters.getTerminator() instanceof EvaluationTerminator) {
                double y = x / (double)((EvaluationTerminator)this.optimizationParameters.getTerminator()).getFitnessCalls();
                this.currentProgress = (int)((double)this.currentRun * x + (double)population.getFunctionCalls() * y);
            } else {
                this.currentProgress = (int)((double)this.currentRun * x);
            }
            this.updateStatus(this.currentProgress);
            double tmpd = 0.0;
            StringBuilder tmpLine = new StringBuilder("");
            tmpLine.append(population.getFunctionCalls());
            tmpLine.append("\t");
            tmpLine.append(population.getBestEAIndividual().getFitness(0));
            tmpLine.append("\t");
            for (int i = 0; i < population.size(); ++i) {
                tmpd += ((AbstractEAIndividual)population.get(i)).getFitness(0) / (double)population.size();
            }
            tmpLine.append("\t");
            tmpLine.append(tmpd);
            tmpLine.append("\t");
            tmpLine.append(population.getWorstEAIndividual().getFitness(0));
            this.writeToFile(tmpLine.toString());
            Double[] tmpData = new Double[]{population.getFunctionCalls(), this.optimizationParameters.getProblem().getDoublePlotValue(population)};
            if (this.plot != null) {
                if (this.continueFlag) {
                    this.plot.setConnectedPoint(tmpData[0] + (double)this.recentFunctionCalls, tmpData[1], 1000 + this.currentRun);
                } else {
                    this.plot.setConnectedPoint(tmpData[0], tmpData[1], 1000 + this.currentRun);
                }
            }
            this.tmpData.add(tmpData);
        }
    }

    private void writeToFile(String line) {
        String write = line + "\n";
        if (this.outputFile == null) {
            return;
        }
        try {
            this.outputFile.write(write, 0, write.length());
            this.outputFile.flush();
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
    }

    public String getName() {
        return "EA Lecture GUI";
    }

    public void setMultiRuns(int multiruns) {
        this.multiRuns = multiruns;
    }

    public int getMultiRuns() {
        return this.multiRuns;
    }

    public String multiRunsTipText() {
        return "Multiple runs may be necessary to produce reliable results for stochastic optimizing algorithms.";
    }

    public void setExpName(String experimentName) {
        this.experimentName = experimentName;
    }

    public String getExpName() {
        return this.experimentName;
    }

    public String expNameTipText() {
        return "Set the name of the experiment as it will occur in the legend.";
    }

    public void setOutputFileName(String name) {
        this.outputFileName = name;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String outputFileNameTipText() {
        return "Set the name for the output file, if 'none' no output file will be created.";
    }

    public void setList(List name) {
        this.list = name;
    }

    public List getList() {
        return this.list;
    }

    public String listTipText() {
        return "Set the name for the output file, if 'none' no output file will be created.";
    }
}

